---
generated_at: 2026-01-22 14:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：85-access_granted_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビューは低優先度で問題なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/members/access_granted_mailer.rb`（11-17行目: emailメソッド実装）
- E-02: `app/mailers/members/access_granted_mailer.rb`（24-31行目: valid_to_email?）
- E-03: `app/mailers/members/access_granted_mailer.rb`（40-42行目: notification_group）
- E-04: `app/mailers/members/access_granted_mailer.rb`（49-50行目: email_subject_text）
- E-05: `app/models/member.rb`（718-728行目: send_access_granted_notification）
- E-06: `app/models/member.rb`（741-751行目: post_create_member_hook）
- E-07: `app/models/member.rb`（753-762行目: post_update_hook）
- E-08: `app/views/members/access_granted_mailer/email.text.erb`（テンプレート）
- E-09: `app/mailers/members/access_granted_mailer.rb`（37-39行目: member_source_organization）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクセス権付与時にユーザーに通知される | E-05, E-06 | ○ |
| C-02 | Members::AccessGrantedMailer.emailが呼び出される | E-01, E-05 | ○ |
| C-03 | 送信方式は非同期（deliver_later） | E-05（728行目） | ○ |
| C-04 | pending状態では送信されない | E-06（unless条件） | ○ |
| C-05 | importing状態では送信されない | E-06（unless条件） | ○ |
| C-06 | 個人プロジェクトオーナーには送信されない | E-06（745行目） | ○ |
| C-07 | notifiable?(:mention)チェックが行われる | E-05（726行目） | ○ |
| C-08 | valid_to_email?でmember.blank?チェック | E-02 | ○ |
| C-09 | 件名に「Access to the」「was granted」が含まれる | E-04 | ○ |
| C-10 | source_name, source_type, role_nameがテンプレートで使用される | E-08 | ○ |
| C-11 | leave_urlが含まれる | E-08（21行目） | ○ |
| C-12 | notification_groupの決定ロジック | E-03 | ○ |
| C-13 | params[:member]でMemberが渡される | E-01（33-35行目） | ○ |
| C-14 | params[:member_source_type]でソースタイプが渡される | E-01（44-46行目） | ○ |
| C-15 | member_sourceはmember.sourceから取得 | E-01（22行目delegate） | ○ |
| C-16 | member_source_organizationも参照される | E-09 | ○ |
| C-17 | ui_for_organizations Feature flagで表示内容が変わる | E-08（7行目） | ○ |
| C-18 | role_typeはmember.present.role_typeから取得 | E-08（5行目） | ○ |
| C-19 | mail_with_localeでメール送信 | E-01（14-17行目） | ○ |
| C-20 | post_update_hookでアクセスレベル変更時も送信 | E-07（754-756行目） | ○ |
| C-21 | レイアウトは'mailer' | E-01（9行目） | ○ |
| C-22 | organization_urlがFeature flag有効時に含まれる | E-08（11行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。すべての主張に対して根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な通知ロジックはすべてソースコードで確認済み
- 0: 低リスク - Feature flag条件分岐も確認済み
- 0: 低リスク - テンプレート変数は実際のテンプレートファイルで確認済み

## 6) レビュアーチェックリスト（最小）
- [x] 通知トリガー（post_create_member_hook, post_update_hook）の確認
- [x] 送信抑止条件（pending, importing, personal_namespace_holder?）の確認
- [x] メールテンプレートの内容確認
- [x] Feature flag ui_for_organizations の挙動確認
- [x] notifiable?による送信制御の確認
- [x] organization情報の取得ロジック確認
