---
generated_at: 2026-01-22 14:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：86-access_requested_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビューは低優先度で問題なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/members/access_requested_mailer.rb`（11-18行目: emailメソッド実装）
- E-02: `app/mailers/members/access_requested_mailer.rb`（24-31行目: valid_to_email?）
- E-03: `app/mailers/members/access_requested_mailer.rb`（45-47行目: email_subject_text）
- E-04: `app/models/member.rb`（708-716行目: send_request）
- E-05: `app/models/member.rb`（378行目: after_commit :send_request）
- E-06: `app/models/member.rb`（23行目: ACCESS_REQUEST_APPROVERS_TO_BE_NOTIFIED_LIMIT）
- E-07: `app/views/members/access_requested_mailer/email.text.erb`（テンプレート）
- E-08: `app/mailers/members/access_requested_mailer.rb`（33-35行目: target_type）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクセスリクエスト時に承認者に通知される | E-04 | ○ |
| C-02 | Members::AccessRequestedMailer.emailが呼び出される | E-01, E-04 | ○ |
| C-03 | after_commit :send_requestで呼び出される | E-05 | ○ |
| C-04 | notifiable?(:subscription)チェックが行われる | E-04（709行目） | ○ |
| C-05 | access_request_approvers_to_be_notifiedで承認者取得 | E-04（710行目） | ○ |
| C-06 | 承認者上限は10人 | E-06 | ○ |
| C-07 | valid_to_email?でmember.blank?チェック | E-02 | ○ |
| C-08 | 件名に「Request to join」が含まれる | E-03 | ○ |
| C-09 | requester_name, requester_urlがテンプレートで使用される | E-07（1行目） | ○ |
| C-10 | access_levelがテンプレートで使用される | E-07（1行目human_access） | ○ |
| C-11 | members_page_urlが含まれる | E-07（3行目） | ○ |
| C-12 | target_typeでソースタイプを取得 | E-08 | ○ |
| C-13 | params[:member]でMemberが渡される | E-01（37-39行目） | ○ |
| C-14 | params[:recipient]で受信者が渡される | E-01（41-43行目） | ○ |
| C-15 | member_sourceはmember.sourceから取得 | E-01（22行目delegate） | ○ |
| C-16 | mail_with_localeでメール送信 | E-01（14-17行目） | ○ |
| C-17 | Todo作成も同時に行われる | E-04（715行目） | ○ |
| C-18 | レイアウトは'mailer' | E-01（9行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。すべての主張に対して根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な通知ロジックはすべてソースコードで確認済み
- 0: 低リスク - 承認者取得ロジックも確認済み
- 0: 低リスク - テンプレート変数は実際のテンプレートファイルで確認済み

## 6) レビュアーチェックリスト（最小）
- [x] 通知トリガー（after_commit :send_request）の確認
- [x] 承認者決定ロジック（access_request_approvers_to_be_notified）の確認
- [x] メールテンプレートの内容確認
- [x] notifiable?による送信制御の確認
- [x] Todo作成との連携確認
