---
generated_at: 2026-01-22 15:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：87-about_to_expire_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビューは低優先度で問題なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/members/about_to_expire_mailer.rb`（11-18行目: emailメソッド実装）
- E-02: `app/mailers/members/about_to_expire_mailer.rb`（30-32行目: days_to_expire）
- E-03: `app/mailers/members/about_to_expire_mailer.rb`（34-36行目: email_subject_text）
- E-04: `app/models/member.rb`（199行目: expiring_and_not_notifiedスコープ）
- E-05: `app/views/members/about_to_expire_mailer/email.text.erb`（テンプレート）
- E-06: `app/mailers/members/about_to_expire_mailer.rb`（7行目: helper_method定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メンバーシップ有効期限が近づくと通知される | E-01, E-04 | ○ |
| C-02 | Members::AboutToExpireMailer.emailが呼び出される | E-01 | ○ |
| C-03 | member.blank?チェックが行われる | E-01（12行目） | ○ |
| C-04 | expires_at.blank?チェックが行われる | E-01（12行目） | ○ |
| C-05 | days_to_expire <= 0チェックが行われる | E-01（12行目） | ○ |
| C-06 | notifiable?(:mention)チェックが行われる | E-01（13行目） | ○ |
| C-07 | days_to_expireの計算式が正しい | E-02 | ○ |
| C-08 | 件名に「will expire in {days} days」が含まれる | E-03 | ○ |
| C-09 | expiring_and_not_notifiedスコープで対象抽出 | E-04 | ○ |
| C-10 | ヘルパーメソッドがテンプレートで使用される | E-05, E-06 | ○ |
| C-11 | params[:member]でMemberが渡される | E-01（26-28行目） | ○ |
| C-12 | member_sourceはmember.sourceから取得 | E-01（24行目delegate） | ○ |
| C-13 | mail_with_localeでメール送信 | E-01（15-18行目） | ○ |
| C-14 | レイアウトは'mailer' | E-01（9行目） | ○ |
| C-15 | userはmember.userから取得 | E-01（23行目delegate） | ○ |
| C-16 | say_hi, member_about_to_expire_textヘルパーを使用 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。すべての主張に対して根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な通知ロジックはすべてソースコードで確認済み
- 0: 低リスク - 日数計算ロジックも確認済み
- 0: 低リスク - テンプレートヘルパーの使用も確認済み

## 6) レビュアーチェックリスト（最小）
- [x] 通知トリガー（バッチ処理）の確認
- [x] 対象メンバー抽出ロジック（expiring_and_not_notified）の確認
- [x] 送信抑止条件の確認
- [x] 日数計算ロジックの確認
- [x] メールテンプレートの内容確認
