---
generated_at: 2026-01-22 15:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：88-invite_reminder_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビューは低優先度で問題なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/members/invite_reminder_mailer.rb`（13-28行目: emailメソッド実装）
- E-02: `app/mailers/members/invite_reminder_mailer.rb`（34-39行目: email_klass）
- E-03: `app/mailers/members/invite_reminder_mailer.rb`（42-48行目: valid_to_email?）
- E-04: `app/mailers/members/invite_reminder_mailer.rb`（58-79行目: FirstEmail）
- E-05: `app/mailers/members/invite_reminder_mailer.rb`（81-107行目: SecondEmail）
- E-06: `app/mailers/members/invite_reminder_mailer.rb`（109-133行目: LastEmail）
- E-07: `app/models/member.rb`（604-612行目: send_invitation_reminder）
- E-08: `app/models/member.rb`（647-649行目: invite_to_unknown_user?）
- E-09: `app/views/members/invite_reminder_mailer/email.text.erb`（テンプレート）
- E-10: `app/mailers/members/invite_reminder_mailer.rb`（12行目: layout）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 未承諾の招待に対してリマインダーが送信される | E-01, E-07 | ○ |
| C-02 | Members::InviteReminderMailer.emailが呼び出される | E-01, E-07 | ○ |
| C-03 | send_invitation_reminderで呼び出される | E-07 | ○ |
| C-04 | created_by存在チェックが行われる | E-03（43行目） | ○ |
| C-05 | invite_to_unknown_user?チェックが行われる | E-03（43行目）, E-08 | ○ |
| C-06 | 3つのメールクラスがある（FirstEmail, SecondEmail, LastEmail） | E-02, E-04, E-05, E-06 | ○ |
| C-07 | reminder_indexで使用するクラスが決定される | E-02 | ○ |
| C-08 | FirstEmailの件名パターンが正しい | E-04（59-61行目） | ○ |
| C-09 | SecondEmailの件名パターンが正しい | E-05（84-86行目） | ○ |
| C-10 | LastEmailの件名パターンが正しい | E-06（110-112行目） | ○ |
| C-11 | LastEmailでinvitation_ageが計算される | E-06（128-132行目） | ○ |
| C-12 | invite_urlがテンプレートで使用される | E-09（12行目） | ○ |
| C-13 | decline_invite_urlがテンプレートで使用される | E-09（13行目） | ○ |
| C-14 | レイアウトはunknown_user_mailer | E-10 | ○ |
| C-15 | reminder_common_body_optionsヘルパーが使用される | E-01（9行目）, E-09 | ○ |
| C-16 | mail_with_localeでメール送信 | E-01（24-27行目） | ○ |
| C-17 | トークン確認/生成が行われる | E-07（607行目） | ○ |
| C-18 | SecondEmailでwave絵文字が使用される | E-05（92-94行目） | ○ |
| C-19 | roleはhuman_access.downcaseから取得 | E-01（54行目） | ○ |
| C-20 | member.blank?の場合はログ出力 | E-03（45行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。すべての主張に対して根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な通知ロジックはすべてソースコードで確認済み
- 0: 低リスク - 3つのメールクラスの使い分けも確認済み
- 0: 低リスク - テンプレート変数は実際のテンプレートファイルで確認済み

## 6) レビュアーチェックリスト（最小）
- [x] 通知トリガー（send_invitation_reminder）の確認
- [x] 送信抑止条件（created_by, invite_to_unknown_user?）の確認
- [x] 3つのメールクラスの使い分け確認
- [x] 各メールクラスの件名・本文パターン確認
- [x] メールテンプレートの内容確認
