---
generated_at: 2026-01-22 15:10:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：89-expiration_date_updated_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビューは低優先度で問題なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/members/expiration_date_updated_mailer.rb`（11-18行目: emailメソッド実装）
- E-02: `app/mailers/members/expiration_date_updated_mailer.rb`（24-41行目: valid_to_email?）
- E-03: `app/mailers/members/expiration_date_updated_mailer.rb`（55-61行目: email_subject_text）
- E-04: `app/models/member.rb`（758-759行目: post_update_hook内の呼び出し）
- E-05: `app/views/members/expiration_date_updated_mailer/email.text.erb`（テンプレート）
- E-06: `app/mailers/members/expiration_date_updated_mailer.rb`（9行目: layout）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メンバーシップ有効期限変更時に通知される | E-01, E-04 | ○ |
| C-02 | Members::ExpirationDateUpdatedMailer.emailが呼び出される | E-01, E-04 | ○ |
| C-03 | post_update_hookで呼び出される | E-04 | ○ |
| C-04 | saved_change_to_expires_at?チェックが行われる | E-04 | ○ |
| C-05 | member.blank?チェックが行われる | E-02（25-28行目） | ○ |
| C-06 | is_a?(Group)チェックが行われる | E-02（30-33行目） | ○ |
| C-07 | notifiable?(:mention)チェックが行われる | E-02（35-38行目） | ○ |
| C-08 | プロジェクトメンバーには送信されない | E-02（30-33行目） | ○ |
| C-09 | member.expires?で件名が分岐する | E-03 | ○ |
| C-10 | 件名「changed」がexpires?=trueの場合 | E-03（57行目） | ○ |
| C-11 | 件名「removed」がexpires?=falseの場合 | E-03（59行目） | ○ |
| C-12 | ヘルパーメソッドがテンプレートで使用される | E-05 | ○ |
| C-13 | params[:member]でMemberが渡される | E-01（43-45行目） | ○ |
| C-14 | params[:member_source_type]でソースタイプが渡される | E-01（51-53行目） | ○ |
| C-15 | mail_with_localeでメール送信 | E-01（14-17行目） | ○ |
| C-16 | レイアウトは'mailer' | E-06 | ○ |
| C-17 | 各エラーケースでログ出力される | E-02（26, 32, 37行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。すべての主張に対して根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な通知ロジックはすべてソースコードで確認済み
- 0: 低リスク - グループメンバー限定の制約も確認済み
- 0: 低リスク - 件名の分岐ロジックも確認済み

## 6) レビュアーチェックリスト（最小）
- [x] 通知トリガー（post_update_hook, saved_change_to_expires_at?）の確認
- [x] 送信抑止条件（member.blank?, is_a?(Group), notifiable?）の確認
- [x] 件名分岐ロジック（member.expires?）の確認
- [x] メールテンプレートの内容確認
- [x] エラー時のログ出力確認
