---
generated_at: 2026-01-22 14:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：9-issue_status_changed_email.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ビューテンプレートの詳細**：issue_status_changed_email専用テンプレートの存在確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` - reopen_issueメソッド（427-428行目）、reopen_resource_email（862-868行目）
- E-02: `app/mailers/emails/issues.rb` - issue_status_changed_emailメソッド（119-132行目）
- E-03: `app/mailers/notify.rb` - mail_answer_thread（188-196行目）
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | issue_status_changed_emailはステータス変更通知を送信 | E-01, E-02 | ○ |
| C-02 | NotificationService.reopen_issue()がエントリーポイント | E-01 (427行目) | ○ |
| C-03 | reopen_resource_emailを呼び出し | E-01 (428行目) | ○ |
| C-04 | method = :issue_status_changed_email | E-01 (428行目) | ○ |
| C-05 | status = 'reopened'が渡される | E-01 (428行目) | ○ |
| C-06 | 非同期送信（deliver_later）を使用 | E-01 (866行目) | ○ |
| C-07 | action: "reopen"で受信者構築 | E-01 (863行目) | ○ |
| C-08 | 5引数でメソッド呼び出し | E-02 (119行目) | ○ |
| C-09 | setup_issue_mailでインスタンス変数設定 | E-02 (120行目) | ○ |
| C-10 | @issue_status設定 | E-02 (122行目) | ○ |
| C-11 | @updated_by設定 | E-02 (123行目) | ○ |
| C-12 | mail_answer_threadでスレッド返信形式 | E-02 (124-131行目), E-03 | ○ |
| C-13 | X-GitLab-ConfidentialIssueヘッダー設定 | E-02 (issue_thread_options) | ○ |
| C-14 | 件名にRe:プレフィックス付与 | E-03 (193行目) | ○ |
| C-15 | SentNotification.recordで送信記録作成 | E-02 (setup_issue_mail内) | ○ |
| C-16 | skip_current_user: trueで実行者除外 | E-01 (暗黙的default) | ○ |
| C-17 | BuildService.build_recipients呼び出し | E-01 (863行目) | ○ |
| C-18 | ビューテンプレートの詳細 | **根拠なし（テンプレート未確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- issue_status_changed_email専用テンプレートの確認
  - 候補：app/views/notify/issue_status_changed_email.html.haml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メール送信処理の基本フロー
- 0: 低リスク - ステータス情報の設定
- 1: 中リスク - テンプレートの内容（未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] issue_status_changed_email専用テンプレートの存在確認
- [ ] @issue_statusの表示形式確認
- [ ] ステータス変更実行者が通知対象から除外されているか確認
- [ ] reopen以外のステータス変更でも使用されるか確認
