---
generated_at: 2026-01-22 15:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-invite_declined_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビューは低優先度で問題なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/members/invite_declined_mailer.rb`（11-18行目: emailメソッド実装）
- E-02: `app/mailers/members/invite_declined_mailer.rb`（25-29行目: valid_to_email?）
- E-03: `app/models/member.rb`（576-584行目: decline_invite!）
- E-04: `app/models/member.rb`（803-805行目: after_decline_invite）
- E-05: `app/views/members/invite_declined_mailer/email.text.erb`（テンプレート）
- E-06: `app/mailers/members/invite_declined_mailer.rb`（22行目: delegate）
- E-07: `app/mailers/members/invite_declined_mailer.rb`（9行目: layout）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 招待辞退時に招待者に通知される | E-01, E-03, E-04 | ○ |
| C-02 | Members::InviteDeclinedMailer.emailが呼び出される | E-01, E-04 | ○ |
| C-03 | decline_invite!で呼び出される | E-03, E-04 | ○ |
| C-04 | Memberレコードが削除される | E-03（579行目） | ○ |
| C-05 | member && member_created_by.present?チェック | E-02 | ○ |
| C-06 | 通知設定に関係なく送信される | E-02（コメント26-27行目） | ○ |
| C-07 | 件名は「Invitation declined」 | E-01（16行目） | ○ |
| C-08 | invite_emailがテンプレートで使用される | E-05（1行目） | ○ |
| C-09 | source_name, source_typeがテンプレートで使用される | E-05（1行目） | ○ |
| C-10 | source_urlが含まれる | E-05（3行目） | ○ |
| C-11 | member_invite_emailでメールアドレスを取得 | E-06（delegate） | ○ |
| C-12 | member_created_byで招待者を取得 | E-06（delegate） | ○ |
| C-13 | params[:member]でMemberが渡される | E-01（31-33行目） | ○ |
| C-14 | mail_with_localeでメール送信 | E-01（14-17行目） | ○ |
| C-15 | レイアウトは'mailer' | E-07 | ○ |
| C-16 | after_decline_invokeはdestroy成功後に呼ばれる | E-03（581行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。すべての主張に対して根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な通知ロジックはすべてソースコードで確認済み
- 0: 低リスク - 通知設定を無視する理由もコードコメントで確認済み
- 0: 低リスク - テンプレート変数は実際のテンプレートファイルで確認済み

## 6) レビュアーチェックリスト（最小）
- [x] 通知トリガー（decline_invite!, after_decline_invite）の確認
- [x] 送信先決定ロジック（member_created_by）の確認
- [x] 通知設定を無視する理由の確認
- [x] メールテンプレートの内容確認
- [x] Memberレコード削除との連携確認
