---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：91-invite_accepted_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **リトライ仕様**：Sidekiqの設定ファイルを確認していないため根拠不足
  2. **セキュリティ考慮事項**：HTMLエスケープ処理の実装確認が必要
  3. **レート制限設定**：個別通知へのレート制限適用有無の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/mailers/members/invite_accepted_mailer.rb`
- E-02: `app/models/member.rb` (795-801行目)
- E-03: `app/views/members/invite_accepted_mailer/email.html.haml`
- E-04: `app/views/members/invite_accepted_mailer/email.text.erb`
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` (91行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知種別はメール通知 | E-01, E-03, E-04 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-02 (796行目) | ○ |
| C-03 | Memberモデルのafter_accept_inviteでトリガー | E-02 (795行目) | ○ |
| C-04 | member.created_byが受信者 | E-01 (15行目) | ○ |
| C-05 | 件名は「Invitation accepted」 | E-01 (16行目) | ○ |
| C-06 | member.blank?で送信スキップ | E-01 (37-40行目) | ○ |
| C-07 | created_by.blank?で送信スキップ | E-01 (44行目) | ○ |
| C-08 | プロジェクトでnotifiable?チェック | E-01 (42行目) | ○ |
| C-09 | body_textにinvite_email含む | E-01 (25-30行目) | ○ |
| C-10 | body_textにuser_name含む | E-01 (25-30行目) | ○ |
| C-11 | body_textにtarget_name含む | E-01 (25-30行目) | ○ |
| C-12 | HTMLテンプレートにリンク含む | E-03 (7行目) | ○ |
| C-13 | テキストテンプレートにURL含む | E-04 (8行目) | ○ |
| C-14 | run_after_commit_or_nowで実行 | E-02 (796行目) | ○ |
| C-15 | ApplicationMailerを継承 | E-01 (4行目) | ○ |
| C-16 | mail_with_localeを使用 | E-01 (14行目) | ○ |
| C-17 | EmailsHelperをinclude | E-01 (5行目) | ○ |
| C-18 | リトライ回数はSidekiqデフォルト（25回） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- リトライ仕様の詳細
  - 候補：sidekiq.ymlの確認 / Sidekiqの設定クラス / ApplicationMailerのリトライ設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 送信条件のロジックは明確に実装されている
- 1: 中リスク - リトライ仕様はSidekiqデフォルトを想定しているが明示的な設定確認が必要
- 0: 低リスク - テンプレート変数は全てソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] リトライ設定がSidekiqデフォルトで問題ないか確認
- [ ] プロジェクト招待時のnotifiable?(:subscription)の動作確認
- [ ] HTMLエスケープ処理がsafe_formatで適切に行われているか確認
