---
generated_at: 2026-01-22 14:05:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：92-new_release_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **レート制限詳細**：Notifyクラスのcheck_rate_limitの具体的な設定値を確認していない
  2. **受信者構築ロジック**：NotificationRecipients::BuildServiceの詳細動作確認が必要
  3. **sources メソッド**：リリースのsourcesがどのように生成されるか確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` (480-493行目)
- E-02: `app/mailers/emails/releases.rb` (5-35行目)
- E-03: `app/views/notify/new_release_email.html.haml`
- E-04: `app/views/notify/new_release_email.text.erb`
- E-05: `app/models/release.rb`
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` (92行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知種別はメール通知 | E-02, E-03, E-04 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-01 (491行目) | ○ |
| C-03 | NotificationServiceで送信がトリガー | E-01 (480行目) | ○ |
| C-04 | author.can_trigger_notifications?チェックあり | E-01 (481行目) | ○ |
| C-05 | 受信者はBuildServiceで構築 | E-01 (486-488行目) | ○ |
| C-06 | 件名にtag含む | E-02 (24-33行目) | ○ |
| C-07 | 件名にリリース名含む（異なる場合） | E-02 (29行目) | ○ |
| C-08 | テンプレートにアセットリンク含む | E-03 (11-12行目), E-04 (4-5行目) | ○ |
| C-09 | テンプレートにソースダウンロード含む | E-03 (13-14行目), E-04 (7-8行目) | ○ |
| C-10 | リリースノートをmarkdown処理 | E-03 (18行目) | ○ |
| C-11 | recipient.reasonが渡される | E-01 (491行目) | ○ |
| C-12 | プロジェクトヘッダーが追加される | E-02 (14行目) | ○ |
| C-13 | target_urlはリリースページ | E-02 (8-11行目) | ○ |
| C-14 | mail_with_localeで送信 | E-02 (16-19行目) | ○ |
| C-15 | Emails::Releasesモジュールに実装 | E-02 (3行目) | ○ |
| C-16 | Releaseモデルにhas_many :links | E-05 (17行目) | ○ |
| C-17 | レート制限の具体的な値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- レート制限の具体的な設定値
  - 候補：Notifyクラスのcheck_rate_limit実装 / ApplicationRateLimiterの設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 送信トリガーと条件は明確に実装されている
- 0: 低リスク - テンプレート変数は全てソースコードで確認済み
- 1: 中リスク - markdown処理のセキュリティ設定（pipeline: :email）の詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] NotificationRecipients::BuildServiceのaction: "new"での受信者構築ロジック確認
- [ ] can_trigger_notifications?の判定条件確認
- [ ] markdown処理のパイプライン設定（XSS対策）確認
