---
generated_at: 2026-01-22 14:10:00
metrics:
  claims_total: 19
  claims_with_evidence: 18
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：93-new_review_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：18 / 19、根拠なし：1
- 優先レビュー（高）
  1. **deliver_options詳細**：new_review_deliver_optionsの具体的な内容を確認していない
  2. **内部ノート権限チェック**：read_internal_noteポリシーの定義確認が必要
  3. **差分ディスカッション表示**：スタイルシート適用条件の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` (697-706行目)
- E-02: `app/mailers/emails/reviews.rb` (5-45行目)
- E-03: `app/views/notify/new_review_email.html.haml`
- E-04: `app/views/notify/new_review_email.text.erb`
- E-05: `app/models/review.rb`
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` (93行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知種別はメール通知 | E-02, E-03, E-04 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-01 (704行目) | ○ |
| C-03 | NotificationServiceで送信がトリガー | E-01 (697行目) | ○ |
| C-04 | build_new_review_recipientsで受信者構築 | E-01 (698行目) | ○ |
| C-05 | 内部ノート権限チェックあり | E-02 (10行目) | ○ |
| C-06 | 内部ノート除外ロジックあり | E-02 (11行目) | ○ |
| C-07 | ノート空の場合return | E-02 (13行目) | ○ |
| C-08 | setup_review_emailでインスタンス変数設定 | E-02 (29-43行目) | ○ |
| C-09 | Discussion.build_discussionsで構築 | E-02 (33行目) | ○ |
| C-10 | 差分ディスカッションのスタイルシート判定 | E-02 (34-36行目), E-03 (1-3行目) | ○ |
| C-11 | SentNotification.recordで記録 | E-02 (42行目) | ○ |
| C-12 | mail_answer_threadでスレッド送信 | E-02 (16行目) | ○ |
| C-13 | 送信元にauthor情報使用 | E-02 (22行目) | ○ |
| C-14 | 件名にMRタイトルとリファレンス含む | E-02 (25行目) | ○ |
| C-15 | テンプレートで各ノートをレンダリング | E-03 (10-16行目), E-04 (6-14行目) | ○ |
| C-16 | Reviewモデルにhas_many :notes | E-05 (11行目) | ○ |
| C-17 | Reviewモデルでdiscussion_idsメソッド | E-05 (17-19行目) | ○ |
| C-18 | 受信者のnotification_email_for使用 | E-02 (24行目) | ○ |
| C-19 | deliver_optionsの具体的な内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- deliver_optionsの詳細（new_review_deliver_optionsメソッドの内容）
  - 候補：NotificationServiceの該当メソッド確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 内部ノートのフィルタリングロジックは明確
- 0: 低リスク - スレッドメール形式は標準的な実装
- 1: 中リスク - 差分ディスカッションの表示制御条件の詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] read_internal_noteポリシーの定義確認
- [ ] build_new_review_recipientsの受信者構築ロジック確認
- [ ] preload_note_diff_fileの動作確認
