---
generated_at: 2026-01-22 14:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：94-pages_domain_enabled_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **project_maintainers_recipients**：受信者構築ロジックの詳細確認が推奨される
  2. **ドメイン検証トリガー**：どのタイミングでpages_domain_enabledが呼ばれるか確認が推奨される

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` (612-616行目)
- E-02: `app/mailers/emails/pages_domains.rb` (5-13行目)
- E-03: `app/views/notify/pages_domain_enabled_email.html.haml`
- E-04: `app/models/pages_domain.rb`
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` (94行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知種別はメール通知 | E-02, E-03 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-01 (614行目) | ○ |
| C-03 | NotificationServiceで送信がトリガー | E-01 (612行目) | ○ |
| C-04 | project_maintainers_recipientsで受信者構築 | E-01 (613行目) | ○ |
| C-05 | 件名にドメイン名含む | E-02 (11行目) | ○ |
| C-06 | email_with_layoutを使用 | E-02 (9行目) | ○ |
| C-07 | @domain設定 | E-02 (6行目) | ○ |
| C-08 | @project設定 | E-02 (7行目) | ○ |
| C-09 | テンプレートにドメインURL含む | E-03 (3行目) | ○ |
| C-10 | テンプレートにプロジェクト名含む | E-03 (5行目) | ○ |
| C-11 | テンプレートにドメイン設定リンク含む | E-03 (7行目) | ○ |
| C-12 | ヘルプドキュメントへのリンク含む | E-03 (9-11行目) | ○ |
| C-13 | PagesDomainモデルにbelongs_to :project | E-04 (21行目) | ○ |
| C-14 | Emails::PagesDomainsモジュールで実装 | E-02 (3行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのクレームに根拠あり
- 0: 低リスク - テンプレート変数は全てソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] project_maintainers_recipientsの受信者構築ロジック確認
- [ ] pages_domain_enabledを呼び出すトリガーの確認（VerifyPagesDomainWorker等）
