---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 48
  claims_with_evidence: 42
  claims_without_evidence: 6
confidence_derived: 0.88
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：42 / 48、根拠なし：6
- 優先レビュー（高）
  1. **ショートカットキー一覧**：公式ドキュメント参照が必要
  2. **対応ブラウザ一覧**：最新の対応状況の確認が必要
  3. **お問い合わせ先情報**：組織固有の情報のため確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 業務要件定義
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-06: `docs/code-to-docs/画面設計書/1-ログイン画面.md` - ログイン画面設計書
- E-07: `docs/code-to-docs/画面設計書/11-プロジェクト一覧.md` - プロジェクト一覧画面設計書
- E-08: `docs/code-to-docs/画面設計書/61-MR一覧.md` - MR一覧画面設計書
- E-09: `docs/code-to-docs/README.md` - システム概要README

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GitLabはDevSecOpsプラットフォームである | E-09 | ○ |
| C-02 | 主要業務カテゴリ（ソースコード管理、コードレビュー等）の記載 | E-01, E-02 | ○ |
| C-03 | 業務フロー（STEP1〜5）の構成 | E-01, E-04 | ○ |
| C-04 | ユーザー種別（Guest/Reporter/Developer/Maintainer/Owner/Admin） | E-01 (BR-052, BR-053) | ○ |
| C-05 | 対応ブラウザ一覧 | **根拠なし** | △ |
| C-06 | ログイン画面のURL（/users/sign_in） | E-06 | ○ |
| C-07 | 標準ログイン手順（ユーザー名/パスワード入力） | E-06 | ○ |
| C-08 | OAuth認証による外部サービス連携ログイン | E-06 (関連機能88,89) | ○ |
| C-09 | Passkeyによるパスワードレス認証 | E-06 | ○ |
| C-10 | Remember me機能による セッション永続化 | E-06 | ○ |
| C-11 | 2要素認証（2FA）対応 | E-01 (BR-005), E-06 | ○ |
| C-12 | ログイン失敗5回でreCAPTCHA表示 | E-06 (備考セクション) | ○ |
| C-13 | ログイン失敗10回でアカウントロック | E-06 (備考セクション) | ○ |
| C-14 | ダッシュボード画面構成（サイドナビ、プロジェクト一覧等） | E-03, E-04 | ○ |
| C-15 | プロジェクト一覧画面URL（/dashboard/projects） | E-07 | ○ |
| C-16 | プロジェクト作成手順 | E-02 (機能1), E-01 (BR-006) | ○ |
| C-17 | 可視性レベル（Private/Internal/Public） | E-01 (BR-054), E-07 | ○ |
| C-18 | プロジェクトメンバー追加手順 | E-02 (機能84), E-05 (画面124) | ○ |
| C-19 | プロジェクトスター機能 | E-02 (機能6), E-07 | ○ |
| C-20 | リポジトリ閲覧機能 | E-02 (機能14,15), E-03 | ○ |
| C-21 | ブランチ作成手順 | E-02 (機能19), E-01 (BR-038) | ○ |
| C-22 | ファイル編集機能 | E-02 (機能16,17), E-03 | ○ |
| C-23 | マージリクエスト一覧画面URL（/-/merge_requests） | E-08 | ○ |
| C-24 | マージリクエスト作成手順 | E-02 (機能28), E-01 (BR-024) | ○ |
| C-25 | マージリクエストレビュー手順（コメント、承認） | E-02 (機能31,35), E-08 | ○ |
| C-26 | マージリクエストマージ手順 | E-02 (機能30), E-01 (BR-026) | ○ |
| C-27 | Squash commits、Delete source branchオプション | E-08 | ○ |
| C-28 | MR一覧のフィルタリング機能（状態、ラベル等） | E-08 (フィルタリング項目) | ○ |
| C-29 | イシュー作成手順 | E-02 (機能36), E-01 (BR-017) | ○ |
| C-30 | イシュークローズ手順 | E-02 (機能38), E-01 (BR-018) | ○ |
| C-31 | イシューボード（カンバン）機能 | E-02 (機能39), E-03 (画面50,51) | ○ |
| C-32 | マイルストーン管理機能 | E-02 (機能41), E-01 (BR-047) | ○ |
| C-33 | CI/CDパイプライン確認手順 | E-02 (機能47), E-01 (BR-031) | ○ |
| C-34 | パイプライン手動実行手順 | E-02 (機能47), E-03 (画面67) | ○ |
| C-35 | ジョブログ確認手順 | E-02 (機能48), E-03 (画面70) | ○ |
| C-36 | プロフィール編集機能 | E-02 (機能77), E-03 (画面192) | ○ |
| C-37 | SSHキー登録機能 | E-02 (機能80), E-03 (画面193) | ○ |
| C-38 | 通知設定変更機能 | E-02 (機能83), E-03 (画面204) | ○ |
| C-39 | 2要素認証設定手順 | E-02 (機能79), E-03 (画面205) | ○ |
| C-40 | ヘルプドキュメントへのアクセス | E-02 (機能142), E-03 (画面315) | ○ |
| C-41 | ショートカットキー一覧 | **根拠なし** | △ |
| C-42 | 日常業務フロー（STEP1〜5の詳細） | E-01, E-04 | ○ |
| C-43 | コンフリクト解決手順 | E-02 (機能32), E-03 (画面65) | ○ |
| C-44 | パイプライン失敗時の対処法 | E-02 (機能47,48), E-08 | ○ |
| C-45 | ブランチ復元手順 | **根拠なし** | △ |
| C-46 | メンション機能（@username） | E-02 (機能150) | ○ |
| C-47 | イシューとMRの紐づけ（Closes #123） | **根拠なし** | △ |
| C-48 | お問い合わせ先情報 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **対応ブラウザ一覧（C-05）**：実際のサポートブラウザについて公式ドキュメントまたはシステム要件から確認が必要
  - 候補：GitLab公式ドキュメント / インフラ設計書 / システム要件定義書
- **ショートカットキー一覧（C-41）**：画面設計書に記載なし、GitLab公式ドキュメント参照が必要
  - 候補：GitLab公式ドキュメント / ユーザーガイド
- **ブランチ復元手順（C-45）**：マージリクエストからの復元機能は画面設計書に明記されていない
  - 候補：機能設計書 / Git操作マニュアル
- **イシューとMRの紐づけ構文（C-47）**：GitLabの機能として存在するが、画面設計書に明記されていない
  - 候補：GitLab公式ドキュメント / 開発ガイドライン
- **お問い合わせ先情報（C-48）**：組織固有の情報のため、プロジェクト導入時に設定が必要
  - 候補：運用体制資料 / サービスデスク情報

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**：ショートカットキーの正確性について、実際のシステムで検証が必要
- **リスク0（低）**：多くの操作手順は画面設計書・機能一覧から正確に抽出されている
- **リスク0（低）**：業務フローは業務要件一覧と画面遷移図に基づいて構成されている
- **リスク1（中）**：トラブルシューティングの一部項目は一般的なGitLab知識に基づいており、個別確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 対応ブラウザ一覧が最新の実環境と一致しているか確認
- [ ] ショートカットキーが現行バージョンで動作するか確認
- [ ] お問い合わせ先情報を組織に合わせて更新
- [ ] ログイン失敗回数によるロック設定が実際のシステム設定と一致するか確認
- [ ] 各操作手順が現在のUIと一致するか確認（GitLabのバージョンアップに注意）
- [ ] 権限による表示制御が実際のロール設定と一致するか確認
