# GitLab 業務運用マニュアル

## 目次

- [1. システム概要](#1-システム概要)
- [2. ログイン・ログアウト手順](#2-ログインログアウト手順)
- [3. トップページ（ダッシュボード）](#3-トップページダッシュボード)
- [4. プロジェクト管理（STEP1-2）](#4-プロジェクト管理step1-2)
- [5. コード管理（STEP2-3）](#5-コード管理step2-3)
- [6. マージリクエスト・コードレビュー（STEP3-4）](#6-マージリクエストコードレビューstep3-4)
- [7. イシュー・課題管理（STEP4-5）](#7-イシュー課題管理step4-5)
- [8. CI/CDパイプライン](#8-cicdパイプライン)
- [9. マイページ機能](#9-マイページ機能)
- [10. ヘルプ・サポート機能](#10-ヘルプサポート機能)
- [11. 日常業務の流れ](#11-日常業務の流れ)
- [12. よくある質問と対処法](#12-よくある質問と対処法)
- [13. トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 GitLabとは

GitLabは、ソフトウェア開発のライフサイクル全体を支援する統合DevSecOpsプラットフォームです。Gitリポジトリ管理、コードレビュー、CI/CD、プロジェクト管理などの機能を一元的に提供します。

### 1.2 本システムで行う主要業務

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| ソースコード管理 | リポジトリの作成・管理、ブランチ管理、コードの閲覧・編集 |
| コードレビュー | マージリクエストの作成・レビュー・承認・マージ |
| イシュー管理 | 課題の登録・追跡・完了管理、マイルストーン管理 |
| CI/CD | パイプラインの実行・監視、デプロイ管理 |
| プロジェクト管理 | プロジェクトの作成・設定、メンバー管理 |
| グループ管理 | チーム・組織のグループ化、権限管理 |

### 1.3 業務フロー概要

```
【STEP 1】プロジェクト・グループの準備
    │  - 管理者がプロジェクトを作成
    │  - メンバーを招待・権限設定
    ↓
【STEP 2】開発作業の開始
    │  - ブランチを作成
    │  - コードを編集・コミット
    ↓
【STEP 3】コードレビュー依頼
    │  - マージリクエストを作成
    │  - レビュアーを指定
    ↓
【STEP 4】レビュー・承認
    │  - コードをレビュー
    │  - コメント・修正依頼
    │  - 承認
    ↓
【STEP 5】マージ・デプロイ
    - マージを実行
    - CI/CDパイプラインでデプロイ
```

### 1.4 ユーザー種別と役割

| ユーザー種別 | 役割 | 主な操作 |
|-------------|------|---------|
| Guest | 閲覧者 | イシューの閲覧・作成、コメント |
| Reporter | 報告者 | コードの閲覧、イシュー管理 |
| Developer | 開発者 | コードの編集、MR作成、ブランチ管理 |
| Maintainer | メンテナー | プロジェクト設定、保護ブランチ管理、マージ実行 |
| Owner | オーナー | プロジェクト・グループの全権限 |
| Admin | 管理者 | システム全体の管理 |

### 1.5 対応ブラウザ

- Google Chrome（推奨）
- Mozilla Firefox
- Microsoft Edge
- Safari

---

## 2. ログイン・ログアウト手順

### 2.1 ログイン

**業務フローでの位置**: 全ての操作の前提となる認証プロセス

#### やるべきこと
- [ ] 正しい認証情報でシステムにログインする
- [ ] 必要に応じて2要素認証を完了する

#### システムでの操作手順

**標準ログイン（ユーザー名/パスワード）**

1. ブラウザでGitLabのURLにアクセスします
2. 「ログイン画面」が表示されます
3. 「ユーザー名またはメールアドレス」欄にユーザー名またはメールアドレスを入力します
4. 「パスワード」欄にパスワードを入力します
5. 必要に応じて「Remember me」にチェックを入れます（次回以降の自動ログイン）
6. 「Sign in」ボタンをクリックします
7. 2要素認証が有効な場合は、認証コードを入力します
8. ダッシュボード画面が表示されればログイン完了です

**OAuth認証（外部サービス連携）**

1. ログイン画面で利用可能な外部認証ボタン（GitHub、Google等）をクリックします
2. 外部サービスの認証画面で認証を完了します
3. GitLabに戻り、ダッシュボードが表示されればログイン完了です

**Passkeyによるログイン**

1. ログイン画面で「Passkey」ボタンをクリックします
2. ブラウザの認証ダイアログで生体認証等を完了します
3. ダッシュボードが表示されればログイン完了です

#### 関連画面
- ログイン画面（`/users/sign_in`）
- 2要素認証画面
- パスワードリセット画面

#### 注意点・Tips
- ログイン失敗が5回続くと、reCAPTCHAが表示されます
- 10回失敗するとアカウントがロックされます
- パスワードを忘れた場合は「Forgot your password?」リンクからリセットできます

### 2.2 ログアウト

#### システムでの操作手順

1. 画面右上のアバターアイコンをクリックします
2. ドロップダウンメニューから「Sign out」をクリックします
3. ログイン画面に戻ればログアウト完了です

#### 注意点・Tips
- ログアウトするとすべてのセッションが終了します
- 共有PCを使用している場合は、必ずログアウトしてください

---

## 3. トップページ（ダッシュボード）

### 3.1 ダッシュボードの概要

**業務フローでの位置**: 全ての業務の起点となる画面

ログイン後に最初に表示される画面です。自分が参加しているプロジェクト、割り当てられたタスク、最新のアクティビティなどを一覧で確認できます。

### 3.2 ダッシュボードの構成

| エリア | 説明 |
|-------|------|
| サイドナビゲーション | プロジェクト、グループ、イシュー等へのアクセス |
| プロジェクト一覧 | 参加中のプロジェクト一覧 |
| To-Do一覧 | 自分に割り当てられたタスク |
| アクティビティ | 最近の活動履歴 |

### 3.3 主要メニューへのアクセス

#### プロジェクト一覧を表示する

1. サイドナビゲーションの「Projects」をクリックします
2. 「Your projects」を選択します
3. 参加中のプロジェクト一覧が表示されます

#### グループ一覧を表示する

1. サイドナビゲーションの「Groups」をクリックします
2. 「Your groups」を選択します
3. 所属グループ一覧が表示されます

#### To-Do一覧を確認する

1. サイドナビゲーションの「To-Do List」をクリックします
2. 自分に割り当てられたタスク一覧が表示されます

---

## 4. プロジェクト管理（STEP1-2）

**業務フローでの位置**: 【STEP1】プロジェクト・グループの準備

### 4.1 プロジェクトを作成する

#### 業務シーン
新しい開発プロジェクトを開始する際に、リポジトリと管理環境を準備します。

#### 前提条件
- Developer以上の権限を持つグループに所属している、またはプロジェクト作成権限がある

#### やるべきこと
- [ ] プロジェクト名と説明を決定する
- [ ] 可視性レベル（Private/Internal/Public）を決定する
- [ ] 必要に応じてテンプレートを選択する

#### システムでの操作手順

1. 画面右上の「+」アイコンをクリックします
2. 「New project/repository」を選択します
3. プロジェクト作成方法を選択します
   - 「Create blank project」: 空のプロジェクトを作成
   - 「Create from template」: テンプレートから作成
   - 「Import project」: 外部からインポート
4. 「Project name」にプロジェクト名を入力します
5. 「Project URL」でグループ/名前空間を選択します
6. 「Visibility Level」で可視性を選択します
   - **Private**: 招待されたメンバーのみアクセス可能
   - **Internal**: ログインユーザーのみアクセス可能
   - **Public**: 誰でもアクセス可能
7. 「Initialize repository with a README」にチェックを入れます（推奨）
8. 「Create project」ボタンをクリックします

#### 関連画面
- プロジェクト新規作成画面（`/projects/new`）
- プロジェクト詳細画面

#### 次のステップ
プロジェクト作成後、メンバーの招待とブランチ保護設定を行います。

### 4.2 プロジェクトにメンバーを追加する

#### 業務シーン
チームメンバーをプロジェクトに招待し、適切な権限を付与します。

#### 前提条件
- プロジェクトのMaintainer以上の権限を持っている

#### システムでの操作手順

1. プロジェクトページを開きます
2. 左サイドメニューから「Manage」>「Members」をクリックします
3. 「Invite members」ボタンをクリックします
4. メンバーのユーザー名またはメールアドレスを入力します
5. 「Select a role」でロール（権限）を選択します
6. 必要に応じて「Access expiration date」で有効期限を設定します
7. 「Invite」ボタンをクリックします

#### 注意点・Tips
- メールアドレスで招待した場合、相手がGitLabアカウントを持っていなければ登録を促すメールが送信されます
- 権限は後から変更可能です

### 4.3 プロジェクトをスターに追加する

#### 業務シーン
よく使うプロジェクトをブックマークして、素早くアクセスできるようにします。

#### システムでの操作手順

1. プロジェクト一覧またはプロジェクト詳細画面を開きます
2. プロジェクト名の右側にある「Star」ボタンをクリックします
3. ボタンが「Unstar」に変わればスター追加完了です

#### 関連画面
- プロジェクト一覧画面
- プロジェクト詳細画面
- スター済みプロジェクト一覧（`/dashboard/projects/starred`）

---

## 5. コード管理（STEP2-3）

**業務フローでの位置**: 【STEP2】開発作業の開始

### 5.1 リポジトリを閲覧する

#### 業務シーン
プロジェクトのソースコードを確認します。

#### システムでの操作手順

1. プロジェクト詳細画面を開きます
2. 左サイドメニューから「Code」>「Repository」をクリックします
3. ファイルツリーが表示されます
4. フォルダやファイルをクリックして中身を確認します

#### 関連画面
- ファイルツリー画面
- ファイル表示画面
- Blame表示画面

### 5.2 ブランチを作成する

#### 業務シーン
新機能開発やバグ修正のために、独立した作業用ブランチを作成します。

#### 前提条件
- Developer以上の権限を持っている

#### やるべきこと
- [ ] 作成するブランチ名を決定する（命名規則に従う）
- [ ] ベースとなるブランチを決定する

#### システムでの操作手順

1. プロジェクトの「Code」>「Branches」をクリックします
2. 右上の「New branch」ボタンをクリックします
3. 「Branch name」にブランチ名を入力します
4. 「Create from」でベースブランチを選択します（通常は`main`または`develop`）
5. 「Create branch」ボタンをクリックします

#### 注意点・Tips
- ブランチ名は意味のある名前にしましょう（例：`feature/user-login`、`fix/login-bug`）
- 保護ブランチには直接プッシュできない場合があります

### 5.3 ファイルを編集する

#### 業務シーン
Web UI上で直接ファイルを編集します。

#### システムでの操作手順

1. 編集したいファイルを開きます
2. 「Edit」ボタンをクリックします
3. エディタでファイル内容を編集します
4. 「Commit message」にコミットメッセージを入力します
5. 「Target branch」で対象ブランチを選択または入力します
6. 「Commit changes」ボタンをクリックします

#### 注意点・Tips
- 大きな変更はローカル環境でのGit操作を推奨します
- コミットメッセージは変更内容がわかるよう記載しましょう

### 5.4 新規ファイルを作成する

#### システムでの操作手順

1. ファイルツリー画面で「+」ボタンをクリックします
2. 「New file」を選択します
3. ファイル名を入力します
4. エディタでファイル内容を入力します
5. 「Commit message」を入力します
6. 「Commit changes」ボタンをクリックします

---

## 6. マージリクエスト・コードレビュー（STEP3-4）

**業務フローでの位置**: 【STEP3】コードレビュー依頼 / 【STEP4】レビュー・承認

### 6.1 マージリクエストを作成する

#### 業務シーン
開発したコードをレビューに出し、本番ブランチへのマージを依頼します。

#### 前提条件
- Developer以上の権限を持っている
- マージ元となるブランチが存在する

#### やるべきこと
- [ ] マージリクエストのタイトルと説明を記載する
- [ ] レビュアーとアサイニーを指定する
- [ ] 必要に応じてラベルとマイルストーンを設定する

#### システムでの操作手順

1. 左サイドメニューから「Code」>「Merge requests」をクリックします
2. 「New merge request」ボタンをクリックします
3. 「Source branch」でマージ元ブランチを選択します
4. 「Target branch」でマージ先ブランチを選択します（通常は`main`）
5. 「Compare branches and continue」をクリックします
6. 以下の情報を入力します：
   - **Title**: マージリクエストのタイトル
   - **Description**: 変更内容の詳細説明
   - **Assignee**: 担当者
   - **Reviewer**: レビュアー
   - **Labels**: 分類用ラベル
   - **Milestone**: 関連マイルストーン
7. 「Create merge request」ボタンをクリックします

#### 関連画面
- MR一覧画面（`/-/merge_requests`）
- MR新規作成画面
- MR詳細画面

#### 注意点・Tips
- タイトルの先頭に「Draft:」をつけると、作業中（レビュー準備未完了）を示せます
- テンプレートが設定されている場合は、テンプレートに従って記載しましょう

### 6.2 マージリクエストをレビューする

#### 業務シーン
チームメンバーのコード変更をレビューし、フィードバックを提供します。

#### 前提条件
- プロジェクトへのアクセス権限がある
- レビュアーとして指定されている（推奨）

#### やるべきこと
- [ ] 変更内容を確認する
- [ ] コードの品質・問題点をチェックする
- [ ] 必要に応じてコメントを残す
- [ ] 問題なければ承認する

#### システムでの操作手順

1. マージリクエスト一覧からレビュー対象のMRをクリックします
2. 「Changes」タブをクリックして差分を確認します
3. コードの特定行にコメントを追加する場合：
   - 行番号の左にある「+」アイコンをクリックします
   - コメントを入力します
   - 「Start a review」または「Add comment now」を選択します
4. レビューを完了する場合：
   - 「Review」ボタンをクリックします
   - コメントを入力します
   - 「Approve」（承認）または「Request changes」（修正依頼）を選択します
   - 「Submit review」をクリックします

#### 注意点・Tips
- 承認が必要な設定の場合、指定人数の承認がないとマージできません
- 修正依頼をした場合は、修正後に再レビューを行いましょう

### 6.3 マージリクエストをマージする

#### 業務シーン
レビューが完了し承認されたコードを、ターゲットブランチにマージします。

#### 前提条件
- Maintainer以上の権限を持っている（設定による）
- 必要な承認が得られている
- CI/CDパイプラインが成功している（設定による）

#### システムでの操作手順

1. マージリクエスト詳細画面を開きます
2. すべての条件が満たされていることを確認します
3. 「Merge」ボタンをクリックします
4. オプションを選択します：
   - **Delete source branch**: マージ後にソースブランチを削除
   - **Squash commits**: コミットを1つにまとめる
5. マージが完了すると、ステータスが「Merged」に変わります

#### 注意点・Tips
- 「Merge when pipeline succeeds」を選択すると、パイプライン成功後に自動マージされます
- コンフリクトがある場合は、先に解決する必要があります

### 6.4 マージリクエスト一覧を管理する

#### システムでの操作手順

1. 左サイドメニューから「Code」>「Merge requests」をクリックします
2. フィルタを使用してMRを絞り込みます：
   - **Open**: オープン状態のMR
   - **Merged**: マージ済みのMR
   - **Closed**: クローズされたMR
   - **All**: すべてのMR
3. ソート条件を変更して表示順を変えられます
4. ラベルやアサイニーでのフィルタリングも可能です

---

## 7. イシュー・課題管理（STEP4-5）

**業務フローでの位置**: プロジェクト全体を通した課題の追跡・管理

### 7.1 イシューを作成する

#### 業務シーン
バグ報告、機能要望、タスクなどを課題として登録します。

#### 前提条件
- Reporter以上の権限を持っている

#### やるべきこと
- [ ] イシューのタイトルと説明を記載する
- [ ] 担当者とラベルを設定する
- [ ] 必要に応じてマイルストーンを設定する

#### システムでの操作手順

1. 左サイドメニューから「Plan」>「Issues」をクリックします
2. 「New issue」ボタンをクリックします
3. 以下の情報を入力します：
   - **Title**: イシューのタイトル
   - **Description**: 詳細な説明（マークダウン形式）
   - **Assignee**: 担当者
   - **Labels**: 分類用ラベル（例：bug、enhancement）
   - **Milestone**: 関連マイルストーン
   - **Due date**: 期限
4. 「Create issue」ボタンをクリックします

#### 関連画面
- 課題一覧画面（`/-/issues`）
- 課題新規作成画面
- 課題詳細画面

### 7.2 イシューをクローズする

#### 業務シーン
完了したイシューをクローズして、進捗を管理します。

#### システムでの操作手順

1. クローズするイシューを開きます
2. 「Close issue」ボタンをクリックします
3. ステータスが「Closed」に変わります

#### 注意点・Tips
- マージリクエストの説明に「Closes #123」と記載すると、マージ時に自動でイシューがクローズされます
- クローズしたイシューは後から再オープンできます

### 7.3 イシューボード（カンバン）を使う

#### 業務シーン
視覚的にイシューの進捗状況を管理します。

#### システムでの操作手順

1. 左サイドメニューから「Plan」>「Issue boards」をクリックします
2. ボード画面が表示されます
3. イシューカードをドラッグ＆ドロップして列（ラベル）を移動させます
4. 新しいリストを追加する場合は「Create list」をクリックします

### 7.4 マイルストーンを管理する

#### 業務シーン
リリースやスプリント単位でイシューをグループ化して、進捗を管理します。

#### システムでの操作手順

1. 左サイドメニューから「Plan」>「Milestones」をクリックします
2. 「New milestone」ボタンをクリックします
3. 以下の情報を入力します：
   - **Title**: マイルストーン名（例：v1.0.0、Sprint 1）
   - **Start date**: 開始日
   - **Due date**: 終了日
   - **Description**: 説明
4. 「Create milestone」ボタンをクリックします

---

## 8. CI/CDパイプライン

**業務フローでの位置**: 【STEP5】マージ・デプロイ

### 8.1 パイプラインを確認する

#### 業務シーン
コードのビルド、テスト、デプロイの状況を確認します。

#### システムでの操作手順

1. 左サイドメニューから「Build」>「Pipelines」をクリックします
2. パイプライン一覧が表示されます
3. 確認したいパイプラインをクリックして詳細を表示します
4. 各ジョブのステータスを確認できます

#### 関連画面
- パイプライン一覧画面（`/-/pipelines`）
- パイプライン詳細画面
- ジョブ詳細画面

### 8.2 パイプラインを手動実行する

#### 業務シーン
特定のブランチに対してパイプラインを手動で実行します。

#### 前提条件
- Developer以上の権限を持っている

#### システムでの操作手順

1. 左サイドメニューから「Build」>「Pipelines」をクリックします
2. 「Run pipeline」ボタンをクリックします
3. 対象ブランチを選択します
4. 必要に応じて変数を設定します
5. 「Run pipeline」ボタンをクリックします

### 8.3 ジョブのログを確認する

#### 業務シーン
パイプライン失敗時に、エラーの原因を調査します。

#### システムでの操作手順

1. パイプライン詳細画面を開きます
2. 確認したいジョブをクリックします
3. ジョブのログが表示されます
4. エラーメッセージを確認して原因を特定します

#### 注意点・Tips
- 失敗したジョブは赤色で表示されます
- 「Retry」ボタンでジョブを再実行できます

---

## 9. マイページ機能

### 9.1 プロフィールを編集する

#### システムでの操作手順

1. 画面右上のアバターアイコンをクリックします
2. 「Edit profile」をクリックします
3. 以下の情報を編集できます：
   - 名前
   - アバター画像
   - 自己紹介
   - ソーシャルアカウント
4. 「Update profile settings」ボタンをクリックします

### 9.2 SSHキーを登録する

#### 業務シーン
Git操作をSSH経由で行うために、SSHキーを登録します。

#### システムでの操作手順

1. 画面右上のアバターアイコンをクリックします
2. 「Preferences」をクリックします
3. 左メニューから「SSH Keys」をクリックします
4. 「Key」欄にSSH公開鍵を貼り付けます
5. 「Title」にわかりやすい名前を入力します
6. 「Add key」ボタンをクリックします

### 9.3 通知設定を変更する

#### システムでの操作手順

1. 画面右上のアバターアイコンをクリックします
2. 「Preferences」をクリックします
3. 左メニューから「Notifications」をクリックします
4. 通知レベルを設定します：
   - **Global**: デフォルトの通知設定
   - **Watch**: すべてのアクティビティを通知
   - **Participating**: 参加中のイシュー・MRのみ通知
   - **On mention**: メンションされた場合のみ通知
   - **Disabled**: 通知なし
5. 「Update global notification settings」ボタンをクリックします

### 9.4 2要素認証を設定する

#### 業務シーン
アカウントのセキュリティを強化するために、2要素認証を有効にします。

#### システムでの操作手順

1. 画面右上のアバターアイコンをクリックします
2. 「Preferences」をクリックします
3. 左メニューから「Account」をクリックします
4. 「Two-Factor Authentication」セクションの「Enable two-factor authentication」をクリックします
5. 認証アプリ（Google Authenticator等）でQRコードをスキャンします
6. 生成されたコードを入力します
7. リカバリーコードを安全な場所に保存します

---

## 10. ヘルプ・サポート機能

### 10.1 ヘルプドキュメントにアクセスする

#### システムでの操作手順

1. 画面右上の「?」アイコンをクリックします
2. 「Help」をクリックします
3. GitLabのドキュメントサイトが開きます

### 10.2 ショートカットキーを確認する

#### システムでの操作手順

1. 任意の画面で「?」キーを押します
2. ショートカットキーの一覧が表示されます

#### よく使うショートカットキー

| ショートカット | 動作 |
|---------------|------|
| `?` | ショートカット一覧を表示 |
| `g` + `p` | プロジェクト一覧へ移動 |
| `g` + `i` | イシュー一覧へ移動 |
| `g` + `m` | マージリクエスト一覧へ移動 |
| `t` | ファイルファインダーを開く |
| `/` | 検索ボックスにフォーカス |

---

## 11. 日常業務の流れ

### 11.1 業務フロー概要図

```
【STEP 1】プロジェクト・グループの準備（管理者/メンテナー）
    │  - プロジェクトを作成する
    │  - メンバーを招待する
    │  - ブランチ保護設定を行う
    ↓
【STEP 2】開発作業の開始（開発者）
    │  - イシューを確認する
    │  - ブランチを作成する
    │  - コードを編集・コミットする
    ↓
【STEP 3】コードレビュー依頼（開発者）
    │  - マージリクエストを作成する
    │  - レビュアーを指定する
    │  - CI/CDパイプラインの結果を確認する
    ↓
【STEP 4】レビュー・承認（レビュアー）
    │  - コード差分を確認する
    │  - コメント・フィードバックを残す
    │  - 問題なければ承認する
    ↓
【STEP 5】マージ・デプロイ（メンテナー/開発者）
    - マージを実行する
    - デプロイの完了を確認する
    - 関連イシューをクローズする
```

### 11.2 朝の確認作業

1. **To-Do一覧を確認する**
   - 自分にアサインされたタスクを確認
   - 緊急度の高いものから対応

2. **マージリクエストの状態を確認する**
   - 自分が作成したMRの進捗を確認
   - レビュー依頼が来ているMRを確認

3. **パイプラインの状態を確認する**
   - 失敗しているパイプラインがないか確認

### 11.3 開発作業の流れ

1. **イシューを確認する**
   - 担当するイシューを開く
   - 要件や仕様を確認する

2. **ブランチを作成する**
   - イシュー番号を含むブランチ名で作成
   - 例：`feature/123-add-login`

3. **コードを実装する**
   - ローカルで開発
   - こまめにコミット

4. **プッシュしてMRを作成する**
   - リモートにプッシュ
   - マージリクエストを作成
   - レビュアーを指定

5. **レビュー結果を確認・対応する**
   - コメントへの対応
   - 修正後に再プッシュ

6. **マージを依頼する**
   - すべてのレビューが完了したらマージ

---

## 12. よくある質問と対処法

### Q1: パスワードを忘れてしまいました

**対処法**:
1. ログイン画面で「Forgot your password?」をクリック
2. 登録メールアドレスを入力
3. 送信されたメールのリンクからパスワードをリセット

### Q2: マージリクエストにコンフリクトが発生しています

**対処法**:
1. ローカル環境でターゲットブランチ（main等）をマージ
2. コンフリクトを解決
3. 変更をプッシュ
4. MR画面でコンフリクト解消を確認

または:
1. MR詳細画面の「Resolve conflicts」ボタンをクリック
2. Web上でコンフリクトを解決
3. 「Commit to source branch」をクリック

### Q3: パイプラインが失敗しています

**対処法**:
1. パイプライン詳細画面を開く
2. 失敗しているジョブをクリック
3. ログを確認してエラー原因を特定
4. 原因を修正してプッシュ

### Q4: 間違えてブランチを削除してしまいました

**対処法**:
1. マージリクエスト一覧から該当のMRを探す
2. MR詳細画面の「Restore source branch」をクリック

または:
1. 管理者に連絡してGitコマンドでブランチを復元してもらう

### Q5: 他のユーザーをメンションするには？

**対処法**:
- コメント欄で `@username` と入力
- 入力中にユーザー候補が表示される
- 選択してメンションを完了

### Q6: イシューとマージリクエストを紐づけたい

**対処法**:
- MRの説明に `Closes #123` と記載（マージ時に自動クローズ）
- または `Relates to #123` と記載（関連付けのみ）

---

## 13. トラブルシューティング

### 13.1 ログインできない

| 症状 | 考えられる原因 | 対処法 |
|------|---------------|--------|
| Invalid login or password | ユーザー名/パスワードが間違っている | 正しい情報を再入力 |
| Your account is locked | ログイン失敗が規定回数を超えた | アカウントロック解除画面から解除 |
| Your account is blocked | 管理者によってブロックされた | 管理者に連絡 |
| メール未確認 | メール確認が完了していない | 確認メールを再送して確認 |

### 13.2 プッシュできない

| 症状 | 考えられる原因 | 対処法 |
|------|---------------|--------|
| Permission denied | 権限がない | プロジェクトへのアクセス権限を確認 |
| pre-receive hook declined | 保護ブランチへの直接プッシュ | MRを使用してマージ |
| SSH key not found | SSHキーが登録されていない | SSHキーを登録 |

### 13.3 マージできない

| 症状 | 考えられる原因 | 対処法 |
|------|---------------|--------|
| Merge blocked | 必要な承認が得られていない | 承認者にレビューを依頼 |
| Pipeline failed | CI/CDパイプラインが失敗 | パイプラインのエラーを修正 |
| Conflict | マージコンフリクトが発生 | コンフリクトを解決 |

### 13.4 ページが表示されない

| 症状 | 考えられる原因 | 対処法 |
|------|---------------|--------|
| 404 Not Found | ページが存在しない | URLを確認 |
| 403 Forbidden | アクセス権限がない | 管理者に権限を依頼 |
| 500 Internal Server Error | サーバーエラー | 管理者に連絡 |

### 13.5 お問い合わせ先

システムに関するお問い合わせは、以下の方法でご連絡ください：

- **システム管理者**: 社内管理者にお問い合わせください
- **GitLabドキュメント**: https://docs.gitlab.com/
- **GitLabコミュニティ**: https://forum.gitlab.com/

---

*本マニュアルは GitLab の主要な業務操作について記載しています。詳細な機能については、GitLab公式ドキュメントを参照してください。*
