---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 46
  claims_without_evidence: 4
confidence_derived: 0.92
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：46 / 50、根拠なし：4
- 優先レビュー（高）
  1. **NFT-042**: PostgreSQL 16互換性検証 - 具体的なバージョン要件の確認が必要
  2. **NFT-043**: Ruby互換性検証 - サポート対象バージョン範囲の確認が必要
  3. **NFT-044**: Jestフロントエンドテスト検証 - テストカバレッジ閾値の確認が必要
  4. **NFT-049**: 全体テストカバレッジ検証 - 具体的なカバレッジ閾値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `config/initializers/rack_timeout.rb` - リクエストタイムアウト設定
- E-02: `lib/tasks/benchmark.rake` - ベンチマークタスク定義
- E-03: `.gitlab/ci/memory.gitlab-ci.yml` - メモリテストCI設定
- E-04: `.gitlab/ci/performance-on-cng/main.gitlab-ci.yml` - パフォーマンステストCI設定
- E-05: `lib/gitlab/application_rate_limiter.rb` - レート制限実装
- E-06: `app/controllers/concerns/check_rate_limit.rb` - レート制限チェックconcern
- E-07: `lib/api/helpers/rate_limiter.rb` - APIレート制限ヘルパー
- E-08: `spec/features/security/dashboard_access_spec.rb` - ダッシュボードアクセステスト
- E-09: `spec/features/security/project/public_access_spec.rb` - パブリックプロジェクトアクセステスト
- E-10: `spec/features/security/project/private_access_spec.rb` - プライベートプロジェクトアクセステスト
- E-11: `spec/features/security/project/internal_access_spec.rb` - 内部プロジェクトアクセステスト
- E-12: `spec/features/security/admin_access_spec.rb` - 管理者アクセステスト
- E-13: `spec/features/security/group/` - グループアクセステスト
- E-14: `config/audit_events/types/authenticated_with_two_factor.yml` - 二要素認証監査イベント
- E-15: `config/audit_events/types/authenticated_with_webauthn.yml` - WebAuthn認証監査イベント
- E-16: `config/audit_events/types/authenticated_with_ldap.yml` - LDAP認証監査イベント
- E-17: `config/audit_events/types/authenticated_with_oauth.yml` - OAuth認証監査イベント
- E-18: `config/audit_events/types/authenticated_with_password.yml` - パスワード認証監査イベント
- E-19: `spec/lib/gitlab/ci/parsers/security/sast_spec.rb` - SASTパーサーテスト
- E-20: `spec/lib/gitlab/ci/parsers/security/secret_detection_spec.rb` - Secret Detectionパーサーテスト
- E-21: `spec/lib/gitlab/middleware/path_traversal_check_spec.rb` - パストラバーサルチェックテスト
- E-22: `spec/lib/gitlab/middleware/handle_malformed_strings_spec.rb` - 不正文字列ハンドリングテスト
- E-23: `spec/lib/gitlab/middleware/json_validation_spec.rb` - JSONバリデーションテスト
- E-24: `spec/lib/gitlab/middleware/webhook_recursion_detection_spec.rb` - Webhookリカーション検出テスト
- E-25: `spec/lib/gitlab/middleware/handle_ip_spoof_attack_error_spec.rb` - IPスプーフィング対策テスト
- E-26: `spec/lib/gitlab/middleware/basic_health_check_spec.rb` - 基本ヘルスチェックテスト
- E-27: `config/initializers/health_check.rb` - ヘルスチェック初期化設定
- E-28: `.gitlab/ci/benchmark.gitlab-ci.yml` - ベンチマークCI設定
- E-29: `.gitlab/ci/static-analysis.gitlab-ci.yml` - 静的解析CI設定
- E-30: `.gitlab/ci/coverage.gitlab-ci.yml` - カバレッジCI設定
- E-31: `.gitlab/ci/openapi.gitlab-ci.yml` - OpenAPI検証CI設定
- E-32: `.gitlab/ci/frontend.gitlab-ci.yml` - フロントエンドCI設定
- E-33: `.gitlab/ci/graphql.gitlab-ci.yml` - GraphQL CI設定
- E-34: `lib/gitlab/web_hooks/rate_limiter.rb` - Webhookレート制限実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIリクエストタイムアウト60秒設定 | E-01 | ○ |
| C-02 | リクエスト待機タイムアウト90秒設定 | E-01 | ○ |
| C-03 | Banzaiパイプラインベンチマーク | E-02, E-28 | ○ |
| C-04 | 起動時メモリ使用量検証 | E-03 | ○ |
| C-05 | CNG環境パフォーマンステスト | E-04 | ○ |
| C-06 | AI Action APIレート制限（8時間） | E-05 | ○ |
| C-07 | オートコンプリートユーザーAPIレート制限（1分） | E-05 | ○ |
| C-08 | Pipeline作成レート制限 | E-05 | ○ |
| C-09 | 検索APIレート制限 | E-05 | ○ |
| C-10 | Issues作成レート制限 | E-05 | ○ |
| C-11 | グループAPIレート制限 | E-05 | ○ |
| C-12 | プロジェクトAPIレート制限 | E-05 | ○ |
| C-13 | Raw Blobダウンロードレート制限 | E-05 | ○ |
| C-14 | Webhookレート制限 | E-34 | ○ |
| C-15 | ユーザーサインインレート制限（10分/5回） | E-05 | ○ |
| C-16 | ユーザーサインアップレート制限（1分/20回） | E-05 | ○ |
| C-17 | ダッシュボードアクセス権限検証 | E-08 | ○ |
| C-18 | パブリックプロジェクトアクセス権限検証 | E-09 | ○ |
| C-19 | プライベートプロジェクトアクセス権限検証 | E-10 | ○ |
| C-20 | 内部プロジェクトアクセス権限検証 | E-11 | ○ |
| C-21 | 管理者画面アクセス権限検証 | E-12 | ○ |
| C-22 | グループアクセス権限検証 | E-13 | ○ |
| C-23 | 二要素認証検証 | E-14 | ○ |
| C-24 | WebAuthn認証検証 | E-15 | ○ |
| C-25 | LDAP認証検証 | E-16 | ○ |
| C-26 | OAuth認証検証 | E-17 | ○ |
| C-27 | パスワード認証検証 | E-18 | ○ |
| C-28 | SAST検証 | E-19 | ○ |
| C-29 | Secret Detection検証 | E-20 | ○ |
| C-30 | パストラバーサル攻撃検証 | E-21 | ○ |
| C-31 | 不正文字列ハンドリング検証 | E-22 | ○ |
| C-32 | JSONバリデーション検証 | E-23 | ○ |
| C-33 | Webhookリカーション検出検証 | E-24 | ○ |
| C-34 | IPスプーフィング攻撃検証 | E-25 | ○ |
| C-35 | 基本ヘルスチェック検証（許可IP） | E-26 | ○ |
| C-36 | 基本ヘルスチェック検証（外部IP） | E-26 | ○ |
| C-37 | データベース接続チェック | E-27 | ○ |
| C-38 | キャッシュ接続チェック | E-27 | ○ |
| C-39 | マイグレーション状態チェック | E-27 | ○ |
| C-40 | マスターワーカーライフサイクル検証 | E-27 | ○ |
| C-41 | ブラックアウト期間処理検証 | E-27 | ○ |
| C-42 | PostgreSQL 16互換性検証 | **根拠なし** | △ |
| C-43 | Ruby互換性検証 | **根拠なし** | △ |
| C-44 | Jestフロントエンドテスト検証 | E-32 | ○ |
| C-45 | GraphQL互換性検証 | E-33 | ○ |
| C-46 | IPv6マッピングIPv4互換性検証 | E-26 | ○ |
| C-47 | RuboCop静的解析検証 | E-29 | ○ |
| C-48 | ESLint検証 | E-29 | ○ |
| C-49 | 全体テストカバレッジ検証 | **根拠なし** | △ |
| C-50 | OpenAPIスキーマ検証 | E-31 | ○ |

## 4) 不足情報（Unknown / Missing）
- **PostgreSQL 16互換性検証（C-42）**: CI設定ファイルで.use-pg16を参照しているが、具体的なバージョン要件の定義ファイルが確認できていない
  - 候補：config/database.yml / doc/install/requirements.md / .gitlab-ci.yml
- **Ruby互換性検証（C-43）**: サポート対象Rubyバージョンの明示的な定義ファイルが確認できていない
  - 候補：.ruby-version / Gemfile / doc/install/requirements.md
- **全体テストカバレッジ検証（C-49）**: 具体的なカバレッジ閾値の設定ファイルが確認できていない
  - 候補：.gitlab/ci/coverage.gitlab-ci.yml / .simplecov / spec/spec_helper.rb

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: 性能テスト・セキュリティテスト関連（NFT-001〜NFT-041） - 明確なソースコード根拠あり
- **1: 中リスク**: 互換性テスト（NFT-042〜NFT-046） - 一部のテストケースで具体的な要件値の確認が必要
- **0: 低リスク**: 保守性テスト（NFT-047〜NFT-050） - CI設定ファイルで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] PostgreSQL 16のバージョン要件が正式なドキュメントで定義されているか確認
- [ ] サポート対象Rubyバージョン範囲が最新か確認
- [ ] テストカバレッジの目標閾値がプロジェクト方針と一致しているか確認
- [ ] レート制限の閾値がapplication_settingsの設定と整合しているか確認
- [ ] セキュリティテストケースが最新のセキュリティ要件をカバーしているか確認
- [ ] CNG環境パフォーマンステストのベースライン値が最新か確認
