---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **稼働率/RTO/RPO**：コード上に明示的な定義なし（運用設計依存）
  2. **計画停止時間**：コード上に明示的な定義なし（運用設計依存）
  3. **Pumaワーカー同時接続数**：具体値は環境設定ファイルに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `config/initializers/rack_timeout.rb`
- E-02: `config/initializers/1_settings.rb`
- E-03: `lib/gitlab/application_rate_limiter.rb`
- E-04: `lib/gitlab/throttle.rb`
- E-05: `lib/gitlab/rack_attack.rb`
- E-06: `config/initializers/rack_attack.rb`
- E-07: `config/initializers/retriable.rb`
- E-08: `config/initializers/7_prometheus_metrics.rb`
- E-09: `config/initializers/sidekiq.rb`
- E-10: `config/initializers/7_redis.rb`
- E-11: `config/initializers/session_store.rb`
- E-12: `config/initializers/content_security_policy.rb`
- E-13: `config/initializers/health_check.rb`
- E-14: `app/models/application_setting.rb`
- E-15: `lib/gitlab/health_checks/base_abstract_check.rb`
- E-16: `config/initializers/regexp.rb`
- E-17: `config/puma.example.development.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Rack Timeoutデフォルト60秒 | E-01 | ○ |
| C-02 | Wait Timeoutデフォルト90秒 | E-01 | ○ |
| C-03 | Webhookタイムアウト10秒 | E-02 | ○ |
| C-04 | GraphQLタイムアウト30秒 | E-02 | ○ |
| C-05 | LDAPタイムアウト10秒 | E-02 | ○ |
| C-06 | Git Shellタイムアウト10,800秒 | E-02 | ○ |
| C-07 | KASクライアントタイムアウト5秒 | E-02 | ○ |
| C-08 | 正規表現タイムアウト40秒 | E-16 | ○ |
| C-09 | AI Action APIレートリミット8時間 | E-03 | ○ |
| C-10 | ユーザーサインイン5回/10分 | E-03 | ○ |
| C-11 | ユーザーサインアップ20回/1分 | E-03 | ○ |
| C-12 | メール検証10回/10分 | E-03 | ○ |
| C-13 | GitHubインポート6回/1分 | E-03 | ○ |
| C-14 | 認証済みGit HTTP制限3600回/時 | E-14 | ○ |
| C-15 | Product Analytics 100リクエスト/60秒 | E-05 | ○ |
| C-16 | 稼働率コード上明示なし | **根拠なし** | △ |
| C-17 | RTOコード上明示なし | **根拠なし** | △ |
| C-18 | RPOコード上明示なし | **根拠なし** | △ |
| C-19 | ヘルスチェック項目（database, migrations, cache） | E-13 | ○ |
| C-20 | セッション有効期限10,080分 | E-11, E-02 | ○ |
| C-21 | 未認証セッション有効期限2時間 | E-02 | ○ |
| C-22 | Runners登録トークン暗号化必須 | E-14 | ○ |
| C-23 | Health Check Access Token非暗号化 | E-14 | ○ |
| C-24 | LDAP証明書検証デフォルトtrue | E-02 | ○ |
| C-25 | CSP Nonce生成（SecureRandom.base64(16)） | E-12 | ○ |
| C-26 | SSRF対策パッチ存在 | E-02（設定確認） | ○ |
| C-27 | DNS Rebinding Protectionデフォルトtrue | E-02 | ○ |
| C-28 | キャッシュストアRedis | E-10 | ○ |
| C-29 | Sidekiqバージョン7.3.9 | E-09 | ○ |
| C-30 | Sidekiq Redis接続プールconcurrency+5 | E-09 | ○ |
| C-31 | Reliable Fetch実装 | E-09 | ○ |
| C-32 | Relation Importリトライ3回 | E-07 | ○ |
| C-33 | SidekiqログJSON形式対応 | E-09 | ○ |
| C-34 | ログレベルINFOデフォルト | E-09 | ○ |
| C-35 | Prometheusメトリクス設定 | E-08 | ○ |
| C-36 | 各種Sampler実装 | E-08 | ○ |
| C-37 | Rate Limiterメトリクスヒストグラム | E-03 | ○ |
| C-38 | Sidekiq Health Checks設定可能 | E-09 | ○ |
| C-39 | Sentry設定可能 | E-02 | ○ |
| C-40 | Throttle Dry Run環境変数 | E-05 | ○ |
| C-41 | Throttle Bypass Header環境変数 | E-04, E-05 | ○ |
| C-42 | 最大添付ファイルサイズ100MB | E-02 | ○ |
| C-43 | 最大アーティファクトサイズ100MB | E-02 | ○ |
| C-44 | セッションクッキーキー_gitlab_session | E-11 | ○ |
| C-45 | Geo Secondary専用セッションキー | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- **稼働率/RTO/RPO/計画停止時間**：コード解析では特定不可
  - 候補：インフラ設計書 / SLA文書 / 運用マニュアル
- **具体的な同時接続数上限**：環境設定ファイルに依存
  - 候補：本番環境設定ファイル / Kubernetesマニフェスト / デプロイメント設定

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 性能要件（タイムアウト、レートリミット）：コード上で明確に定義
- **0: 低リスク** - セキュリティ要件：CSP、暗号化、認証設定が確認可能
- **1: 中リスク** - Health Check Access Tokenの非暗号化（改善推奨のコメントあり）
- **2: 高リスク** - 可用性要件（稼働率、RTO、RPO）：コード上に定義なし、運用設計要確認

## 6) レビュアーチェックリスト（最小）
- [ ] 稼働率/RTO/RPOは別途運用設計書で定義されているか確認
- [ ] Health Check Access Tokenの暗号化対応計画を確認（Issue #376751）
- [ ] 本番環境のPuma/Sidekiq設定値を確認
- [ ] レートリミットの各閾値がApplicationSettingで適切に設定されているか確認
- [ ] CSP設定が本番環境で有効化されているか確認
- [ ] Prometheusメトリクスエンドポイントのセキュリティ確認
