# 非機能要件定義書

## 概要

本ドキュメントは、GitLab（gitlabhq-master）プロジェクトのソースコードを解析し、実装されている非機能要件を定義したものである。GitLabはDevOpsプラットフォームとして、ソースコード管理、CI/CD、プロジェクト管理等の機能を提供するRuby on Railsベースのアプリケーションである。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| Webリクエスト（Rack Timeout） | 60秒以内 | `GITLAB_RAILS_RACK_TIMEOUT`環境変数で設定可能（デフォルト60秒） |
| Webリクエスト待機時間 | 90秒以内 | `GITLAB_RAILS_WAIT_TIMEOUT`環境変数で設定可能 |
| Webhook応答 | 10秒以内 | `Settings.gitlab['webhook_timeout']`で設定 |
| GraphQL応答 | 30秒以内 | `Settings.gitlab['graphql_timeout']`で設定 |
| LDAP認証 | 10秒以内 | `server['timeout']`デフォルト値 |
| Git Shell操作 | 10,800秒以内（3時間） | `Settings.gitlab_shell['git_timeout']`で設定 |
| GitLab KASクライアント | 5秒以内 | `Settings.gitlab_kas['client_timeout_seconds']`で設定 |
| 正規表現処理 | 40秒以内 | `Regexp.timeout`（Ruby 3.2以上、`REGEXP_TIMEOUT_SECONDS`で設定可能） |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| Sidekiq Redis接続プール | concurrency + 5 | Sidekiq設定で定義 |
| Product Analytics Collector | 100リクエスト/60秒 | Rack Attackで制限 |
| 同時接続数（Puma） | 設定可能 | `config/puma.example.development.rb`で設定 |
| Worker Timeout | 60秒 | Puma設定 |

### レートリミット

| 対象 | 閾値 | インターバル | 備考 |
| --- | --- | --- | --- |
| AI Action API | 設定可能 | 8時間 | `ai_action_api_rate_limit`設定 |
| Code Suggestions API | 設定可能 | 1分 | `code_suggestions_api_rate_limit`設定 |
| Issue作成 | 設定可能 | 1分 | `issues_create_limit`設定 |
| Note作成 | 設定可能 | 1分 | `notes_create_limit`設定 |
| パイプライン作成 | 設定可能 | 1分 | `pipeline_limit_per_project_user_sha`設定 |
| 検索（認証済み） | 設定可能 | 1分 | `search_rate_limit`設定 |
| 検索（未認証） | 設定可能 | 1分 | `search_rate_limit_unauthenticated`設定 |
| ユーザーサインイン | 5回 | 10分 | 固定値 |
| ユーザーサインアップ | 20回 | 1分 | 固定値 |
| メール検証 | 10回 | 10分 | 固定値 |
| プロジェクトリポジトリアーカイブ | 5回 | 1分 | 固定値 |
| Webhook呼び出し | 設定可能 | 1分 | `web_hook_calls`設定 |
| GitHubインポート | 6回 | 1分 | 固定値 |
| Bulk Import | 6回 | 1分 | 固定値 |
| 認証済みGit HTTP | 3,600回 | 3,600秒（1時間） | `DEFAULT_AUTHENTICATED_GIT_HTTP_LIMIT` |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | コード上明示なし | 運用設計に依存 |
| 計画停止時間 | コード上明示なし | 運用設計に依存 |
| 障害復旧時間（RTO） | コード上明示なし | 運用設計に依存 |
| 目標復旧時点（RPO） | コード上明示なし | 運用設計に依存 |

### ヘルスチェック機能

| チェック項目 | 内容 |
| --- | --- |
| standard_checks | database, all-migrations, cache |
| full_checks | database, all-migrations, cache |
| Geo（EE版） | Geo専用ヘルスチェック |
| Master Check | フォーク前・Blackout期間前・Worker起動時に登録 |
| Sidekiq Health Checks | 設定可能（`Settings.monitoring.sidekiq_health_checks`） |

## セキュリティ要件

### 認証・認可

| 項目 | 設定内容 |
| --- | --- |
| セッション有効期限 | 10,080分（7日間）、`session_expire_delay`で設定可能 |
| 未認証セッション有効期限 | 7,200秒（2時間）、`unauthenticated_session_expire_delay` |
| トークン認証 | `TokenAuthenticatable`モジュールによる実装 |
| Runners登録トークン | 暗号化必須（`encrypted: :required`） |
| Health Check Access Token | 非暗号化（insecure: true）- 改善推奨 |
| Static Objects Storage Auth Token | 暗号化必須 |
| Error Tracking Access Token | 暗号化必須 |
| LDAP証明書検証 | デフォルトでtrue（`verify_certificates`） |
| WebAuthn | `WebAuthn.configuration`で設定 |
| OAuth/OmniAuth | Doorkeeper、OmniAuth統合 |

### 暗号化

| 項目 | 設定内容 |
| --- | --- |
| Active Record暗号化 | `config/initializers/active_record_encryption.rb`で設定 |
| 属性暗号化 | `Gitlab::EncryptedAttribute`モジュール |
| LDAP秘密情報 | `ldap.yaml.enc`として暗号化保存 |
| SMTP秘密情報 | `smtp.yaml.enc`として暗号化保存 |
| S3暗号化ヘッダー | CarrierWaveパッチで対応 |

### セキュリティヘッダー

| 項目 | 設定内容 |
| --- | --- |
| Content Security Policy | `config/initializers/content_security_policy.rb`で設定 |
| CSP Nonce | 各リクエストで`SecureRandom.base64(16)`を生成 |
| CSP Report Only | 設定可能（デフォルトfalse） |
| Signed Cookie Salt | `Settings['gitlab']['signed_cookie_salt']`で設定 |
| Authenticated Encrypted Cookie Salt | 設定可能 |

### 脆弱性対策

| 項目 | 対応内容 |
| --- | --- |
| SSRF対策 | `ssrf_filter_patch.rb`で対応 |
| DNS Rebinding Protection | `dns_rebinding_protection_enabled`設定（デフォルトtrue、HTTPプロキシ環境以外） |
| WikiCloth Lua無効化 | `wikicloth_disable_lua_patch.rb`で対応 |
| WikiCloth ReDoS対策 | `wikicloth_redos_patch.rb`で対応 |
| Rack脆弱性対策 | `rack_VULNDB-255039_patch.rb`で対応 |

## 拡張性要件

### キャッシュ機構

| 項目 | 設定内容 |
| --- | --- |
| キャッシュストア | Redis（`ActiveSupport::Cache::RedisCacheStore`） |
| Redisインスタンス | 複数インスタンス対応（`Gitlab::Redis::ALL_CLASSES`） |
| Rack Attack Cache | `Gitlab::RackAttack::Store`を使用 |
| 開発環境リロード | Redisプール再初期化に対応 |

### 非同期処理

| 項目 | 設定内容 |
| --- | --- |
| ジョブキュー | Sidekiq |
| Sidekiqバージョン | 7.3.9（互換性チェック実装） |
| キューシャーディング | `SIDEKIQ_SHARD_NAME`環境変数で設定可能 |
| Cronジョブ | `sidekiq-cron`による定期実行 |
| Reliable Fetch | `Sidekiq::ReliableFetch`実装 |
| Death Handler | `Gitlab::SidekiqDeathHandler`で失敗処理 |
| Concurrency Limit | `ConcurrencyLimit::ResumeWorker`で制御 |

### 水平スケーリング

| 項目 | 設定内容 |
| --- | --- |
| Pumaワーカー | 設定可能（`Gitlab::Cluster::LifecycleEvents.set_puma_worker_count`） |
| Redis Cluster | 対応（`Gitlab::Instrumentation::RedisClusterRouter`） |
| データベースロードバランシング | `config/initializers/load_balancing.rb`で設定 |
| Geo（EE版） | 地理的分散対応 |

## 保守性要件

### リトライ機構

| 項目 | 設定内容 |
| --- | --- |
| Relation Import | tries: 3, base_interval: 0.5秒, multiplier: 1.5, rand_factor: 0.5 |
| 環境変数設定 | `RELATION_IMPORT_TRIES`, `RELATION_IMPORT_BASE_INTERVAL`, `RELATION_IMPORT_MULTIPLIER`, `RELATION_IMPORT_RAND_FACTOR` |
| GitHub Import | リスケジュール機構実装（`Gitlab::GithubImport::ReschedulingMethods`） |

### ログ・デバッグ

| 項目 | 設定内容 |
| --- | --- |
| Sidekiqログフォーマット | JSON形式対応（`Gitlab::SidekiqLogging::JSONFormatter`） |
| Sidekiq引数ログ | `SIDEKIQ_LOG_ARGUMENTS`環境変数で制御（デフォルトtrue） |
| ログレベル | `GITLAB_LOG_LEVEL`環境変数で設定（デフォルトINFO） |
| Rack Timeoutログ | `GITLAB_RAILS_RACK_TIMEOUT_ENABLE_LOGGING`で制御 |
| Rate Limitログ | `Gitlab::AuthLogger`に記録 |
| 非推奨警告 | Redisで`raise_deprecations = true`（本番以外） |

### コード品質

| 項目 | 設定内容 |
| --- | --- |
| Sidekiq Strict Args | 開発/テスト環境で`:warn`、本番で`false` |
| 入力サニタイズ | `Sanitizable`モジュールで実装 |

## 運用・監視要件

### メトリクス

| 項目 | 設定内容 |
| --- | --- |
| Prometheusメトリクス | `config/initializers/7_prometheus_metrics.rb`で設定 |
| メトリクスディレクトリ | `prometheus_multiproc_dir`環境変数または`tmp/prometheus_multiproc_dir` |
| サンプラー | RubySampler, ThreadsSampler, PumaSampler, DatabaseSampler, ActionCableSampler, ConcurrencyLimitSampler, StatActivitySampler |
| 専用メトリクスサーバー | `Settings.monitoring.web_exporter.enabled`で設定可能 |
| Rate Limiterメトリクス | ヒストグラム（`gitlab_application_rate_limiter_throttle_utilization_ratio`） |

### サーバー監視

| 項目 | 設定内容 |
| --- | --- |
| Sidekiq Health Checks | 設定可能（address, port） |
| Sidekiq Monitor | `Gitlab::SidekiqDaemon::Monitor`で実行中ジョブ監視 |
| Gitaly Health Check | `Gitlab::GitalyClient::HealthCheckService`で実装 |
| Database Health Status | `Gitlab::Database::HealthStatus`で実装 |

### エラー追跡

| 項目 | 設定内容 |
| --- | --- |
| Sentry | `Settings.sentry`で設定可能（デフォルト無効） |
| Error Tracking | `error_tracking_access_token`で認証 |
| Sidekiq Death Handler | 失敗ジョブの追跡 |

### スロットリング制御

| 項目 | 設定内容 |
| --- | --- |
| Dry Run | `GITLAB_THROTTLE_DRY_RUN`環境変数（`*`で全て、カンマ区切りで個別指定） |
| Bypass Header | `GITLAB_THROTTLE_BYPASS_HEADER`環境変数で設定 |
| User Allowlist | `GITLAB_THROTTLE_USER_ALLOWLIST`環境変数で設定 |
| Sidekiq Throttling | `Gitlab::SidekiqMiddleware::Throttling`で実装 |

## 備考

### ファイルサイズ制限

| 項目 | 設定値 |
| --- | --- |
| 最大添付ファイルサイズ | 100MB（`Settings.gitlab['max_attachment_size']`） |
| 最大アーティファクトサイズ | 100MB（`Settings.artifacts['max_size']`） |

### セッション管理

| 項目 | 設定値 |
| --- | --- |
| セッションクッキーキー | `_gitlab_session`（開発環境ではハッシュ付加） |
| Geo Secondary | 専用セッションキー（`_gitlab_session_geo_*`） |
| Cells対応 | セッションクッキープレフィックスで識別 |

### 環境依存設定

多くの非機能要件パラメータは環境変数やアプリケーション設定（`ApplicationSetting`）で動的に変更可能であり、運用環境に応じた調整が可能な設計となっている。
