---
generated_at: 2026-01-23 14:30:00
metrics:
  claims_total: 49
  claims_with_evidence: 49
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：49 / 49、根拠なし：0
- 優先レビュー（高）
  1. なし：すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/io/http_client.h` - HTTPClientクラス定義
- E-02: `core/io/http_client_tcp.h` - HTTPClientTCP実装
- E-03: `platform/web/http_client_web.h` - HTTPClientWeb実装
- E-04: `scene/main/http_request.h` - HTTPRequestノード定義
- E-05: `modules/websocket/websocket_peer.h` - WebSocketPeerクラス定義
- E-06: `modules/websocket/websocket_multiplayer_peer.h` - WebSocketMultiplayerPeerクラス定義
- E-07: `modules/jsonrpc/jsonrpc.h` - JSONRPCクラス定義
- E-08: `core/io/json.h` - JSONクラス定義
- E-09: `core/extension/gdextension.h` - GDExtensionクラス定義
- E-10: `core/extension/gdextension_manager.h` - GDExtensionManagerクラス定義

## 3) Claims と根拠の対応（レビューの主戦場）

### HTTP Client API

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTPClient.connect_to_hostメソッドの存在とシグネチャ | E-01:171行目 `virtual Error connect_to_host(...)` | ○ |
| C-02 | HTTPClient.requestメソッドの存在とシグネチャ | E-01:170行目 `virtual Error request(...)` | ○ |
| C-03 | HTTPClient.get_statusメソッドの存在 | E-01:178行目 `virtual Status get_status()` | ○ |
| C-04 | HTTPClient.pollメソッドの存在 | E-01:194行目 `virtual Error poll()` | ○ |
| C-05 | HTTPClient.closeメソッドの存在 | E-01:176行目 `virtual void close()` | ○ |
| C-06 | HTTPClient.query_string_from_dictメソッドの存在 | E-01:167行目 `String query_string_from_dict(...)` | ○ |
| C-07 | HTTPClient.set_http_proxy/set_https_proxyメソッドの存在 | E-01:197-198行目 | ○ |
| C-08 | Method enum定義（METHOD_GET〜METHOD_MAX） | E-01:117-129行目 | ○ |
| C-09 | Status enum定義（STATUS_DISCONNECTED〜STATUS_TLS_HANDSHAKE_ERROR） | E-01:131-143行目 | ○ |
| C-10 | ResponseCode enum定義（全HTTPステータスコード） | E-01:43-115行目 | ○ |
| C-11 | HTTPClientクラスがRefCountedを継承 | E-01:39行目 `class HTTPClient : public RefCounted` | ○ |

### HTTPRequest API

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | HTTPRequest.requestメソッドの存在とシグネチャ | E-04:131行目 `Error request(...)` | ○ |
| C-13 | HTTPRequest.request_rawメソッドの存在 | E-04:132行目 `Error request_raw(...)` | ○ |
| C-14 | HTTPRequest.cancel_requestメソッドの存在 | E-04:133行目 `void cancel_request()` | ○ |
| C-15 | HTTPRequest.get_http_client_statusメソッドの存在 | E-04:134行目 `HTTPClient::Status get_http_client_status()` | ○ |
| C-16 | HTTPRequest.get_downloaded_bytesメソッドの存在 | E-04:161行目 `int get_downloaded_bytes()` | ○ |
| C-17 | HTTPRequest.get_body_sizeメソッドの存在 | E-04:162行目 `int get_body_size()` | ○ |
| C-18 | Result enum定義（RESULT_SUCCESS〜RESULT_TIMEOUT） | E-04:45-61行目 | ○ |
| C-19 | HTTPRequestクラスがNodeを継承 | E-04:41行目 `class HTTPRequest : public Node` | ○ |
| C-20 | プロパティ（max_redirects, timeout等）の定義 | E-04:99-101行目 | ○ |

### WebSocket API

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | WebSocketPeer.connect_to_urlメソッドの存在 | E-05:83行目 `virtual Error connect_to_url(...)` | ○ |
| C-22 | WebSocketPeer.accept_streamメソッドの存在 | E-05:84行目 `virtual Error accept_stream(...)` | ○ |
| C-23 | WebSocketPeer.sendメソッドの存在 | E-05:86行目 `virtual Error send(...)` | ○ |
| C-24 | WebSocketPeer.send_textメソッドの存在 | E-05:102行目 `Error send_text(...)` | ○ |
| C-25 | WebSocketPeer.closeメソッドの存在 | E-05:87行目 `virtual void close(...)` | ○ |
| C-26 | WebSocketPeer.pollメソッドの存在 | E-05:97行目 `virtual void poll()` | ○ |
| C-27 | WebSocketPeer.get_ready_stateメソッドの存在 | E-05:98行目 `virtual State get_ready_state()` | ○ |
| C-28 | State enum定義（STATE_CONNECTING〜STATE_CLOSED） | E-05:40-45行目 | ○ |
| C-29 | WriteMode enum定義（WRITE_MODE_TEXT, WRITE_MODE_BINARY） | E-05:47-50行目 | ○ |
| C-30 | WebSocketPeerクラスがPacketPeerを継承 | E-05:36行目 `class WebSocketPeer : public PacketPeer` | ○ |
| C-31 | DEFAULT_BUFFER_SIZE定数（65535） | E-05:52-54行目 | ○ |

### WebSocketMultiplayerPeer API

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | WebSocketMultiplayerPeer.create_serverメソッドの存在 | E-06:115行目 `Error create_server(...)` | ○ |
| C-33 | WebSocketMultiplayerPeer.create_clientメソッドの存在 | E-06:114行目 `Error create_client(...)` | ○ |
| C-34 | WebSocketMultiplayerPeer.get_peerメソッドの存在 | E-06:112行目 `virtual Ref<WebSocketPeer> get_peer(...)` | ○ |
| C-35 | WebSocketMultiplayerPeer.get_peer_address/get_peer_portメソッドの存在 | E-06:132-133行目 | ○ |
| C-36 | WebSocketMultiplayerPeerクラスがMultiplayerPeerを継承 | E-06:39行目 `class WebSocketMultiplayerPeer : public MultiplayerPeer` | ○ |

### JSON-RPC API

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | JSONRPC.set_methodメソッドの存在 | E-07:69行目 `void set_method(...)` | ○ |
| C-38 | JSONRPC.process_actionメソッドの存在 | E-07:66行目 `Variant process_action(...)` | ○ |
| C-39 | JSONRPC.process_stringメソッドの存在 | E-07:67行目 `String process_string(...)` | ○ |
| C-40 | JSONRPC.make_requestメソッドの存在 | E-07:64行目 `Dictionary make_request(...)` | ○ |
| C-41 | JSONRPC.make_responseメソッドの存在 | E-07:62行目 `Dictionary make_response(...)` | ○ |
| C-42 | JSONRPC.make_notificationメソッドの存在 | E-07:63行目 `Dictionary make_notification(...)` | ○ |
| C-43 | JSONRPC.make_response_errorメソッドの存在 | E-07:61行目 `Dictionary make_response_error(...)` | ○ |
| C-44 | ErrorCode enum定義（PARSE_ERROR〜INTERNAL_ERROR） | E-07:53-59行目 | ○ |

### JSON API

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | JSON.parseメソッドの存在 | E-08:89行目 `Error parse(...)` | ○ |
| C-46 | JSON.stringify静的メソッドの存在 | E-08:92行目 `static String stringify(...)` | ○ |
| C-47 | JSON.parse_string静的メソッドの存在 | E-08:93行目 `static Variant parse_string(...)` | ○ |
| C-48 | JSON.from_native/to_native静的メソッドの存在 | E-08:95-100行目 | ○ |
| C-49 | JSONクラスがResourceを継承 | E-08:38行目 `class JSON : public Resource` | ○ |

### GDExtension API

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | GDExtension.open_libraryメソッドの存在 | E-09:139行目 `Error open_library(...)` | ○ |
| C-51 | GDExtension.close_libraryメソッドの存在 | E-09:140行目 `void close_library()` | ○ |
| C-52 | GDExtension.is_library_openメソッドの存在 | E-09:141行目 `bool is_library_open()` | ○ |
| C-53 | GDExtension.initialize_libraryメソッドの存在 | E-09:172行目 `void initialize_library(...)` | ○ |
| C-54 | GDExtension.deinitialize_libraryメソッドの存在 | E-09:173行目 `void deinitialize_library(...)` | ○ |
| C-55 | InitializationLevel enum定義 | E-09:143-148行目 | ○ |

### GDExtensionManager API

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | GDExtensionManager.load_extensionメソッドの存在 | E-10:71行目 `LoadStatus load_extension(...)` | ○ |
| C-57 | GDExtensionManager.load_extension_with_loaderメソッドの存在 | E-10:73行目 | ○ |
| C-58 | GDExtensionManager.reload_extensionメソッドの存在 | E-10:74行目 | ○ |
| C-59 | GDExtensionManager.unload_extensionメソッドの存在 | E-10:75行目 | ○ |
| C-60 | GDExtensionManager.is_extension_loadedメソッドの存在 | E-10:76行目 | ○ |
| C-61 | GDExtensionManager.get_loaded_extensionsメソッドの存在 | E-10:77行目 | ○ |
| C-62 | GDExtensionManager.get_extensionメソッドの存在 | E-10:78行目 | ○ |
| C-63 | LoadStatus enum定義 | E-10:53-59行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべての主張についてソースコードから根拠を確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードのヘッダーファイルから直接確認されており、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [x] 各APIメソッドのシグネチャがソースコードと一致しているか
- [x] enum定義の値がソースコードと一致しているか
- [x] クラスの継承関係が正確に記載されているか
- [x] ソースファイルの行番号が実際のコードと対応しているか
- [ ] 使用例のコードが実際に動作するか確認（ランタイムテスト推奨）
- [ ] Godot公式ドキュメントとの整合性を確認
