# Godot Engine

## 概要

Godot Engineは、2Dおよび3Dゲームを統一インターフェースから作成できる、機能豊富なクロスプラットフォームゲームエンジンです。MITライセンスの下で完全に無料かつオープンソースで提供されており、ロイヤリティなしで商用・非商用を問わず利用できます。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| 2Dゲーム開発 | スプライト、タイルマップ、物理演算など2D向けの包括的なノードとツール |
| 3Dゲーム開発 | メッシュ、ライティング、物理演算、アニメーションなど3D向けの高度な機能 |
| スクリプト言語 | GDScript（Python風独自言語）、C#（Monoモジュール経由） |
| ビジュアルエディタ | シーン編集、アニメーション、シェーダー編集などの統合開発環境 |
| マルチプラットフォームエクスポート | Windows、macOS、Linux、Android、iOS、Webへのワンクリックエクスポート |
| 物理エンジン | 2D/3D物理演算（Godot Physics、Jolt Physics対応） |
| ナビゲーション | 2D/3Dナビゲーションメッシュによる経路探索 |
| ネットワーク | マルチプレイヤー、WebSocket、WebRTC対応 |
| レンダリング | Vulkan、OpenGL3/GLES3、Direct3D 12、Metalレンダラー対応 |
| XRサポート | OpenXR、WebXR、モバイルVR対応 |
| オーディオ | 効果音、BGM、インタラクティブミュージック |
| GUI | 高度なGUIコントロールとテーマシステム |

## 技術スタック

### コア

- ビルドシステム: SCons 4.0以上
- 言語: C++17、Python 3.8以上（ビルドスクリプト用）
- グラフィックスAPI: Vulkan、OpenGL3/GLES3、Direct3D 12、Metal
- スクリプト言語: GDScript、C#（Mono）

### 主要ライブラリ（サードパーティ）

- Vulkan SDK（volk経由での動的ローディング）
- FreeType（フォントレンダリング）
- HarfBuzz（テキストシェーピング）
- mbedTLS（暗号化、TLS）
- Embree（レイキャスティング）
- Jolt Physics（3D物理エンジン）
- OpenXR（VR/ARサポート）
- SDL3（入力ドライバー）
- ICU4C（国際化）
- zlib、zstd、Brotli（圧縮）
- libpng、libjpeg-turbo、libwebp（画像処理）
- libvorbis、libtheora（オーディオ/ビデオ）

## ディレクトリ構成

```
godot-master/
├── core/               # エンジンコア機能（メモリ管理、数学、IO、オブジェクトシステム）
│   ├── config/         # 設定管理
│   ├── crypto/         # 暗号化機能
│   ├── debugger/       # デバッガー
│   ├── error/          # エラーハンドリング
│   ├── extension/      # GDExtension API
│   ├── input/          # 入力処理
│   ├── io/             # 入出力、ファイルシステム
│   ├── math/           # 数学ライブラリ
│   ├── object/         # オブジェクトシステム
│   ├── os/             # OS抽象化レイヤー
│   ├── string/         # 文字列処理
│   ├── templates/      # テンプレートコンテナ
│   └── variant/        # 動的型システム（Variant）
├── drivers/            # デバイスドライバー（グラフィックス、オーディオ等）
├── editor/             # エディタUI・機能
├── main/               # メインエントリーポイント、初期化
├── modules/            # オプショナルモジュール
│   ├── gdscript/       # GDScriptスクリプト言語
│   ├── mono/           # C#サポート
│   ├── gltf/           # glTF 2.0インポート/エクスポート
│   ├── multiplayer/    # マルチプレイヤー機能
│   ├── navigation_2d/  # 2Dナビゲーション
│   ├── navigation_3d/  # 3Dナビゲーション
│   ├── openxr/         # OpenXR VR/ARサポート
│   ├── websocket/      # WebSocket通信
│   └── ...             # その他多数のモジュール
├── platform/           # プラットフォーム固有コード
│   ├── android/        # Androidサポート
│   ├── ios/            # iOSサポート
│   ├── linuxbsd/       # Linux/BSDサポート
│   ├── macos/          # macOSサポート
│   ├── web/            # Webプラットフォーム（Emscripten）
│   ├── windows/        # Windowsサポート
│   └── visionos/       # visionOSサポート
├── scene/              # シーンシステム、ノード
│   ├── 2d/             # 2Dノード
│   ├── 3d/             # 3Dノード
│   ├── animation/      # アニメーションシステム
│   ├── audio/          # オーディオノード
│   ├── gui/            # GUIコントロール
│   ├── main/           # メインシーンループ
│   ├── resources/      # リソースタイプ
│   └── theme/          # テーマシステム
├── servers/            # サーバー（レンダリング、物理、オーディオ等）
├── tests/              # ユニットテスト（doctest使用）
├── thirdparty/         # サードパーティライブラリ
├── doc/                # ドキュメント
├── misc/               # ユーティリティ、設定ファイル
└── SConstruct          # メインビルドスクリプト
```

## セットアップ

### 必要条件

- **Python**: 3.8以上
- **SCons**: 4.0以上
- **C++コンパイラ**:
  - GCC 9以上
  - Clang 6以上（Apple Clang 16以上）
  - Visual Studio 2017 15.9以上（推奨: VS2019 16.11以上またはVS2022）

### プラットフォーム別追加要件

各プラットフォームでのビルドには、それぞれ追加の依存関係が必要です。詳細は[公式ドキュメント](https://docs.godotengine.org/en/latest/engine_details/development/compiling)を参照してください。

### インストール手順

1. リポジトリをクローン

```bash
git clone https://github.com/godotengine/godot.git
cd godot
```

2. プラットフォームを指定してビルド

```bash
# エディタビルド（デフォルト）
scons platform=linuxbsd  # Linux/BSD
scons platform=macos     # macOS
scons platform=windows   # Windows

# エクスポートテンプレート（リリース版）
scons platform=linuxbsd target=template_release

# エクスポートテンプレート（デバッグ版）
scons platform=linuxbsd target=template_debug
```

### バイナリダウンロード

ビルド済みバイナリは[Godot公式サイト](https://godotengine.org/download)からダウンロードできます。

## 開発

### コードスタイル

- C++: `.clang-format`によるフォーマット
- Python: `ruff`によるリンティング、`pyproject.toml`で設定
- コミット前フック: `.pre-commit-config.yaml`で設定

### リンター/フォーマッター

```bash
# pre-commitフックのセットアップ
pip install pre-commit
pre-commit install

# 手動でフォーマット実行
clang-format -i <file>

# Pythonリンティング
ruff check .
ruff format .
```

### テストの実行

```bash
# テストビルドを有効化
scons platform=linuxbsd tests=yes

# テスト実行
./bin/godot.linuxbsd.editor.x86_64 --test
```

### ビルドオプション

| オプション | 説明 | デフォルト |
| --- | --- | --- |
| `platform` | ターゲットプラットフォーム | 自動検出 |
| `target` | ビルドタイプ（editor/template_release/template_debug） | editor |
| `arch` | CPUアーキテクチャ | auto |
| `dev_build` | 開発者ビルド（デバッグ情報あり） | no |
| `tests` | ユニットテストをビルド | no |
| `production` | プロダクションビルド設定 | no |
| `vulkan` | Vulkanレンダラーを有効化 | yes |
| `opengl3` | OpenGL3/GLES3レンダラーを有効化 | yes |
| `precision` | 浮動小数点精度（single/double） | single |

詳細なオプションは`scons --help`で確認できます。

## コミュニティ

- [公式サイト](https://godotengine.org)
- [公式ドキュメント](https://docs.godotengine.org)
- [GitHub リポジトリ](https://github.com/godotengine/godot)
- [Godot Contributors Chat](https://chat.godotengine.org)
- [機能提案](https://github.com/godotengine/godot-proposals)

## ライセンス

MIT License - 詳細は[LICENSE.txt](../../LICENSE.txt)を参照してください。
