---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **visionOSサポート**：プラットフォームディレクトリ存在を確認したが、公式ドキュメントでの明記は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md`（プロジェクトルート）
- E-02: `LICENSE.txt`
- E-03: `CONTRIBUTING.md`
- E-04: `version.py`
- E-05: `SConstruct`
- E-06: `pyproject.toml`
- E-07: `core/` ディレクトリ構成
- E-08: `modules/` ディレクトリ構成
- E-09: `platform/` ディレクトリ構成
- E-10: `scene/` ディレクトリ構成
- E-11: `tests/` ディレクトリ構成
- E-12: `thirdparty/` ディレクトリ構成
- E-13: `.clang-format`
- E-14: `.pre-commit-config.yaml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Godot Engineは2D/3Dゲームエンジンである | E-01 | ○ |
| C-02 | MITライセンスで提供されている | E-01, E-02 | ○ |
| C-03 | クロスプラットフォーム対応（Windows、macOS、Linux、Android、iOS、Web） | E-01, E-09 | ○ |
| C-04 | SCons 4.0以上が必要 | E-05 | ○ |
| C-05 | Python 3.8以上が必要 | E-05, E-06 | ○ |
| C-06 | C++17が使用されている | E-05 | ○ |
| C-07 | GDScriptスクリプト言語をサポート | E-08 (`modules/gdscript/`) | ○ |
| C-08 | C#（Mono）をサポート | E-08 (`modules/mono/`) | ○ |
| C-09 | Vulkanレンダラー対応 | E-05, E-12 (`thirdparty/vulkan/`) | ○ |
| C-10 | OpenGL3/GLES3レンダラー対応 | E-05 | ○ |
| C-11 | Direct3D 12対応 | E-05, E-12 (`thirdparty/d3d12ma/`) | ○ |
| C-12 | Metal対応 | E-05 | ○ |
| C-13 | GCC 9以上が必要 | E-05 | ○ |
| C-14 | Clang 6以上が必要 | E-05 | ○ |
| C-15 | Visual Studio 2017 15.9以上が必要 | E-05 | ○ |
| C-16 | FreeType、HarfBuzzを使用 | E-12 (`thirdparty/freetype/`, `thirdparty/harfbuzz/`) | ○ |
| C-17 | mbedTLSを使用 | E-12 (`thirdparty/mbedtls/`) | ○ |
| C-18 | OpenXR VR/AR対応 | E-08 (`modules/openxr/`), E-12 (`thirdparty/openxr/`) | ○ |
| C-19 | Jolt Physics対応 | E-08 (`modules/jolt_physics/`), E-12 (`thirdparty/jolt_physics/`) | ○ |
| C-20 | ユニットテスト（doctest）対応 | E-11, E-12 (`thirdparty/doctest/`) | ○ |
| C-21 | マルチプレイヤー機能対応 | E-08 (`modules/multiplayer/`) | ○ |
| C-22 | WebSocketサポート | E-08 (`modules/websocket/`) | ○ |
| C-23 | pre-commitフック設定あり | E-14 | ○ |
| C-24 | clang-formatでコードフォーマット | E-13 | ○ |
| C-25 | visionOSサポート | E-09 (`platform/visionos/`) | △ |

## 4) 不足情報（Unknown / Missing）
- **visionOSサポート（C-25）**：プラットフォームディレクトリは存在するが、公式ドキュメントや公式サイトでの明示的なサポート表明は未確認
  - 候補：Godot公式ブログ / 公式ドキュメント / リリースノート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プロジェクト概要、ライセンス情報、主要機能の記載
- 0: 低リスク - ビルド要件（コンパイラバージョン等）
- 0: 低リスク - ディレクトリ構成
- 1: 中リスク - visionOSサポートの記載（プラットフォームは存在するが安定性・サポート状況は要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] プロジェクト概要が実際のREADME.mdと一致しているか確認
- [ ] ビルド手順が現在のSConstructの内容と整合しているか確認
- [ ] サポートプラットフォームの一覧が最新の状態と一致しているか確認
- [ ] visionOSのサポート状況について公式情報を確認
- [ ] サードパーティライブラリの一覧が最新のthirdparty/ディレクトリと一致しているか確認
