---
generated_at: 2026-01-23 16:45:00
metrics:
  claims_total: 42
  claims_with_evidence: 40
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：40 / 42、根拠なし：2
- 優先レビュー（高）
  1. **データフロー詳細**：実際の関数呼び出しフローの網羅性を要確認
  2. **バージョン依存情報**：C++17標準の記載が現行ビルド設定と一致するか確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要
- E-02: `CONTRIBUTING.md` - 開発ガイドライン
- E-03: `SConstruct` - ビルド設定ファイル
- E-04: `core/object/object.h` - Objectクラス定義
- E-05: `core/variant/variant.h` - Variant型定義
- E-06: `scene/main/node.h` - Node基底クラス
- E-07: `scene/main/scene_tree.h` - SceneTree定義
- E-08: `main/main.cpp` - エントリーポイント
- E-09: `scene/2d/node_2d.h` - Node2Dクラス
- E-10: `scene/3d/node_3d.h` - Node3Dクラス
- E-11: `modules/gdscript/gdscript.h` - GDScript定義
- E-12: `core/io/resource.h` - Resourceクラス
- E-13: `core/object/class_db.h` - ClassDB定義
- E-14: `core/register_core_types.cpp` - 型登録処理
- E-15: `servers/rendering/rendering_server_default.h` - レンダリングサーバー
- E-16: ディレクトリ構造（実際のファイルシステム）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GodotはC++17を使用 | E-03 (SConstruct) | ○ |
| C-02 | #pragma onceをインクルードガードとして使用 | E-04, E-05, E-06 | ○ |
| C-03 | Variant型が動的型として機能 | E-05 (variant.h:93-146) | ○ |
| C-04 | typedef でPackedArrayを定義 | E-05 (variant.h:81-91) | ○ |
| C-05 | プリプロセッサによる条件コンパイル | E-08 (main.cpp:82-133) | ○ |
| C-06 | getter/setterパターンの使用 | E-09 (node_2d.h:78-95) | ○ |
| C-07 | ADD_PROPERTY等のマクロ定義 | E-04 (object.h:135-143) | ○ |
| C-08 | 相対パスベースのインクルード | E-06 (node.h:33-39) | ○ |
| C-09 | GDCLASSマクロでクラス宣言 | E-06, E-09, E-11 | ○ |
| C-10 | Object継承の階層構造 | E-04, E-06 | ○ |
| C-11 | RefCountedによる参照カウント | E-12 (resource.h:53-57) | ○ |
| C-12 | Ref<T>テンプレートの使用 | E-11 (gdscript.h:94-96) | ○ |
| C-13 | snake_caseのファイル命名 | E-16 (実ファイル確認) | ○ |
| C-14 | register_*_types.cppの命名パターン | E-14, E-16 | ○ |
| C-15 | *_server.hの命名パターン | E-15, E-16 | ○ |
| C-16 | p_プレフィックスはパラメータ | E-04, E-09 | ○ |
| C-17 | r_プレフィックスは参照出力 | E-04 | ○ |
| C-18 | _bind_methods()のパターン | E-06, E-09 | ○ |
| C-19 | SCREAMING_SNAKE_CASEの定数命名 | E-05, E-06 | ○ |
| C-20 | core/ディレクトリがエンジン基盤 | E-16 (実構造確認) | ○ |
| C-21 | scene/ディレクトリがシーンシステム | E-16 (実構造確認) | ○ |
| C-22 | servers/がシングルトンサーバー | E-16 (実構造確認) | ○ |
| C-23 | modules/がオプショナル機能 | E-16 (実構造確認) | ○ |
| C-24 | platform/がOS固有コード | E-16 (実構造確認) | ○ |
| C-25 | サーバー・クライアントアーキテクチャ | E-08, E-15 | ○ |
| C-26 | main.cppがエントリーポイント | E-08 (main.cpp:156-200) | ○ |
| C-27 | Static Singletonsの初期化順序 | E-08 (main.cpp:156-192) | ○ |
| C-28 | PropertyHint列挙型の定義 | E-04 (object.h:50-97) | ○ |
| C-29 | PropertyInfo構造体の定義 | E-04 (object.h:159-197) | ○ |
| C-30 | Node.ProcessMode列挙型 | E-06 (node.h:75-81) | ○ |
| C-31 | SceneTreeがMainLoop継承 | E-07 (scene_tree.h:85-88) | ○ |
| C-32 | Window* rootメンバ | E-07 (scene_tree.h:134) | ○ |
| C-33 | RenderingServerDefaultの実装 | E-15 (rendering_server_default.h:44-92) | ○ |
| C-34 | CommandQueueMTの使用 | E-15 (rendering_server_default.h:77) | ○ |
| C-35 | GDSOFTCLASSの存在 | E-15 (rendering_server_default.h:45) | ○ |
| C-36 | TOOLS_ENABLED条件コンパイル | E-08 (main.cpp:111-133) | ○ |
| C-37 | .gen.hファイルの存在 | E-08 (main.cpp:38), E-16 | ○ |
| C-38 | .compat.incファイルの存在 | E-16 (実ファイル確認) | ○ |
| C-39 | memne wによるメモリ管理 | E-14 (register_core_types.cpp:144) | ○ |
| C-40 | StringNameの存在と用途 | E-04, E-05 | ○ |
| C-41 | 詳細なデータフローの説明 | **推定による記述** | △ |
| C-42 | エンジン起動フローの完全性 | **一部推定** | △ |

## 4) 不足情報（Unknown / Missing）
- C-41, C-42: データフローおよび起動フローの詳細は、実際のソースコード全体を追跡して検証する必要があります。本ドキュメントでは主要な関数とファイルのみを参照し、完全な呼び出しチェーンは推定に基づいています。
  - 候補：`main/main.cpp` の全関数追跡 / デバッガによる実行時検証 / 公式ドキュメントとの照合

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分の主張がソースコードの直接参照により裏付けられている
- **1 (中リスク)**: データフローの記述（C-41, C-42）は概念的な説明であり、すべてのエッジケースをカバーしていない可能性がある
- **0 (低リスク)**: 命名規則、ディレクトリ構造、マクロパターンは実際のファイルから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] C++17使用の記述がプロジェクトの現行ビルド設定と一致するか確認
- [ ] GDCLASSマクロの説明が最新のGodotバージョンと整合しているか確認
- [ ] サーバー・クライアントアーキテクチャの図が実際のコード構造を正しく反映しているか確認
- [ ] データフロー（C-41）の説明で省略されている中間処理がないか確認
- [ ] トラブルシューティングセクションのQ&Aが実際の開発者FAQと一致するか確認
- [ ] 用語集の定義が公式ドキュメントと整合しているか確認
