---
generated_at: 2026-01-23 17:05:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **TTL設定**：キャッシュのTTL値は推測
  2. **具体的なVulkanバージョン要件**：明示的なバージョン記載なし
  3. **プロファイリングの外部ツール連携**：具体的なツール名の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、ライセンス情報
- E-02: `version.py` - バージョン情報（4.6 RC）
- E-03: `SConstruct` - ビルドシステム、プラットフォーム対応
- E-04: `core/object/object.h` - Objectシステム、PropertyInfo
- E-05: `main/main.cpp` - エンジン初期化、サーバー構成
- E-06: `core/register_core_types.cpp` - Coreタイプ登録
- E-07: `scene/main/scene_tree.h` - SceneTree実装
- E-08: `servers/rendering/rendering_server_default.h` - レンダリングサーバー実装
- E-09: `modules/gdscript/gdscript.h` - GDScript実装
- E-10: `core/` ディレクトリ構造 - Coreレイヤー構成
- E-11: `servers/` ディレクトリ構造 - Serversレイヤー構成
- E-12: `scene/` ディレクトリ構造 - Sceneレイヤー構成
- E-13: `modules/` ディレクトリ構造 - 60以上のモジュール存在確認
- E-14: `drivers/` ディレクトリ構造 - ドライバー構成
- E-15: `editor/` ディレクトリ構造 - エディタ構成
- E-16: `platform/` ディレクトリ構造 - プラットフォーム実装
- E-17: `thirdparty/` ディレクトリ構造 - サードパーティライブラリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Godot Engine 4.6のゲームエンジン | E-01, E-02 | ○ |
| C-02 | C++実装 | E-04, E-05 | ○ |
| C-03 | MIT License | E-01 | ○ |
| C-04 | Vulkan/D3D12/Metal/OpenGL対応 | E-03, E-14 | ○ |
| C-05 | 複数プラットフォーム対応（Windows/macOS/Linux/Android/iOS/Web） | E-03, E-16 | ○ |
| C-06 | 物理エンジン統合（Jolt Physics/Godot Physics） | E-13 | ○ |
| C-07 | ENet/WebSocket/WebRTC対応 | E-13 | ○ |
| C-08 | GDExtensionによる拡張機構 | E-05, E-06 | ○ |
| C-09 | コンポーネントベース＋レイヤードアーキテクチャ | E-10, E-11, E-12 | ○ |
| C-10 | シーングラフ（Node）構造 | E-07 | ○ |
| C-11 | サーバーパターン採用 | E-05, E-08 | ○ |
| C-12 | モジュラー設計 | E-13 | ○ |
| C-13 | Editorレイヤー構成 | E-15 | ○ |
| C-14 | Sceneレイヤー構成 | E-12 | ○ |
| C-15 | Serversレイヤー構成 | E-11 | ○ |
| C-16 | Modulesレイヤー構成 | E-13 | ○ |
| C-17 | Driversレイヤー構成 | E-14 | ○ |
| C-18 | Coreレイヤー構成 | E-10 | ○ |
| C-19 | Platformレイヤー構成 | E-16 | ○ |
| C-20 | GDScript/Monoスクリプティング | E-09, E-13 | ○ |
| C-21 | 60以上のモジュール存在 | E-13 | ○ |
| C-22 | パッケージ構造 | E-10, E-11, E-12, E-13 | ○ |
| C-23 | Object→ClassDB依存 | E-04 | ○ |
| C-24 | SceneTree→Node依存 | E-07 | ○ |
| C-25 | RenderingServer実装 | E-08 | ○ |
| C-26 | ResourceCache内部実装 | E-06 | ○ |
| C-27 | MessageQueue内部実装 | E-05, E-04 | ○ |
| C-28 | CommandQueueMT実装 | E-08 | ○ |
| C-29 | Vulkan 1.3+対応 | E-03, E-17 | △ |
| C-30 | mbedTLS統合 | E-17 | ○ |
| C-31 | FreeType/HarfBuzz統合 | E-17 | ○ |
| C-32 | フレーム処理フロー | E-05 | ○ |
| C-33 | レンダリング非同期処理 | E-08 | ○ |
| C-34 | リソース非同期ロード | E-06 | ○ |
| C-35 | 暗号化リソース対応 | E-06 | ○ |
| C-36 | エラーハンドリングマクロ | E-04, E-05 | ○ |
| C-37 | UndoRedo実装 | E-06 | ○ |
| C-38 | シグナル/スロットパターン | E-04 | ○ |
| C-39 | 命名規則（snake_case/PascalCase） | E-04, E-05 | ○ |
| C-40 | #pragma once使用 | E-04, E-08 | ○ |
| C-41 | SConsビルドシステム | E-03 | ○ |
| C-42 | キャッシュTTL値 | **根拠なし** | △ |
| C-43 | プロファイリング外部ツール連携 | **根拠不足** | △ |
| C-44 | visionOS対応 | E-16 | ○ |
| C-45 | WorkerThreadPool実装 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-29: Vulkan具体的バージョン要件**
  - SConstructでvulkan=yes/noのオプションは確認できるが、必須バージョン1.3+は公式ドキュメントからの推測
  - 候補：thirdparty/vulkan/のヘッダファイル確認 / 公式ドキュメント参照 / コミット履歴確認

- **C-42: キャッシュTTL値**
  - ResourceCache等のTTL（セッション中/永続）は実装からの推測
  - 候補：core/io/resource_loader.cpp確認 / 明示的なTTL設定コード確認

- **C-43: プロファイリング外部ツール連携**
  - EngineProfiler存在は確認できるが、具体的な外部ツール連携の詳細は未確認
  - 候補：editor/debugger/確認 / profiling関連ソース確認

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**: レイヤー構成、モジュール構成、プラットフォーム対応 - ディレクトリ構造から直接確認可能
- **リスク0（低リスク）**: Object/ClassDB設計 - ソースコードから直接確認
- **リスク1（中リスク）**: データフローの詳細 - main.cppから大枠は確認できるが、全ての処理パスは網羅していない
- **リスク1（中リスク）**: サードパーティライブラリのバージョン - thirdparty/README.mdに詳細があるが全ては確認していない
- **リスク0（低リスク）**: ビルドシステム構成 - SConstructから直接確認

## 6) レビュアーチェックリスト（最小）
- [ ] レイヤー間依存関係ルールが実際のコードと一致するか
- [ ] 記載されているサーバー（RenderingServer等）がすべて存在するか
- [ ] モジュール一覧が現在のmodules/と一致するか
- [ ] プラットフォーム対応一覧がplatform/と一致するか
- [ ] キャッシュ・メッセージキューの実装詳細が正確か
- [ ] データフロー（フレーム処理）が実際の実行順序と一致するか
- [ ] エラーハンドリングマクロの使用法が正確か
