# アーキテクチャ構成図

## システム全体構成図

```mermaid
graph TB
    subgraph "Godot Engine Architecture"
        subgraph "Editor Layer"
            ED[EditorNode]
            PI[Project Manager]
            IN[Inspector]
            SC[Scene Editor]
            DB[Debugger]
        end

        subgraph "Scene Layer"
            ST[SceneTree]
            N[Node]
            N2D[Node2D]
            N3D[Node3D]
            CT[Control]
            RS[Resources]
        end

        subgraph "Servers Layer"
            RNS[RenderingServer]
            PHS2[PhysicsServer2D]
            PHS3[PhysicsServer3D]
            ADS[AudioServer]
            DPS[DisplayServer]
            NVS[NavigationServer]
            TXS[TextServer]
        end

        subgraph "Modules Layer"
            GDS[GDScript]
            MNO[Mono/C#]
            MPL[Multiplayer]
            GLT[GLTF/FBX]
            NVG[Navigation]
        end

        subgraph "Drivers Layer"
            VLK[Vulkan Driver]
            GLS[GLES3 Driver]
            MTL[Metal Driver]
            D3D[D3D12 Driver]
            ADR[Audio Drivers]
        end

        subgraph "Core Layer"
            OBJ[Object System]
            VAR[Variant]
            RES[Resource System]
            IOS[I/O System]
            MTH[Math Library]
            TPL[Templates]
        end

        subgraph "Platform Layer"
            WIN[Windows]
            MAC[macOS]
            LNX[Linux/BSD]
            AND[Android]
            IOS2[iOS]
            WEB[Web/HTML5]
        end
    end

    ED --> ST
    PI --> ST
    IN --> ST
    SC --> ST
    DB --> ST

    ST --> N
    N --> N2D
    N --> N3D
    N --> CT
    N --> RS

    N2D --> RNS
    N2D --> PHS2
    N3D --> RNS
    N3D --> PHS3
    CT --> RNS
    RS --> RNS

    ST --> GDS
    ST --> MNO
    ST --> MPL
    RS --> GLT

    RNS --> VLK
    RNS --> GLS
    RNS --> MTL
    RNS --> D3D
    ADS --> ADR

    VLK --> OBJ
    GLS --> OBJ
    MTL --> OBJ
    D3D --> OBJ
    ADR --> OBJ

    OBJ --> WIN
    OBJ --> MAC
    OBJ --> LNX
    OBJ --> AND
    OBJ --> IOS2
    OBJ --> WEB
```

## レイヤー構成図

```mermaid
graph LR
    subgraph "Application Level"
        A[Game/Application]
    end

    subgraph "High Level"
        B[Editor]
        C[Scene System]
        D[GDScript/C#]
    end

    subgraph "Mid Level"
        E[Servers]
        F[Modules]
    end

    subgraph "Low Level"
        G[Drivers]
        H[Core]
    end

    subgraph "Platform Level"
        I[Platform Abstraction]
    end

    A --> B
    A --> C
    A --> D

    B --> E
    C --> E
    D --> E
    D --> F

    E --> G
    E --> H
    F --> H

    G --> I
    H --> I
```

## コンポーネント依存関係図

```mermaid
graph TB
    subgraph "Object System"
        Object[Object]
        RefCounted[RefCounted]
        Resource[Resource]
        Node[Node]
        ClassDB[ClassDB]
    end

    subgraph "Scene Components"
        SceneTree[SceneTree]
        MainLoop[MainLoop]
        Window[Window]
        Viewport[Viewport]
    end

    subgraph "Scripting"
        ScriptLanguage[ScriptLanguage]
        GDScript[GDScript]
        GDScriptFunction[GDScriptFunction]
    end

    subgraph "Rendering"
        RenderingServer[RenderingServer]
        RendererCompositor[RendererCompositor]
        RendererViewport[RendererViewport]
        RendererCanvasCull[RendererCanvasCull]
    end

    Object --> ClassDB
    RefCounted --> Object
    Resource --> RefCounted
    Node --> Object

    MainLoop --> Object
    SceneTree --> MainLoop
    Window --> Viewport
    Viewport --> Node

    ScriptLanguage --> Object
    GDScript --> ScriptLanguage
    GDScriptFunction --> Object

    RenderingServer --> Object
    RendererCompositor --> RenderingServer
    RendererViewport --> RendererCompositor
    RendererCanvasCull --> RendererCompositor
```

## データフロー図

```mermaid
sequenceDiagram
    participant OS as OS/Platform
    participant Main as Main Loop
    participant Input as InputMap
    participant Scene as SceneTree
    participant Physics as PhysicsServer
    participant Render as RenderingServer
    participant Display as DisplayServer

    OS->>Main: run()
    loop Every Frame
        Main->>Input: poll_events()
        Input->>Scene: dispatch_input()
        Main->>Scene: process(delta)
        Scene->>Scene: _process() callbacks
        Main->>Physics: step(delta)
        Physics->>Scene: physics_process()
        Scene->>Scene: _physics_process() callbacks
        Main->>Render: draw()
        Render->>Display: swap_buffers()
    end
```

## サーバー構成図

```mermaid
graph TB
    subgraph "Main Thread"
        MT[Main Thread]
        ST[SceneTree]
        CMD[Commands]
    end

    subgraph "Servers"
        subgraph "RenderingServer"
            RSM[RenderingServerDefault]
            CQ[CommandQueueMT]
            RT[Render Thread]
        end

        subgraph "PhysicsServer"
            PS2[PhysicsServer2D]
            PS3[PhysicsServer3D]
            JOLT[Jolt Physics]
        end

        subgraph "AudioServer"
            AS[AudioServer]
            AD[Audio Drivers]
        end

        subgraph "DisplayServer"
            DS[DisplayServer]
            WM[Window Manager]
        end
    end

    subgraph "GPU/Hardware"
        GPU[GPU]
        APU[Audio Hardware]
    end

    MT --> ST
    ST --> CMD
    CMD --> RSM
    RSM --> CQ
    CQ --> RT
    RT --> GPU

    CMD --> PS2
    CMD --> PS3
    PS3 --> JOLT

    CMD --> AS
    AS --> AD
    AD --> APU

    CMD --> DS
    DS --> WM
```

## モジュール構成図

```mermaid
graph TB
    subgraph "Core Modules"
        M1[gdscript]
        M2[mono]
    end

    subgraph "Media Modules"
        M3[ogg]
        M4[vorbis]
        M5[mp3]
        M6[svg]
        M7[webp]
    end

    subgraph "Import/Export Modules"
        M8[gltf]
        M9[fbx]
    end

    subgraph "Physics Modules"
        M10[godot_physics_2d]
        M11[godot_physics_3d]
        M12[jolt_physics]
    end

    subgraph "Network Modules"
        M13[multiplayer]
        M14[enet]
        M15[websocket]
        M16[webrtc]
    end

    subgraph "Navigation Modules"
        M17[navigation_2d]
        M18[navigation_3d]
    end

    subgraph "XR Modules"
        M19[openxr]
        M20[webxr]
        M21[mobile_vr]
    end

    M1 --> Core[Core Layer]
    M2 --> Core
    M3 --> Core
    M4 --> M3
    M5 --> Core
    M6 --> Core
    M7 --> Core
    M8 --> Scene[Scene Layer]
    M9 --> Scene
    M10 --> Servers[Servers Layer]
    M11 --> Servers
    M12 --> Servers
    M13 --> Core
    M14 --> Core
    M15 --> Core
    M16 --> Core
    M17 --> Servers
    M18 --> Servers
    M19 --> Servers
    M20 --> Servers
    M21 --> Servers
```

## プラットフォーム抽象化図

```mermaid
graph TB
    subgraph "Abstract Interface"
        OS[OS]
        DS[DisplayServer]
        AD[AudioDriver]
    end

    subgraph "Windows"
        OSW[OS_Windows]
        DSW[DisplayServerWindows]
        ADW[AudioDriverWASAPI]
    end

    subgraph "macOS"
        OSM[OS_MacOS]
        DSM[DisplayServerMacOS]
        ADM[AudioDriverCoreAudio]
    end

    subgraph "Linux"
        OSL[OS_LinuxBSD]
        DSL[DisplayServerX11/Wayland]
        ADL[AudioDriverPulseAudio/ALSA]
    end

    subgraph "Android"
        OSA[OS_Android]
        DSA[DisplayServerAndroid]
        ADA[AudioDriverOpenSL]
    end

    subgraph "iOS"
        OSI[OS_iOS]
        DSI[DisplayServeriOS]
        ADI[AudioDriverCoreAudio]
    end

    subgraph "Web"
        OSWEB[OS_Web]
        DSWEB[DisplayServerWeb]
        ADWEB[AudioDriverWeb]
    end

    OS --> OSW
    OS --> OSM
    OS --> OSL
    OS --> OSA
    OS --> OSI
    OS --> OSWEB

    DS --> DSW
    DS --> DSM
    DS --> DSL
    DS --> DSA
    DS --> DSI
    DS --> DSWEB

    AD --> ADW
    AD --> ADM
    AD --> ADL
    AD --> ADA
    AD --> ADI
    AD --> ADWEB
```

## ビルドシステム構成図

```mermaid
graph TB
    subgraph "Build System"
        SC[SConstruct]
        PD[platform/detect.py]
        MM[methods.py]
    end

    subgraph "Build Targets"
        ED[editor]
        TR[template_release]
        TD[template_debug]
    end

    subgraph "Platform Builds"
        BW[windows]
        BM[macos]
        BL[linuxbsd]
        BA[android]
        BI[ios]
        BV[visionos]
        BWB[web]
    end

    subgraph "Build Options"
        VK[vulkan=yes/no]
        GL[opengl3=yes/no]
        D3[d3d12=yes/no]
        MT[metal=yes/no]
        MN[module_mono_enabled=yes/no]
    end

    SC --> PD
    SC --> MM

    SC --> ED
    SC --> TR
    SC --> TD

    ED --> BW
    ED --> BM
    ED --> BL
    TR --> BW
    TR --> BM
    TR --> BL
    TR --> BA
    TR --> BI
    TR --> BV
    TR --> BWB
    TD --> BW
    TD --> BM
    TD --> BL
    TD --> BA
    TD --> BI
    TD --> BV
    TD --> BWB

    VK --> SC
    GL --> SC
    D3 --> SC
    MT --> SC
    MN --> SC
```
