---
generated_at: 2026-01-23 16:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **GitHub Actions SLA 99.9%**：公式SLAの確認が必要
  2. **アーティファクト保持期間90日**：GitHub設定による変動可能性
  3. **ビルド時間60-120分**：実際のビルドログ未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `SConstruct` - ビルドシステム設定ファイル
- E-02: `.github/workflows/runner.yml` - CI/CDメインワークフロー
- E-03: `.github/workflows/linux_builds.yml` - Linuxビルドワークフロー
- E-04: `.github/workflows/web_builds.yml` - Webビルドワークフロー
- E-05: `.github/workflows/android_builds.yml` - Androidビルドワークフロー
- E-06: `.github/workflows/macos_builds.yml` - macOSビルドワークフロー（参照のみ）
- E-07: `.github/workflows/windows_builds.yml` - Windowsビルドワークフロー（参照のみ）
- E-08: `.github/workflows/ios_builds.yml` - iOSビルドワークフロー（参照のみ）
- E-09: `README.md` - プロジェクト概要
- E-10: `platform/web/package.json` - Web開発依存関係
- E-11: `platform/` ディレクトリ構成 - サポートプラットフォーム一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SCons 4.0以上が必要 | E-01 (line 4: `EnsureSConsVersion(4, 0)`) | ○ |
| C-02 | Python 3.8以上が必要 | E-01 (line 5: `EnsurePythonVersion(3, 8)`) | ○ |
| C-03 | GCC 9以上が必要 | E-01 (line 712-718) | ○ |
| C-04 | Clang 6以上が必要 | E-01 (line 738-742) | ○ |
| C-05 | Apple Clang 16以上が必要 | E-01 (line 731-736) | ○ |
| C-06 | MSVC VS2017以上が必要 | E-01 (line 763-768) | ○ |
| C-07 | Emscripten 4.0.11使用 | E-04 (env.EM_VERSION: 4.0.11) | ○ |
| C-08 | .NET SDK 8.0.100使用 | E-03 (dotnet-version: 8.0.100) | ○ |
| C-09 | Java 17使用 | E-05 (java-version: 17) | ○ |
| C-10 | Ubuntu 22.04でLinuxビルド | E-03 (runs-on: ubuntu-22.04) | ○ |
| C-11 | Ubuntu 24.04でWeb/Androidビルド | E-04, E-05 (runs-on: ubuntu-24.04) | ○ |
| C-12 | fail-fast: false設定 | E-03, E-04, E-05 | ○ |
| C-13 | timeout-minutes: 60-120 | E-03 (120), E-04 (60), E-05 (60) | ○ |
| C-14 | Static Checksが最初に実行 | E-02 (workflow依存関係) | ○ |
| C-15 | AccessKit SDKをダウンロード | E-03 (dsaltares/fetch-gh-release-asset) | ○ |
| C-16 | Linuxビルドで最大6並列 | E-03 (matrix include 6項目) | ○ |
| C-17 | Webビルドで最大2並列 | E-04 (matrix include 2項目) | ○ |
| C-18 | Androidビルドで最大3並列 | E-05 (matrix include 3項目) | ○ |
| C-19 | Monoサポートあり | E-03 (module_mono_enabled=yes) | ○ |
| C-20 | Sanitizer対応あり | E-03 (use_asan, use_ubsan, use_tsan) | ○ |
| C-21 | マルチプラットフォーム対応 | E-11 (platform/: android, ios, linuxbsd, macos, visionos, web, windows) | ○ |
| C-22 | Weblateと連携 | E-09 (Weblate badge) | ○ |
| C-23 | GitHub Actions SLA 99.9% | **根拠なし** | △ |
| C-24 | アーティファクト保持期間90日 | **根拠なし** | △ |
| C-25 | ビルド時間60-120分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GitHub Actions SLA: GitHub公式ドキュメントの参照が必要
  - 候補：GitHub Status / GitHub Docs / SLA契約書
- アーティファクト保持期間: リポジトリ設定またはGitHub組織設定の確認が必要
  - 候補：Repository Settings / Organization Settings / workflow設定
- ビルド時間: 実際のGitHub Actionsログの分析が必要
  - 候補：Actions実行履歴 / ビルドログ / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ビルドシステム要件（SCons、Python、コンパイラバージョン）
- **0: 低リスク** - CI/CDワークフロー構成
- **0: 低リスク** - プラットフォーム対応状況
- **1: 中リスク** - 外部サービスSLA・保持期間に関する記述
- **0: 低リスク** - 依存関係・ミドルウェア構成

## 6) レビュアーチェックリスト（最小）
- [ ] GitHub Actions SLA 99.9%の根拠を確認する（GitHub公式ドキュメント参照）
- [ ] アーティファクト保持期間がリポジトリ設定と一致するか確認する
- [ ] 実際のビルド時間をGitHub Actionsログで検証する
- [ ] Dockerfileが本当に存在しないことを再確認する
- [ ] 記載されていない隠れたインフラ要件がないか確認する
