# インフラ構成図

## 全体構成図

```mermaid
graph TB
    subgraph "開発者環境"
        DEV[開発者]
        LOCAL[ローカルリポジトリ]
    end

    subgraph "GitHub"
        REPO[godotengine/godot<br/>リポジトリ]
        ACTIONS[GitHub Actions]
        ARTIFACTS[GitHub Artifacts]
        CACHE[GitHub Cache]
    end

    subgraph "外部サービス"
        WEBLATE[Weblate<br/>翻訳管理]
        RTD[Read the Docs<br/>ドキュメント]
        ACCESSKIT[AccessKit<br/>アクセシビリティSDK]
    end

    DEV --> LOCAL
    LOCAL -->|push/PR| REPO
    REPO -->|trigger| ACTIONS
    ACTIONS --> ARTIFACTS
    ACTIONS <--> CACHE
    REPO <--> WEBLATE
    REPO -->|webhook| RTD
    ACTIONS -->|download| ACCESSKIT
```

## CI/CDパイプライン構成図

```mermaid
graph LR
    subgraph "トリガー"
        PUSH[Push]
        PR[Pull Request]
        DISPATCH[Manual Dispatch]
    end

    subgraph "第1段階"
        STATIC[Static Checks<br/>コード品質チェック]
    end

    subgraph "第2段階 - ビルドマトリクス"
        LINUX[Linux Builds<br/>ubuntu-22.04]
        MACOS[macOS Builds<br/>macos-latest]
        WINDOWS[Windows Builds<br/>windows-latest]
        ANDROID[Android Builds<br/>ubuntu-24.04]
        IOS[iOS Builds<br/>macos-latest]
        WEB[Web Builds<br/>ubuntu-24.04]
    end

    subgraph "成果物"
        EDITOR[Editor バイナリ]
        TEMPLATE[Template バイナリ]
        TESTS[テスト結果]
    end

    PUSH --> STATIC
    PR --> STATIC
    DISPATCH --> STATIC

    STATIC --> LINUX
    STATIC --> MACOS
    STATIC --> WINDOWS
    STATIC --> ANDROID
    STATIC --> IOS
    STATIC --> WEB

    LINUX --> EDITOR
    LINUX --> TEMPLATE
    LINUX --> TESTS
    MACOS --> EDITOR
    MACOS --> TEMPLATE
    WINDOWS --> EDITOR
    WINDOWS --> TEMPLATE
    ANDROID --> EDITOR
    ANDROID --> TEMPLATE
    IOS --> TEMPLATE
    WEB --> TEMPLATE
```

## ビルドシステム構成図

```mermaid
graph TB
    subgraph "ビルドツールチェーン"
        SCONS[SCons<br/>ビルドシステム]
        PYTHON[Python 3.8+]
    end

    subgraph "コンパイラ"
        GCC[GCC 9+<br/>Linux]
        CLANG[Clang 6+ / Apple Clang 16+<br/>macOS/Linux]
        MSVC[MSVC VS2017+<br/>Windows]
        EMCC[Emscripten 4.0.11<br/>Web]
        NDK[Android NDK<br/>Android]
    end

    subgraph "ソースコード"
        CORE[core/]
        SCENE[scene/]
        SERVERS[servers/]
        EDITOR[editor/]
        DRIVERS[drivers/]
        PLATFORM[platform/]
        MODULES[modules/]
    end

    subgraph "出力"
        BIN_EDITOR[bin/godot.*<br/>Editor]
        BIN_TEMPLATE[bin/godot.*<br/>Template]
    end

    PYTHON --> SCONS
    SCONS --> GCC
    SCONS --> CLANG
    SCONS --> MSVC
    SCONS --> EMCC
    SCONS --> NDK

    CORE --> SCONS
    SCENE --> SCONS
    SERVERS --> SCONS
    EDITOR --> SCONS
    DRIVERS --> SCONS
    PLATFORM --> SCONS
    MODULES --> SCONS

    GCC --> BIN_EDITOR
    GCC --> BIN_TEMPLATE
    CLANG --> BIN_EDITOR
    CLANG --> BIN_TEMPLATE
    MSVC --> BIN_EDITOR
    MSVC --> BIN_TEMPLATE
    EMCC --> BIN_TEMPLATE
    NDK --> BIN_EDITOR
    NDK --> BIN_TEMPLATE
```

## プラットフォーム別ビルド構成図

```mermaid
graph TB
    subgraph "Linux Builds"
        L_EDITOR[Editor w/ Mono]
        L_SANITIZER[Editor w/ Sanitizers]
        L_TEMPLATE[Template Release/Debug]
        L_MINIMAL[Minimal Template]
    end

    subgraph "macOS Builds"
        M_EDITOR[Editor<br/>Universal Binary]
        M_TEMPLATE[Template Release/Debug<br/>Universal Binary]
    end

    subgraph "Windows Builds"
        W_EDITOR[Editor x86_64]
        W_TEMPLATE[Template Release/Debug<br/>x86_64]
    end

    subgraph "Android Builds"
        A_EDITOR[Editor arm64]
        A_TEMPLATE32[Template arm32]
        A_TEMPLATE64[Template arm64]
        A_HORIZONOS[Horizon OS Editor]
        A_PICOOS[PICO OS Editor]
    end

    subgraph "iOS Builds"
        I_TEMPLATE[Template arm64<br/>Simulator対応]
    end

    subgraph "Web Builds"
        WEB_THREADS[Template w/ Threads]
        WEB_NOTHREADS[Template w/o Threads]
    end
```

## キャッシュ・アーティファクト構成図

```mermaid
graph LR
    subgraph "ビルドキャッシュ"
        SCONS_CACHE[SCons Cache<br/>コンパイル結果]
        GHA_CACHE[GitHub Actions Cache<br/>依存関係]
        CCACHE[ccache<br/>コンパイラキャッシュ]
    end

    subgraph "アーティファクト"
        EDITOR_BIN[Editor バイナリ]
        TEMPLATE_BIN[Template バイナリ]
        DEBUG_SYM[デバッグシンボル]
    end

    subgraph "保存先"
        GHA_ARTIFACTS[GitHub Artifacts<br/>90日保持]
        RELEASE[GitHub Releases<br/>永続保存]
    end

    SCONS_CACHE --> GHA_CACHE
    CCACHE --> GHA_CACHE

    EDITOR_BIN --> GHA_ARTIFACTS
    TEMPLATE_BIN --> GHA_ARTIFACTS
    DEBUG_SYM --> GHA_ARTIFACTS

    GHA_ARTIFACTS -->|リリース時| RELEASE
```

## 依存関係構成図

```mermaid
graph TB
    subgraph "ビルド依存関係"
        BROTLI[Brotli<br/>圧縮]
        FREETYPE[FreeType<br/>フォント]
        HARFBUZZ[HarfBuzz<br/>テキストシェーピング]
        MBEDTLS[mbedTLS<br/>暗号化]
        ZLIB[zlib<br/>圧縮]
        PNG[libpng<br/>画像]
        WEBP[libwebp<br/>画像]
        VORBIS[libvorbis<br/>音声]
        VULKAN[Vulkan SDK<br/>グラフィクス]
        OPENGL[OpenGL/GLES3<br/>グラフィクス]
    end

    subgraph "オプション依存関係"
        MONO[.NET/Mono<br/>C#サポート]
        OPENXR[OpenXR<br/>VR/XRサポート]
        SDL[SDL3<br/>入力]
        ACCESSKIT_DEP[AccessKit<br/>アクセシビリティ]
    end

    subgraph "Godot Engine"
        GODOT[godot<br/>バイナリ]
    end

    BROTLI --> GODOT
    FREETYPE --> GODOT
    HARFBUZZ --> GODOT
    MBEDTLS --> GODOT
    ZLIB --> GODOT
    PNG --> GODOT
    WEBP --> GODOT
    VORBIS --> GODOT
    VULKAN --> GODOT
    OPENGL --> GODOT

    MONO -.-> GODOT
    OPENXR -.-> GODOT
    SDL -.-> GODOT
    ACCESSKIT_DEP -.-> GODOT
```
