# インフラ設計書

## 概要

本ドキュメントは、Godot Engine（オープンソース2D/3Dゲームエンジン）のビルド・開発インフラストラクチャ設計について記載する。GodotはデスクトップアプリケーションおよびWebアプリケーションとしてビルドされるクロスプラットフォームゲームエンジンであり、サーバーサイドインフラではなく、CI/CDパイプラインおよびビルド環境を中心としたインフラ構成となる。

## システム構成

### 全体構成

Godot Engineのインフラストラクチャは、以下の要素で構成される：

1. **GitHub Actionsによるci/CDパイプライン**: 自動ビルド・テスト・アーティファクト生成
2. **マルチプラットフォームビルドシステム**: SCons（Python）ベースのビルドシステム
3. **外部サービス連携**: GitHub、Weblate（翻訳）、Read the Docs（ドキュメント）

### サーバー構成（CI/CDランナー）

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| Ubuntu 22.04 Runner | Linuxビルド（Editor、Template） | GitHub Actions標準ランナー | マトリクスビルド（最大6並列） |
| Ubuntu 24.04 Runner | Web/Androidビルド | GitHub Actions標準ランナー | マトリクスビルド（最大3並列） |
| macOS Runner | macOS/iOSビルド | GitHub Actions標準ランナー | マトリクスビルド（最大2並列） |
| Windows Runner | Windowsビルド | GitHub Actions標準ランナー | マトリクスビルド（最大3並列） |

### ネットワーク構成

GitHub Actionsの標準ネットワーク構成を使用：
- **インターネット接続**: ビルド依存関係のダウンロード、アーティファクトのアップロード
- **キャッシュストレージ**: GitHub Actionsキャッシュによるビルド高速化
- **アーティファクトストレージ**: GitHub Actions Artifactsによるビルド成果物の保存

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| SCons | 4.0以上 | ビルドシステム |
| Python | 3.8以上 | ビルドスクリプト実行 |
| GCC | 9以上 | Linux向けC/C++コンパイラ |
| Clang | 6以上 / Apple Clang 16以上 | macOS/Linux向けC/C++コンパイラ |
| MSVC | Visual Studio 2017以上 | Windows向けC/C++コンパイラ |
| Emscripten | 4.0.11 | Web向けコンパイラ |
| .NET SDK | 8.0.100 | Mono/C#サポート |
| Java | 17 | Androidビルド |
| Gradle | 標準 | Androidビルドシステム |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| GitHub | ソースコード管理、CI/CD、Issue管理 | HTTPS/Git |
| GitHub Actions | CI/CDパイプライン | GitHub統合 |
| Weblate | 翻訳管理 | API連携 |
| Read the Docs | ドキュメントホスティング | Webhook |
| AccessKit | アクセシビリティSDK | ビルド時ダウンロード |

## スケーリング設計

### ビルド並列化
- **マトリクスビルド**: 各プラットフォーム、ターゲット、アーキテクチャの組み合わせで並列ビルド
- **ジョブ並列化**: `num_jobs` オプションによりCPUコア数に基づく自動並列化（デフォルト: CPUコア数 - 1）
- **SCU（Single Compilation Unit）ビルド**: `scu_build=yes` によるコンパイル単位の統合

### キャッシング戦略
- **SCons キャッシュ**: `cache_path` によるビルドキャッシュ
- **GitHub Actions キャッシュ**: 依存関係およびビルド中間ファイルのキャッシュ
- **ccache対応**: `cpp_compiler_launcher` によるコンパイルキャッシュ

## 可用性設計

### CI/CDの冗長性
- **GitHub Actions標準SLA**: 99.9%の可用性
- **マトリクスビルドの`fail-fast: false`**: 一部ビルド失敗時も他のビルドを継続
- **ビルドキャッシュの`continue-on-error`**: キャッシュ失敗時もビルドを継続

### ソースコード管理の冗長性
- **Git分散VCS**: 各開発者のローカルリポジトリによる分散バックアップ
- **GitHub Mirror**: 公式リポジトリの信頼性

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| ソースコード | Git分散リポジトリ | プッシュ毎 | 永続 |
| ビルドアーティファクト | GitHub Actions Artifacts | ビルド毎 | 90日（デフォルト） |
| ビルドキャッシュ | GitHub Actions Cache | ビルド毎 | 7日（未使用時） |
| ドキュメント | Read the Docs | プッシュ毎 | バージョン管理 |

## 監視設計

### CI/CD監視
- **GitHub Actions ダッシュボード**: ワークフロー実行状況の可視化
- **ビルドステータスバッジ**: READMEでのビルド状態表示
- **失敗通知**: GitHub Notifications経由

### コード品質監視
- **Static Checks**: pre-commitフック、ESLint、clang-format
- **Sanitizers**: AddressSanitizer、UBSan、ThreadSanitizer、LSan
- **単体テスト**: Godotテストフレームワーク

## ターゲットプラットフォーム

| プラットフォーム | ビルドターゲット | アーキテクチャ |
| --- | --- | --- |
| Linux/BSD | editor, template_release, template_debug | x86_64 |
| macOS | editor, template_release, template_debug | x86_64, arm64 (Universal) |
| Windows | editor, template_release, template_debug | x86_64 |
| Android | editor, template_release, template_debug | arm32, arm64 |
| iOS | template_release, template_debug | arm64 |
| visionOS | template_release, template_debug | arm64 |
| Web | template_release, template_debug | wasm32 (threads/nothreads) |

## 備考

### 特記事項
1. **デスクトップアプリケーション**: Godotはサーバーアプリケーションではなく、デスクトップ/モバイル向けゲームエンジンである
2. **セルフホスト不要**: GitHub Actionsを利用するため、自前のCI/CDサーバーは不要
3. **ビルド時間**: フルビルドは約60-120分、キャッシュ利用時は大幅に短縮
4. **Docker非使用**: 本プロジェクトではDockerfileは定義されていない
5. **Kubernetes非使用**: コンテナオーケストレーションは使用していない

### ローカル開発環境要件
- Python 3.8以上
- SCons 4.0以上
- プラットフォーム固有のコンパイラ・SDK
- 各種オプショナル依存関係（Vulkan SDK、.NET SDK等）
