---
generated_at: 2026-01-23 18:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **セッション管理の設定値**：エンジン固有の実装がないため根拠不足
  2. **監査ログの保持期間**：具体的な仕様がソースコードから確認困難
  3. **TLS 1.3対応の詳細**：mbedTLSのバージョン依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/crypto/crypto.h` - Cryptoクラス定義
- E-02: `core/crypto/crypto.cpp` - Crypto実装
- E-03: `core/crypto/crypto_core.h` - CryptoCore低レベルAPI定義
- E-04: `core/crypto/aes_context.h` - AESContext定義
- E-05: `core/crypto/hashing_context.h` - HashingContext定義
- E-06: `modules/mbedtls/crypto_mbedtls.h` - mbedTLS実装ヘッダ
- E-07: `modules/mbedtls/crypto_mbedtls.cpp` - mbedTLS実装
- E-08: `modules/mbedtls/tls_context_mbedtls.h` - TLSコンテキスト定義
- E-09: `core/io/stream_peer_tls.h` - TLSストリーム定義
- E-10: `core/io/packet_peer_dtls.h` - DTLS定義
- E-11: `core/io/dtls_server.h` - DTLSサーバー定義
- E-12: `core/io/file_access.h` - FileAccess定義
- E-13: `core/io/file_access_encrypted.h` - 暗号化ファイルアクセス定義
- E-14: `core/io/file_access_encrypted.cpp` - 暗号化ファイルアクセス実装
- E-15: `core/io/file_access_pack.h` - PCKファイルアクセス定義
- E-16: `core/io/http_client.h` - HTTPクライアント定義
- E-17: `core/SCsub` - スクリプト暗号化鍵ビルド設定
- E-18: `editor/export/editor_export_platform.h` - エクスポート暗号化設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RSA鍵生成機能の提供 | E-01, E-07 | ○ |
| C-02 | デジタル署名/検証機能 | E-01, E-07 | ○ |
| C-03 | X.509証明書サポート | E-01, E-06, E-07 | ○ |
| C-04 | HMACサポート | E-01, E-06, E-07 | ○ |
| C-05 | ファイルアクセスの権限体系（4種類） | E-12 | ○ |
| C-06 | パスプレフィックス制御（res://,user://） | E-12 | ○ |
| C-07 | Unixパーミッションフラグ | E-12 | ○ |
| C-08 | TLS 1.2/1.3サポート（mbedTLS） | E-06, E-08 | ○ |
| C-09 | DTLSサポート | E-10, E-11 | ○ |
| C-10 | 証明書チェーン検証 | E-07, E-08 | ○ |
| C-11 | TLSOptions 3モード（CLIENT/CLIENT_UNSAFE/SERVER） | E-01, E-02 | ○ |
| C-12 | AES-256-CFBによるファイル暗号化 | E-13, E-14 | ○ |
| C-13 | AESContext 4モード（ECB/CBC暗号化・復号） | E-04 | ○ |
| C-14 | ハッシュアルゴリズム3種（MD5/SHA1/SHA256） | E-03, E-05 | ○ |
| C-15 | 鍵のゼロ化処理 | E-07 | ○ |
| C-16 | タイミング攻撃対策（constant_time_compare） | E-01, E-02 | ○ |
| C-17 | 暗号化ファイルのIV生成 | E-14 | ○ |
| C-18 | MD5による整合性検証 | E-14 | ○ |
| C-19 | 暗号化ファイルヘッダーマジック（0x43454447） | E-13 | ○ |
| C-20 | RandomGenerator（CTR_DRBG） | E-03, E-07 | ○ |
| C-21 | PCKファイル暗号化フラグ | E-15 | ○ |
| C-22 | スクリプト暗号化鍵の環境変数設定 | E-17 | ○ |
| C-23 | 32バイト（256ビット）鍵長検証 | E-14 | ○ |
| C-24 | 16バイトIV検証 | E-14 | ○ |
| C-25 | HTTPレスポンスコード定義 | E-16 | ○ |
| C-26 | TLS接続オプション設定 | E-01, E-08 | ○ |
| C-27 | システムCA証明書の読み込み | E-07 | ○ |
| C-28 | ビルトインCA証明書サポート | E-07 | ○ |
| C-29 | パストラバーサル対策（simplify_path） | E-15 | ○ |
| C-30 | ERR_FAIL_COND_Vマクロによる入力検証 | E-14 | ○ |
| C-31 | 暗号化鍵使用後のメモリクリア | E-07 | ○ |
| C-32 | X.509証明書の生成機能 | E-07 | ○ |
| C-33 | セッション管理機能 | **根拠なし** | △ |
| C-34 | 監査ログ保持期間の仕様 | **根拠なし** | △ |
| C-35 | TLS 1.3の詳細サポート状況 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **セッション管理**: Godot Engineはゲームエンジンであり、Webアプリケーション的なセッション管理機能を内蔵していない。この点は「アプリケーション依存」として記載したが、ソースコードでの裏付けが困難
  - 候補：platform固有のセッション実装 / HTTPクライアントの接続管理 / 外部認証サービス連携
- **監査ログ保持期間**: ログはランタイム中のみ保持される想定だが、明示的な仕様定義がソースコードに存在しない
  - 候補：Logger実装の詳細調査 / プロジェクト設定のログオプション / プラットフォーム固有のログ設定
- **TLS 1.3サポート**: mbedTLSのバージョンとビルド設定に依存するため、実際のサポート状況は確認が必要
  - 候補：thirdparty/mbedtls/のバージョン確認 / ビルド設定の調査 / TLS設定のデフォルト値確認

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**: MD5のファイル整合性検証への使用 - 暗号学的には脆弱だが、ファイル破損検出目的であれば許容範囲
- **リスク1（低）**: スクリプト暗号化鍵のバイナリ埋め込み - ドキュメントに注意事項として明記済み
- **リスク0（低）**: MODE_CLIENT_UNSAFEの存在 - 開発・テスト用途として許容、本番使用は非推奨と明記

## 6) レビュアーチェックリスト（最小）
- [ ] E-01〜E-18のソースコードパスが実際に存在することを確認
- [ ] TLS 1.3サポートの実際の状況をmbedTLSバージョンで確認
- [ ] PCKファイル暗号化のセキュリティ強度が要件を満たすか検討
- [ ] MD5の継続使用に関するリスク評価
- [ ] スクリプト暗号化の難読化レベルが許容範囲か確認
- [ ] プラットフォーム固有のセキュリティ機能（iOS/Android）との連携を確認
