---
generated_at: 2026-01-23 11:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **カバレッジ目標**：明示的な設定ファイルが見つからず、推測に基づく
  2. **不具合管理プロセス**：GitHub Issues の運用方針は外部ドキュメントに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `tests/test_main.cpp` - テストエントリポイント、doctest 統合
- E-02: `tests/test_macros.h` - テストマクロ定義、doctest インクルード
- E-03: `tests/SCsub` - テストビルド設定
- E-04: `.github/workflows/linux_builds.yml` - Linux CI ビルド設定
- E-05: `.github/workflows/runner.yml` - CI パイプライン全体構成
- E-06: `.github/workflows/static_checks.yml` - 静的解析 CI 設定
- E-07: `.pre-commit-config.yaml` - pre-commit フック設定
- E-08: `tests/core/math/test_vector2.h` - 単体テスト実装例
- E-09: `modules/gdscript/tests/README.md` - GDScript テストドキュメント
- E-10: `tests/display_server_mock.h` - モックサーバー実装
- E-11: `thirdparty/doctest/doctest.h` - doctest フレームワーク（参照）
- E-12: `misc/error_suppressions/asan.txt` - ASAN 抑制リスト（パス参照）
- E-13: `tests/create_test.py` - テスト作成スクリプト
- E-14: `modules/gdscript/tests/scripts/` - GDScript テストスクリプト群

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | doctest フレームワークを使用 | E-01, E-02, E-11 | ○ |
| C-02 | SCons をビルドシステムとして使用 | E-03, E-04 | ○ |
| C-03 | GitHub Actions で CI/CD を構築 | E-04, E-05, E-06 | ○ |
| C-04 | pre-commit による静的解析 | E-06, E-07 | ○ |
| C-05 | clang-format v21.1.7 を使用 | E-07 | ○ |
| C-06 | clang-tidy v21.1.6 を使用 | E-07 | ○ |
| C-07 | ruff v0.14.7 を使用 | E-07 | ○ |
| C-08 | codespell v2.4.1 を使用 | E-07 | ○ |
| C-09 | ASAN/UBSAN/TSAN サニタイザーを使用 | E-04, E-12 | ○ |
| C-10 | Ubuntu 22.04 で Linux ビルド | E-04 | ○ |
| C-11 | Python 3.8 以上が必要 | E-04 (legacy-scons: python-version: 3.8) | ○ |
| C-12 | SCons 4.0 以上が必要 | E-04 (scons-version: 4.0) | ○ |
| C-13 | 単体テストは tests/core/ に配置 | E-08 | ○ |
| C-14 | シーンテストは tests/scene/ に配置 | E-01 (include一覧) | ○ |
| C-15 | GDScript テストは modules/gdscript/tests/ に配置 | E-09, E-14 | ○ |
| C-16 | DisplayServerMock でモックサーバーを提供 | E-01, E-10 | ○ |
| C-17 | テスト実行コマンドは --headless --test | E-04 (line 224) | ○ |
| C-18 | 2段階 CI パイプライン構成 | E-05 | ○ |
| C-19 | 静的チェック後にビルドが実行される | E-05 (needs: static-checks) | ○ |
| C-20 | .NET ソースジェネレーターテストを実行 | E-04 (line 226-229) | ○ |
| C-21 | GDExtension API 互換性チェックを実行 | E-04 (line 241-244) | ○ |
| C-22 | プロジェクト変換テストを実行 | E-04 (line 253-258) | ○ |
| C-23 | --doctool でドキュメント更新チェック | E-04 (line 231-238) | ○ |
| C-24 | TEST_CASE_PENDING マクロを提供 | E-02 (line 45) | ○ |
| C-25 | SIGNAL_WATCH/CHECK マクロを提供 | E-02 (line 401-406) | ○ |
| C-26 | tests/create_test.py でスケルトン生成 | E-13 | ○ |
| C-27 | 明示的なカバレッジ目標は設定されていない | **根拠なし** | △ |
| C-28 | GitHub Issues で不具合管理 | **根拠なし（外部プロセス）** | △ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標設定ファイル**: コードベース内にカバレッジ設定（.coveragerc, codecov.yml 等）が見つからなかったため、「明示的な目標なし」と記載。プロジェクトの方針文書があれば確認が必要。
  - 候補：CONTRIBUTING.md / 公式ドキュメント / GitHub Wiki
- **不具合管理プロセス**: GitHub Issues の使用は一般的な OSS プラクティスだが、Godot 固有のトリアージプロセスは外部ドキュメント参照。
  - 候補：CONTRIBUTING.md / godotengine.org ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: テストフレームワーク・ツール情報 - ソースコードから直接確認可能
- **0 (低リスク)**: CI/CD 構成 - GitHub Actions ワークフローファイルから直接確認可能
- **1 (中リスク)**: カバレッジ目標 - 明示的な設定がないことの確認が必要
- **0 (低リスク)**: テストディレクトリ構成 - 実際のファイル配置から確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] doctest バージョンは thirdparty/doctest/doctest.h のヘッダーコメントで確認できるか
- [ ] カバレッジ目標がプロジェクト方針として別途定められていないか（CONTRIBUTING.md 等）
- [ ] 記載されている pre-commit フックのバージョンは最新か（定期的に更新される可能性あり）
- [ ] GDScript テストの実行方法（README.md 参照）が現在も有効か
- [ ] サニタイザー抑制リスト（misc/error_suppressions/）が実際に存在するか
- [ ] mold リンカーのバージョン要件が CI 環境で満たされているか
