# テスト方針書

## 概要

本ドキュメントは、Godot Engine プロジェクトにおけるテスト方針を定義します。Godot Engine は、オープンソースのクロスプラットフォームゲームエンジンであり、C++ をベースとした大規模プロジェクトです。本プロジェクトでは、doctest フレームワークを使用した単体テスト、GDScript 統合テスト、CI/CD パイプラインによる自動テストを実施しています。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | コアモジュール、数学関数、データ構造、シーンコンポーネントなどの個別機能の検証 | 開発者 |
| 結合テスト | GDScript パーサー/コンパイラとランタイムの統合、モジュール間連携の検証 | 開発者 |
| システムテスト | エディタ機能、プロジェクト変換、エクスポートテンプレートの動作検証 | 開発者/CI |
| 受入テスト | GDExtension API 互換性、ドキュメント整合性の確認 | CI/コントリビューター |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | コア機能（数学演算、IO 操作、シーン管理等）の動作検証 | コミット時/PR 時 |
| 性能テスト | サニタイザー（ASAN, UBSAN, TSAN）によるメモリ/スレッド安全性検証 | CI ビルド時 |
| セキュリティテスト | コードスペルチェック、静的解析、clang-tidy による脆弱性検出 | PR 時（pre-commit） |
| 回帰テスト | GDScript スクリプト実行テスト、プロジェクト変換テスト | CI ビルド後 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| Linux (Ubuntu 22.04) | メインビルド/テスト環境 | GCC/Clang, SCons, Python 3.8+ |
| Windows | クロスプラットフォームテスト | MSVC, SCons |
| macOS | クロスプラットフォームテスト | Xcode, SCons |
| Web | Emscripten ビルドテスト | Emscripten, SCons |
| Android/iOS | モバイルビルドテスト | Android SDK/Xcode |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| doctest | C++ 単体テストフレームワーク | サードパーティ同梱版 |
| SCons | ビルドシステム（テストビルド含む） | 4.0 以上 |
| GitHub Actions | CI/CD パイプライン | - |
| pre-commit | 静的解析・フォーマットチェック | v6.0.0 (hooks) |
| clang-format | コードフォーマット | v21.1.7 |
| clang-tidy | 静的解析 | v21.1.6 |
| ruff | Python コード品質チェック | v0.14.7 |
| codespell | スペルチェック | v2.4.1 |
| ASAN/UBSAN/TSAN | メモリ/未定義動作/スレッドサニタイザー | LLVM/GCC 同梱 |
| mold | 高速リンカー（サニタイザービルド用） | CI 環境依存 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 明示的な数値目標なし（品質重視） |
| 分岐カバレッジ | 明示的な数値目標なし（品質重視） |

※ Godot プロジェクトでは明示的なカバレッジ目標は設定されていませんが、コアモジュール（core/）、シーン（scene/）、サーバー（servers/）に対する包括的な単体テストが実装されています。

## テストデータ

テストデータは以下の方法で準備されています：

1. **静的テストデータ**: `tests/data/` ディレクトリに配置されたバイナリファイル・設定ファイル
2. **GDScript テストスクリプト**: `modules/gdscript/tests/scripts/` に配置された `.gd` ファイルと期待出力 `.out` ファイル
3. **オートコンプリートテスト**: `modules/gdscript/tests/scripts/completion/` に配置された `.cfg` 設定ファイル
4. **一時ファイル**: `TestUtils::get_temp_path()` で生成される一時ディレクトリ（テスト終了時に自動削除）
5. **モックオブジェクト**: `DisplayServerMock` などのモッククラスによるサーバー機能のシミュレーション

## 不具合管理

不具合の管理は以下の方法で行われています：

1. **GitHub Issues**: バグ報告、機能要望の一元管理
2. **Pull Request レビュー**: コード変更時の品質ゲート
3. **CI ステータスチェック**: すべてのテストが通過しないとマージ不可
4. **サニタイザー抑制リスト**: `misc/error_suppressions/` に既知の誤検知を登録
   - `asan.txt`: AddressSanitizer 抑制リスト
   - `lsan.txt`: LeakSanitizer 抑制リスト
   - `tsan.txt`: ThreadSanitizer 抑制リスト
   - `ubsan.txt`: UndefinedBehaviorSanitizer 抑制リスト

## CI/CD連携

### パイプライン構成

CI/CD は GitHub Actions で構築されており、以下の 2 段階で実行されます：

**第 1 段階: 静的チェック**
- pre-commit による静的解析
- コードフォーマット（clang-format, ruff-format）
- スペルチェック（codespell）
- ドキュメント検証（make-rst, doc-status）
- ヘッダーガード・著作権ヘッダーチェック

**第 2 段階: ビルド & テスト（静的チェック通過後）**
- マルチプラットフォームビルド（Linux, Windows, macOS, Web, Android, iOS）
- 単体テスト実行（`--headless --test --force-colors`）
- GDScript 統合テスト
- .NET ソースジェネレーターテスト（Mono ビルド時）
- GDExtension API 互換性チェック
- プロジェクト変換テスト
- ドキュメント更新チェック（`--doctool`）

### ビルドマトリクス

| ビルド名 | 設定 | 特記事項 |
| --- | --- | --- |
| Editor w/ Mono | `module_mono_enabled=yes` | godot-cpp 互換性検証含む |
| Editor with doubles and GCC sanitizers | `dev_build=yes, precision=double, use_asan=yes, use_ubsan=yes` | プロジェクトテスト実行 |
| Editor with clang sanitizers | `use_asan=yes, use_ubsan=yes, use_llvm=yes` | レガシー SCons バージョンテスト |
| Editor with ThreadSanitizer | `use_tsan=yes, use_llvm=yes` | スレッド安全性検証 |
| Template w/ Mono (release/debug) | `module_mono_enabled=yes` | リリース用テンプレート |
| Minimal template | `modules_enabled_by_default=no, disable_3d=yes, ...` | 最小構成テスト |

### テスト実行コマンド

```bash
# 単体テスト実行
./bin/godot.linuxbsd.editor.x86_64 --headless --test --force-colors

# 特定のテストケースを実行
./bin/godot.linuxbsd.editor.x86_64 --headless --test -tc="[Vector2]*"

# スキップされたテストを含めて実行
./bin/godot.linuxbsd.editor.x86_64 --headless --test --no-skip
```

## 備考

### テストコードの構成

テストコードは以下のディレクトリ構造で管理されています：

```
tests/
├── core/           # コアモジュールのテスト
│   ├── config/     # 設定関連
│   ├── input/      # 入力イベント関連
│   ├── io/         # IO 操作関連
│   ├── math/       # 数学関数関連
│   ├── object/     # オブジェクトシステム関連
│   ├── os/         # OS 機能関連
│   ├── string/     # 文字列処理関連
│   ├── templates/  # テンプレートコンテナ関連
│   ├── threads/    # スレッド関連
│   └── variant/    # Variant 型関連
├── scene/          # シーンシステムのテスト
├── servers/        # サーバー（レンダリング、ナビゲーション等）のテスト
├── data/           # テストデータファイル
├── python_build/   # Python ビルドスクリプトのテスト
├── test_main.cpp   # テストエントリポイント
├── test_macros.h   # テストユーティリティマクロ
└── test_utils.*    # テストヘルパー関数
```

### テストマクロ

doctest をベースとしたカスタムマクロが提供されています：

- `TEST_CASE_PENDING`: スキップされるテストケース
- `TEST_CASE_MAY_FAIL`: 失敗しても全体を失敗させないテストケース
- `ERR_PRINT_OFF/ON`: エラー出力の一時的な抑制
- `SIGNAL_WATCH/CHECK`: シグナルの監視・検証
- `SEND_GUI_*`: GUI イベントのシミュレーション

### GDScript テストの種類

1. **ランタイムテスト**: スクリプト実行結果と期待出力の比較
2. **パーサーテスト**: 構文解析の正常系・異常系テスト
3. **コンパイラーテスト**: バイトコード生成の検証
4. **オートコンプリートテスト**: エディタ補完機能の検証

### 継続的改善

- 新機能追加時は対応するテストの追加が推奨される
- `tests/create_test.py` スクリプトでテストファイルのスケルトン生成が可能
- ドキュメント変更は `--doctool` による自動検証が必須
