# ER図（Entity-Relationship Diagram）

## 概要

本ドキュメントは、Godotプロジェクトにおける `DownloadsDB` データベースのER図を記載します。

## ER図

```mermaid
erDiagram
    MetadataColumns {
        INTEGER _id PK "主キー（自動生成）"
        INTEGER APKVERSION "APKバージョンコード"
        INTEGER DOWNLOADSTATUS "全体のダウンロードステータス"
        INTEGER DOWNLOADFLAGS "ダウンロード制御フラグ"
    }

    DownloadColumns {
        INTEGER _id PK "主キー（自動生成）"
        INTEGER FILEIDX UK "ファイルインデックス（一意）"
        TEXT URI "ダウンロード元URI"
        TEXT FN UK "ファイル名（一意）"
        TEXT ETAG "HTTP ETag値"
        INTEGER TOTALBYTES "総バイト数"
        INTEGER CURRENTBYTES "ダウンロード済みバイト数"
        INTEGER LASTMOD "最終更新日時"
        INTEGER STATUS "ダウンロードステータス"
        INTEGER CONTROL "ダウンロード制御フラグ"
        INTEGER FAILCOUNT "失敗回数"
        INTEGER RETRYAFTER "リトライ待機時間"
        INTEGER REDIRECTCOUNT "リダイレクト回数"
    }

    MetadataColumns ||--o{ DownloadColumns : "manages"
```

## テーブル関係の説明

### MetadataColumns と DownloadColumns の関係

`MetadataColumns` テーブルと `DownloadColumns` テーブルは、論理的な親子関係を持っています。

- **MetadataColumns**: アプリケーション全体のダウンロード状態を管理する単一レコードを保持
- **DownloadColumns**: 個々のダウンロードファイルの詳細情報を管理する複数レコードを保持

この関係は外部キー制約では定義されていませんが、アプリケーションロジック上で1つのメタデータレコードが複数のダウンロードファイルを管理する構造となっています。

## エンティティ詳細

### MetadataColumns エンティティ

| 属性 | 説明 |
| --- | --- |
| _id | レコードの一意識別子 |
| APKVERSION | 現在のAPKバージョン。バージョンアップ時のダウンロード要否判定に使用 |
| DOWNLOADSTATUS | 全体のダウンロード状態（完了・進行中・エラーなど） |
| DOWNLOADFLAGS | アプリケーション設定フラグ |

### DownloadColumns エンティティ

| 属性 | 説明 |
| --- | --- |
| _id | レコードの一意識別子 |
| FILEIDX | ファイルの順序を示すインデックス |
| URI | ダウンロード元のURL |
| FN | ローカルに保存するファイル名 |
| ETAG | サーバーから取得したETag値（キャッシュ検証用） |
| TOTALBYTES | ファイルの総サイズ |
| CURRENTBYTES | ダウンロード完了済みサイズ |
| LASTMOD | ファイルの最終更新日時 |
| STATUS | 個別ファイルのダウンロード状態 |
| CONTROL | ダウンロード制御（一時停止・再開など） |
| FAILCOUNT | ダウンロード失敗回数 |
| RETRYAFTER | 次回リトライまでの待機時間 |
| REDIRECTCOUNT | HTTPリダイレクトの回数 |

## 凡例

| 記号 | 意味 |
| --- | --- |
| PK | Primary Key（主キー） |
| UK | Unique Key（一意キー） |
| `\|\|--o{` | 1対多のリレーション |
