---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `platform/android/java/lib/src/main/java/com/google/android/vending/expansion/downloader/impl/DownloadsDB.java` - DownloadsDBクラス本体
- E-02: `DownloadsDB.java` 30-31行目 - DATABASE_NAME, DATABASE_VERSION定数
- E-03: `DownloadsDB.java` 242-295行目 - DownloadColumnsクラス定義
- E-04: `DownloadsDB.java` 220-240行目 - MetadataColumnsクラス定義
- E-05: `DownloadsDB.java` 49-57行目 - getDownloadByIndexStatementメソッド
- E-06: `DownloadsDB.java` 59-67行目 - getUpdateCurrentBytesStatementメソッド
- E-07: `DownloadsDB.java` 91-108行目 - getDownloadInfoByFileNameメソッド
- E-08: `DownloadsDB.java` 366-380行目 - isDownloadRequiredメソッド
- E-09: `DownloadsDB.java` 74-88行目 - コンストラクタ内のメタデータクエリ
- E-10: `DownloadsDB.java` 169-175行目 - sSchemas, sTables配列定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | データベース名は `DownloadsDB` である | E-02 | ○ |
| C-02 | データベースバージョンは `7` である | E-02 | ○ |
| C-03 | DownloadColumnsテーブルが存在する | E-03, E-10 | ○ |
| C-04 | MetadataColumnsテーブルが存在する | E-04, E-10 | ○ |
| C-05 | DownloadColumnsに _id, FILEIDX, URI, FN, ETAG, TOTALBYTES, CURRENTBYTES, LASTMOD, STATUS, CONTROL, FAILCOUNT, RETRYAFTER, REDIRECTCOUNTカラムが存在する | E-03 | ○ |
| C-06 | MetadataColumnsに _id, APKVERSION, DOWNLOADSTATUS, DOWNLOADFLAGSカラムが存在する | E-04 | ○ |
| C-07 | FILEIDXカラムにUNIQUE制約がある | E-03 (263行目: `INDEX, "INTEGER UNIQUE"`) | ○ |
| C-08 | FNカラムにUNIQUE制約がある | E-03 (268行目: `FILENAME, "TEXT UNIQUE"`) | ○ |
| C-09 | ファイルインデックスによるレコード取得クエリが存在する | E-05 | ○ |
| C-10 | ダウンロードバイト数の更新クエリが存在する | E-06 | ○ |
| C-11 | ファイル名によるダウンロード情報取得クエリが存在する | E-07 | ○ |
| C-12 | ダウンロード要否の判定クエリが存在する | E-08 | ○ |
| C-13 | メタデータの取得クエリが存在する | E-09 | ○ |
| C-14 | バージョンアップ時に全テーブルを削除して再作成する | E-01 (210-217行目: onUpgradeメソッド) | ○ |
| C-15 | シングルトンパターンで実装されている | E-01 (36行目: mDownloadsDB static変数, 42-47行目: getDBメソッド) | ○ |
| C-16 | PreparedStatement(SQLiteStatement)を使用している | E-01 (34-35行目: mGetDownloadByIndex, mUpdateCurrentBytes) | ○ |
| C-17 | Apache License 2.0でライセンスされている | E-01 (1-15行目: ライセンスヘッダ) | ○ |
| C-18 | Android Open Source Projectが元プロジェクトである | E-01 (3行目: Copyright notice) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 本データベースはソースコード内で完全に定義されており、外部のスキーマ定義ファイルやマイグレーションファイルは存在しない

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能
- 備考: データベース設計書の内容は全て `DownloadsDB.java` ファイルから抽出しており、推測や外部情報に依存していない

## 6) レビュアーチェックリスト（最小）
- [ ] DownloadColumnsテーブルのカラム定義がソースコードと一致することを確認
- [ ] MetadataColumnsテーブルのカラム定義がソースコードと一致することを確認
- [ ] 記載されたSQLクエリがソースコード内の実装と一致することを確認
- [ ] データ型の記載（INTEGER, TEXT）がソースコードのスキーマ定義と一致することを確認
