# データベース設計書

## 概要

本ドキュメントは、Godotゲームエンジンプロジェクトにおけるデータベース設計を記載します。本プロジェクトでは、Android向けAPK拡張ファイルのダウンロード管理機能において、SQLiteデータベースを使用しています。データベース名は `DownloadsDB`、バージョンは `7` です。

このデータベースは、Google Play APK Expansion Files（OBBファイル）のダウンロード状態を永続的に管理するために使用されます。

## テーブル一覧

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| DownloadColumns | ダウンロードファイル情報 | ダウンロード対象ファイルの進捗・状態・メタデータを管理 |
| MetadataColumns | アプリケーションメタデータ | APKバージョン、全体のダウンロード状態、フラグを管理 |

## 各テーブル定義

### 1. DownloadColumns

ダウンロード対象の各ファイルに関する情報を格納するテーブルです。ダウンロードの進捗状況、リトライ情報、リダイレクト回数などを管理します。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| _id | INTEGER PRIMARY KEY | NO | レコードの一意識別子（自動生成） |
| FILEIDX | INTEGER UNIQUE | NO | ファイルのインデックス番号（一意制約） |
| URI | TEXT | YES | ダウンロード元のURI |
| FN | TEXT UNIQUE | NO | ファイル名（一意制約） |
| ETAG | TEXT | YES | HTTP ETagヘッダ値（キャッシュ検証用） |
| TOTALBYTES | INTEGER | YES | ファイルの総バイト数 |
| CURRENTBYTES | INTEGER | YES | 現在のダウンロード済みバイト数 |
| LASTMOD | INTEGER | YES | 最終更新日時（Unix timestamp） |
| STATUS | INTEGER | YES | ダウンロードステータス |
| CONTROL | INTEGER | YES | ダウンロード制御フラグ |
| FAILCOUNT | INTEGER | YES | 失敗回数 |
| RETRYAFTER | INTEGER | YES | リトライ待機時間（秒） |
| REDIRECTCOUNT | INTEGER | YES | リダイレクト回数 |

**制約:**
- `_id`: PRIMARY KEY（自動インクリメント）
- `FILEIDX`: UNIQUE制約
- `FN`: UNIQUE制約

**主な用途:**
- 大容量ファイル（OBBファイル）のダウンロード進捗管理
- ダウンロード中断・再開のための状態保存
- 失敗時のリトライ制御

### 2. MetadataColumns

アプリケーション全体のダウンロード状態を管理するメタデータテーブルです。通常、1レコードのみが存在します。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| _id | INTEGER PRIMARY KEY | NO | レコードの一意識別子（自動生成） |
| APKVERSION | INTEGER | YES | APKのバージョンコード |
| DOWNLOADSTATUS | INTEGER | YES | 全体のダウンロードステータス |
| DOWNLOADFLAGS | INTEGER | YES | ダウンロード制御フラグ |

**制約:**
- `_id`: PRIMARY KEY（自動インクリメント）

**主な用途:**
- APKバージョンアップ時のダウンロード要否判定
- 全体のダウンロード進捗状態の管理
- アプリケーション設定フラグの永続化

## インデックス設計

本データベースでは、以下の暗黙的なインデックスが存在します：

| テーブル名 | インデックス対象カラム | 種類 | 説明 |
| --- | --- | --- | --- |
| DownloadColumns | _id | PRIMARY KEY | 主キーインデックス |
| DownloadColumns | FILEIDX | UNIQUE | ファイルインデックス検索用 |
| DownloadColumns | FN | UNIQUE | ファイル名検索用 |
| MetadataColumns | _id | PRIMARY KEY | 主キーインデックス |

## データベース操作

### 主要なクエリパターン

1. **ファイルインデックスによるレコード取得**
   ```sql
   SELECT _id FROM DownloadColumns WHERE FILEIDX = ?
   ```

2. **ダウンロードバイト数の更新**
   ```sql
   UPDATE DownloadColumns SET CURRENTBYTES = ? WHERE FILEIDX = ?
   ```

3. **ファイル名によるダウンロード情報取得**
   ```sql
   SELECT * FROM DownloadColumns WHERE FN = ?
   ```

4. **ダウンロード要否の判定**
   ```sql
   SELECT Count(*) FROM DownloadColumns WHERE STATUS <> 0
   ```

5. **メタデータの取得**
   ```sql
   SELECT APKVERSION, _id, DOWNLOADSTATUS, DOWNLOADFLAGS FROM MetadataColumns LIMIT 1
   ```

## 備考

### 技術的な考慮事項

1. **データベースバージョン管理**: データベースバージョンは `7` であり、バージョンアップ時には全テーブルを削除して再作成する方式を採用しています（`onUpgrade` メソッド）。

2. **シングルトンパターン**: `DownloadsDB` クラスはシングルトンパターンで実装されており、アプリケーション全体で単一のインスタンスを共有します。

3. **PreparedStatement**: パフォーマンス最適化のため、頻繁に使用するクエリは `SQLiteStatement` としてコンパイル済みの形式で保持しています。

4. **Android固有**: このデータベースはAndroidプラットフォーム専用であり、Google Play APK Expansion Library（expansion-downloader）の一部として機能します。

### ソースコード参照

- 実装ファイル: `platform/android/java/lib/src/main/java/com/google/android/vending/expansion/downloader/impl/DownloadsDB.java`
- ライセンス: Apache License 2.0
- 元プロジェクト: Android Open Source Project
