---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 21
  claims_with_evidence: 21
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：21 / 21、根拠なし：0
- 優先レビュー（高）
  - 該当なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `misc/scripts/install_vulkan_sdk_macos.sh`
- E-02: `misc/scripts/install_swappy_android.py`
- E-03: `misc/scripts/install_d3d12_sdk_windows.py`
- E-04: `misc/scripts/gitignore_check.sh`
- E-05: `misc/scripts/copyright_headers.py`
- E-06: `misc/scripts/header_guards.py`
- E-07: `misc/scripts/file_format.py`
- E-08: `misc/scripts/validate_xml.py`
- E-09: `misc/scripts/validate_extension_api.sh`
- E-10: `misc/scripts/check_ci_log.py`
- E-11: `misc/scripts/dotnet_format.py`
- E-12: `misc/scripts/make_icons.sh`
- E-13: `misc/scripts/make_tarball.sh`
- E-14: `doc/tools/make_rst.py`
- E-15: `doc/tools/doc_status.py`
- E-16: `thirdparty/thorvg/update-thorvg.sh`
- E-17: `thirdparty/sdl/update-sdl.sh`
- E-18: `modules/raycast/godot_update_embree.py`
- E-19: `misc/scripts/purge_cache.py`
- E-20: `tests/create_test.py`
- E-21: `platform/android/java/gradlew.bat`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | install_vulkan_sdk_macos.shはmacOS向けVulkan SDKをインストールする | E-01 | ○ |
| C-02 | install_swappy_android.pyはAndroid向けSwappyライブラリをインストールする | E-02 | ○ |
| C-03 | install_d3d12_sdk_windows.pyはDirect3D 12 SDK依存関係をインストールする | E-03 | ○ |
| C-04 | gitignore_check.shは.gitignore違反ファイルを検出する | E-04 | ○ |
| C-05 | copyright_headers.pyは著作権ヘッダーを追加・更新する | E-05 | ○ |
| C-06 | header_guards.pyはヘッダーガードを#pragma onceに変換する | E-06 | ○ |
| C-07 | file_format.pyはファイルフォーマットを正規化する | E-07 | ○ |
| C-08 | validate_xml.pyはXMLをスキーマ検証する | E-08 | ○ |
| C-09 | validate_extension_api.shはGDExtension APIの互換性を検証する | E-09 | ○ |
| C-10 | check_ci_log.pyはCIログからエラーを検出する | E-10 | ○ |
| C-11 | dotnet_format.pyはC#コードをフォーマットする | E-11 | ○ |
| C-12 | make_icons.shは各プラットフォーム向けアイコンを生成する | E-12 | ○ |
| C-13 | make_tarball.shはリリース用tarballを作成する | E-13 | ○ |
| C-14 | make_rst.pyはXMLからRSTドキュメントを生成する | E-14 | ○ |
| C-15 | doc_status.pyはドキュメント作成状況をレポートする | E-15 | ○ |
| C-16 | update-thorvg.shはThorVGライブラリを更新する | E-16 | ○ |
| C-17 | update-sdl.shはSDL3ライブラリを更新する | E-17 | ○ |
| C-18 | godot_update_embree.pyはEmbreeライブラリを更新する | E-18 | ○ |
| C-19 | purge_cache.pyは古いキャッシュファイルを削除する | E-19 | ○ |
| C-20 | create_test.pyは単体テストファイルのひな形を生成する | E-20 | ○ |
| C-21 | gradlew.batはAndroidビルドのGradleラッパーである | E-21 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - すべてのバッチ処理スクリプトは実際のソースコードファイルを根拠として確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 各バッチスクリプトのカテゴリ分類が適切か確認
- [ ] 説明文がスクリプトの実際の機能と一致しているか確認
- [ ] 備考欄の情報が正確か確認
- [ ] 漏れているバッチスクリプトがないか確認（特にCI/CDワークフロー関連）
