# バッチ設計書 1-install_vulkan_sdk_macos.sh

## 概要

本ドキュメントは、macOS向けVulkan SDKの自動ダウンロード・インストールを行うシェルスクリプトの設計書です。

### 本バッチの処理概要

このバッチは、macOS環境においてGodotエンジンのビルドに必要なVulkan SDKを自動的にインストールするためのスクリプトです。

**業務上の目的・背景**：Godotエンジンは、Vulkanを使用したレンダリングをサポートしています。macOSでGodotをビルドするためには、LunarG社が提供するVulkan SDKのインストールが必要です。このバッチは、開発者が手動でSDKをダウンロード・インストールする手間を省き、常に最新バージョンのSDKを使用できるようにすることで、開発環境のセットアップを効率化します。

**バッチの実行タイミング**：開発環境のセットアップ時、またはVulkan SDKの更新が必要な場合に手動で実行されます。CI/CD環境でのビルド前にも実行される可能性があります。

**主要な処理内容**：
1. jqコマンドの存在確認（JSONパース用）
2. LunarG SDKサーバーから最新バージョン情報のJSON取得
3. ローカルにインストール済みのVulkan SDKバージョン確認
4. バージョン比較による新規インストール要否判定
5. 最新版Vulkan SDKのダウンロード（ZIP形式）
6. ZIPファイルの展開とインストーラ実行
7. 一時ファイルのクリーンアップ

**前後の処理との関連**：本バッチは単独で実行可能ですが、実行後はGodotのビルド（scons）を行うことが想定されています。前提として、Homebrewまたはmacportsによるjqコマンドのインストールが必要です。

**影響範囲**：`$HOME/VulkanSDK/`ディレクトリにVulkan SDKがインストールされます。システム環境変数に影響を与える可能性があります。

## バッチ種別

環境構築 / SDK自動インストール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 / CI |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| macOS環境 | 本スクリプトはmacOS専用 |
| jqコマンド | JSON解析のためjqがインストールされていること |
| インターネット接続 | LunarG SDKサーバーへのアクセスが可能であること |
| curlコマンド | ダウンロード処理に使用 |
| unzipコマンド | ZIP展開に使用 |

### 実行可否判定

1. jqコマンドの存在確認を行う
2. jqが存在しない場合はエラー終了（exit 1）
3. 既にインストール済みのバージョンが最新以上の場合はスキップ（exit 0）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| https://sdk.lunarg.com/sdk/download/latest/mac/config.json | JSON | 最新SDKバージョン情報 |
| https://sdk.lunarg.com/sdk/download/latest/mac/vulkan-sdk.zip | ZIP | Vulkan SDKアーカイブ |
| $HOME/VulkanSDK/* | ディレクトリ | インストール済みSDKの確認 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $HOME/VulkanSDK/{version}/ | ディレクトリ | インストールされたVulkan SDK |
| 標準出力 | テキスト | 進捗・結果メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | SDKバージョンに依存 |
| 出力先 | $HOME/VulkanSDK/ |
| 文字コード | N/A（バイナリ/ライブラリ） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. jqコマンド存在確認
   └─ 存在しない場合はエラー終了
2. 最新バージョン情報取得
   └─ config.jsonをダウンロードしてバージョン抽出
3. インストール済みバージョン確認
   └─ $HOME/VulkanSDK/配下のディレクトリをチェック
4. バージョン比較
   └─ 最新以上がインストール済みならスキップ
5. SDKダウンロード
   └─ vulkan-sdk.zipをダウンロード
6. ZIP展開
   └─ /tmpに展開
7. インストーラ実行
   └─ 自動応答オプションでインストール
8. クリーンアップ
   └─ 一時ファイル削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{jqコマンド存在?}
    B -->|No| C[エラー終了 exit 1]
    B -->|Yes| D[最新バージョン情報取得]
    D --> E[インストール済みバージョン確認]
    E --> F{最新版インストール済み?}
    F -->|Yes| G[スキップ exit 0]
    F -->|No| H[SDKダウンロード]
    H --> I[ZIP展開]
    I --> J{展開成功?}
    J -->|No| K[エラー終了 exit 1]
    J -->|Yes| L[インストーラ実行]
    L --> M[クリーンアップ]
    M --> N[成功終了 exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 依存関係エラー | jqコマンドが存在しない | brew install jq または port install jq を実行 |
| 1 | 展開エラー | ZIP展開後のディレクトリが見つからない | 手動でSDKをインストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. jqが見つからない場合：`brew install jq`または`port install jq`を実行
2. ダウンロード失敗：ネットワーク接続を確認し、再実行
3. インストール失敗：https://vulkan.lunarg.com/ から手動でインストール

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のSDKインストール |
| 目標処理時間 | ネットワーク速度に依存（数分程度） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は想定されていません。複数回実行した場合、既にインストール済みの場合はスキップされます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | jq未検出時 | jqコマンドのインストール方法を案内 |
| 情報ログ | スキップ時 | "Latest or newer Vulkan SDK is already installed. Skipping installation." |
| エラーログ | 展開失敗時 | "Couldn't install the Vulkan SDK, the unzipped contents may no longer match what this script expects." |
| 情報ログ | 成功時 | "Vulkan SDK installed successfully! You can now build Godot by running \"scons\"." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDシステム |

## 備考

- LunarG SDKサーバーのURL形式が変更された場合、スクリプトの修正が必要
- バージョン番号の比較ロジックは`major.minor.patch.revision`の4セグメント形式を想定
- インストーラは`--accept-licenses --default-answer --confirm-command`オプションで自動応答モードで実行される
