# バッチ設計書 10-check_ci_log.py

## 概要

本ドキュメントは、CIログからエラー（AddressSanitizer、メモリリーク等）を検出するPythonスクリプトの設計書です。

### 本バッチの処理概要

このバッチは、CI/CD環境で生成されたログファイルを解析し、AddressSanitizer、クラッシュ、メモリリーク、アサーション失敗などの重大なエラーを検出するスクリプトです。

**業務上の目的・背景**：GodotエンジンのCIパイプラインでは、AddressSanitizer（ASan）やLeakSanitizer（LSan）を有効にしたビルドでテストが実行されます。これらのツールはメモリ関連のバグを検出しますが、ログ出力は大量になることがあります。このバッチは、ログから重要なエラーパターンを自動的に抽出し、エラー種別に応じた終了コードを返すことで、CI/CDパイプラインでの問題の自動検出と分類を可能にします。

**バッチの実行タイミング**：CIパイプラインのテスト実行後、ログファイルの検証ステップとして自動実行されます。

**主要な処理内容**：
1. 引数で指定されたログファイルを読み込み
2. AddressSanitizerエラーの検出（exit 51）
3. プログラムクラッシュの検出（exit 52）
4. LeakSanitizerエラーの検出（スタックトレース深度による判定、exit 53）
5. ObjectDBインスタンスリークの検出（exit 54）
6. アサーション失敗の検出（exit 55）
7. レンダリングリソースリークの警告表示

**前後の処理との関連**：テスト実行バッチの後に実行されます。終了コードに基づいてCIパイプラインの成否が判定されます。

**影響範囲**：読み取り専用の検証処理のため、ファイルは変更されません。終了コードでエラー種別を報告します。

## バッチ種別

品質検証 / ログ解析

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | CI実行時 |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | CI |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python 3環境 | Python 3.xがインストールされていること |
| ログファイル | 解析対象のログファイルが存在すること |

### 実行可否判定

引数として1つのログファイルパスが指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| log-file | string | Yes | なし | 解析対象のログファイルパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ログファイル | テキスト | CI実行時の標準出力/エラーログ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 検出されたエラーの概要 |
| 終了コード | 整数 | エラー種別を示すコード |

### 終了コード一覧

| コード | 意味 |
|--------|------|
| 0 | 正常（重大なエラーなし） |
| 50 | 引数エラー |
| 51 | AddressSanitizerエラー検出 |
| 52 | プログラムクラッシュ検出 |
| 53 | メモリリーク検出（LeakSanitizer） |
| 54 | ObjectDBインスタンスリーク検出 |
| 55 | アサーション失敗検出 |

### 出力ファイル仕様

本バッチはファイル出力を行いません（読み取り専用）。

## 処理フロー

### 処理シーケンス

```
1. 引数検証
   └─ ログファイルパスが指定されているか（exit 50）
2. ログファイル読み込み
   └─ UTF-8で全内容を読み込み
3. AddressSanitizerエラー検出
   └─ "ERROR: AddressSanitizer:" → exit 51
4. クラッシュ検出
   └─ "Program crashed with signal"
   └─ "Dumping the backtrace"
   └─ "Segmentation fault (core dumped)"
   └─ "Aborted (core dumped)"
   └─ "terminate called without an active exception"
   └─ いずれか検出 → exit 52
5. LeakSanitizerエラー検出
   └─ "ERROR: LeakSanitizer:" かつ "#4 0x" → exit 53
6. ObjectDBリーク検出
   └─ "ObjectDB instances leaked at exit" → exit 54
7. アサーション失敗検出
   └─ "Assertion failed" → exit 55
8. レンダリングリーク警告
   └─ "were leaked" または "were never freed" → 警告表示
9. 正常終了
   └─ exit 0
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数あり?}
    B -->|No| C[exit 50]
    B -->|Yes| D[ログファイル読み込み]
    D --> E{AddressSanitizer?}
    E -->|Yes| F[exit 51]
    E -->|No| G{クラッシュ?}
    G -->|Yes| H[exit 52]
    G -->|No| I{LeakSanitizer + 深いスタック?}
    I -->|Yes| J[exit 53]
    I -->|No| K{ObjectDBリーク?}
    K -->|Yes| L[exit 54]
    K -->|No| M{アサーション失敗?}
    M -->|Yes| N[exit 55]
    M -->|No| O{レンダリングリーク?}
    O -->|Yes| P[警告表示]
    O -->|No| Q[exit 0]
    P --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 50 | 引数エラー | ログファイルパスが指定されていない | ファイルパスを引数として指定 |
| 51 | ASanエラー | 不正なメモリアクセス | コードのメモリ操作を修正 |
| 52 | クラッシュ | プログラム異常終了 | クラッシュ原因を調査・修正 |
| 53 | メモリリーク | LSanがリークを検出 | メモリ解放処理を追加 |
| 54 | ObjectDBリーク | Godotオブジェクトの解放漏れ | オブジェクト解放処理を修正 |
| 55 | アサーション失敗 | 想定外の状態 | 該当アサーションの原因を調査 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライ不要） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. exit 51（ASan）：AddressSanitizerの詳細出力を確認し、不正なメモリアクセスを修正
2. exit 52（クラッシュ）：バックトレースを確認し、クラッシュ原因を特定
3. exit 53（LSan）：リークしているメモリの割り当て箇所を特定
4. exit 54（ObjectDB）：解放されていないGodotオブジェクトを特定
5. exit 55（アサーション）：アサーション条件と失敗原因を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル |
| 目標処理時間 | ファイルサイズに依存（数秒以内） |
| メモリ使用量上限 | ログファイルサイズ程度 |

## 排他制御

読み取り専用のため、並行実行可能です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 引数不足時 | "ERROR: You must run program with file name as argument." |
| エラーログ | ASan検出時 | "FATAL ERROR: An incorrectly used memory was found." |
| エラーログ | クラッシュ検出時 | "FATAL ERROR: Godot has been crashed." |
| エラーログ | LSan検出時 | "ERROR: Memory leak was found" |
| エラーログ | ObjectDBリーク検出時 | "ERROR: Memory leak was found" |
| エラーログ | アサーション失敗時 | "ERROR: Assertion failed in project, check execution log for more info" |
| 警告ログ | レンダリングリーク時 | "WARNING: Memory leak was found" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 50以上 | CIシステム |

## 備考

- LeakSanitizerのスタックトレース判定に`#4 0x`を使用（深度4以上で内部リークと判定）
- 外部ライブラリのリークは通常2-3行のスタックトレースのため除外される
- レンダリングリソースリーク（"were leaked"、"were never freed"）は現状WARNINGのみ
- エラーコードは優先度順に評価（ASan > クラッシュ > LSan > ObjectDB > アサーション）
- ログファイルはUTF-8エンコーディングを想定
- 全内容をメモリに読み込むため、巨大なログファイルには注意
