# バッチ設計書 11-dotnet_format.py

## 概要

本ドキュメントは、Godotエンジンプロジェクトにおけるdotnet_format.pyバッチ処理の設計仕様を定義する。このバッチは、C#ソースファイルに対してdotnet formatコマンドを実行し、コーディング規約に準拠したフォーマットを適用するためのラッパースクリプトである。

### 本バッチの処理概要

このバッチは、C#ファイルのコードフォーマットを自動的に実行し、プロジェクト全体で統一されたコーディングスタイルを維持するためのユーティリティスクリプトである。

**業務上の目的・背景**：Godotエンジンには.NET/C#によるスクリプティング機能が含まれており、複数の開発者が参加するオープンソースプロジェクトにおいて、コードスタイルの統一は可読性とメンテナンス性の観点から極めて重要である。手動でのフォーマット確認は非効率であり、自動化されたフォーマットツールによってコードレビューの負担を軽減し、一貫したコード品質を確保する必要がある。

**バッチの実行タイミング**：CI/CDパイプラインでのプルリクエスト検証時、またはコミット前のプリコミットフックとして随時実行される。開発者がローカル環境で手動実行することも可能。

**主要な処理内容**：
1. ダミーの生成ファイル（SdkPackageVersions.props）の作成（存在しない場合）
2. GeneratedIncludes.propsのインポート回避のための環境変数設定
3. 指定されたC#ファイルを対応する.csprojプロジェクトにマッピング
4. 各プロジェクトに対してdotnet formatコマンドを実行

**前後の処理との関連**：このバッチは単独で実行可能だが、通常はgit pre-commitフックやCI/CDワークフローの一部として実行される。file_format.pyやheader_guards.pyなどの他のフォーマット関連バッチと併せて使用されることが多い。

**影響範囲**：モジュール/monoディレクトリ配下のC#プロジェクトファイルおよびソースファイルに影響を与える。

## バッチ種別

コードフォーマット / 品質検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 / プリコミットフック / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| .NET SDK | dotnet formatコマンドが利用可能であること |
| Python 3 | Python 3.x環境がインストールされていること |
| C#ファイル指定 | 1つ以上のC#ファイルパスが引数として指定されること |
| プロジェクトファイル | 対象ファイルに対応する.csprojファイルが存在すること |

### 実行可否判定

コマンドライン引数が1つ以上指定されていない場合は、エラーメッセージを出力して終了コード1で終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ファイルパス | 文字列（可変長） | Yes | - | フォーマット対象のC#ファイルパス（1つ以上） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| **/*.csproj | ファイル | プロジェクト内のすべてのC#プロジェクトファイル |
| 指定C#ファイル | ファイル | コマンドライン引数で指定されたC#ソースファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | dotnet formatの実行結果 |
| 対象C#ファイル | ソースコード | フォーマット適用後のC#ファイル（インプレース更新） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | modules/mono/SdkPackageVersions.props（ダミーファイル、未存在時のみ作成） |
| 出力先 | プロジェクトルート相対パス |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. 引数チェック
   └─ sys.argvの長さが2未満の場合、エラーメッセージ出力後に終了
2. ダミーファイル生成
   └─ modules/mono/SdkPackageVersions.propsが存在しない場合に空のProjectタグを持つXMLを作成
3. 環境変数設定
   └─ GodotSkipGenerated=trueを設定してGeneratedIncludes.propsのインポートを回避
4. プロジェクトマッピング
   └─ glob.globで全.csprojファイルを検索し、入力ファイルとの共通パスでマッチング
5. dotnet format実行
   └─ マッチしたファイルを持つ各プロジェクトに対してdotnet formatを実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|引数なし| C[エラー出力・終了]
    B -->|引数あり| D[ダミーファイル確認・作成]
    D --> E[環境変数GodotSkipGenerated設定]
    E --> F[.csprojファイル一覧取得]
    F --> G[入力ファイルをプロジェクトにマッピング]
    G --> H{フォーマット対象あり?}
    H -->|なし| I[処理スキップ]
    H -->|あり| J[dotnet format実行]
    J --> K[バッチ終了]
    I --> K
    C --> L[終了コード1]
```

## データベース操作仕様

### 操作別データベース影響一覧

このバッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | ファイルパスが指定されていない | 正しい引数を指定して再実行 |
| - | dotnet formatエラー | フォーマット実行時のエラー | dotnet SDKのインストール確認、対象ファイルの構文エラー確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

バッチ失敗時は、エラーメッセージを確認し、以下を確認する：
1. .NET SDKが正しくインストールされているか
2. 指定したファイルパスが正しいか
3. 対象の.csprojファイルが存在するか

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1〜数十ファイル |
| 目標処理時間 | 1プロジェクトあたり数秒〜数十秒 |
| メモリ使用量上限 | dotnet formatプロセスに依存 |

## 排他制御

同一ファイルに対する同時実行は推奨されない。ファイルシステムレベルでの排他制御はdotnet formatコマンドに委任される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 引数不正時 | "Invalid usage of dotnet_format.py..." |
| 進捗ログ | dotnet format実行時 | dotnet formatコマンドの標準出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDシステム |

## 備考

- このスクリプトはGodotエンジンのリポジトリルートから実行されることを想定している
- modules/mono/SdkPackageVersions.propsはビルド時に自動生成されるファイルだが、フォーマット実行時には存在しない可能性があるためダミーを作成する
- GodotSkipGenerated環境変数により、存在しない生成ファイルのインポートエラーを回避する
