# バッチ設計書 12-make_icons.sh

## 概要

本ドキュメントは、Godotエンジンプロジェクトにおけるmake_icons.shバッチ処理の設計仕様を定義する。このバッチは、icon.svg（ベクター形式のGodotアイコン）から各プラットフォーム向けのアイコンファイルを生成する自動化スクリプトである。

### 本バッチの処理概要

このバッチは、GodotエンジンのSVGアイコンから、Windows（.ico）、macOS（.icns）、Linux（.zip）、およびSteam用のアイコンファイルを一括生成するためのシェルスクリプトである。

**業務上の目的・背景**：ゲームエンジンのリリースにおいて、各プラットフォーム固有のアイコン形式が必要となる。SVGマスターファイルから一貫性のあるアイコンセットを自動生成することで、手動変換作業のミスを防ぎ、ブランドアイデンティティの一貫性を保証する。新バージョンリリース時やアイコンデザイン変更時に、効率的にすべてのプラットフォーム用アイコンを更新できる。

**バッチの実行タイミング**：リリースビルド時、またはアイコンデザイン変更後に手動で実行される。通常、新しいメジャー/マイナーバージョンのリリース準備時に実行される。

**主要な処理内容**：
1. icon.svgから複数サイズ（16px〜1024px）のPNG画像を生成
2. 16pxアイコンをTGA形式（Steam用ライブラリアイコン）に変換
3. すべてのPNGをZIPアーカイブ（Linux用）に圧縮
4. 選択したサイズのPNGからICOファイル（Windows用）を生成
5. 選択したサイズのPNGからICNSファイル（macOS用）を生成
6. 中間生成物（PNG画像）を削除してクリーンアップ

**前後の処理との関連**：make_tarball.shによるリリースアーカイブ作成の前に実行され、生成されたアイコンファイルがリリースパッケージに含まれる。

**影響範囲**：misc/scriptsディレクトリにアイコンファイルが生成される。最終的にはリリースパッケージおよび各プラットフォーム用インストーラーで使用される。

## バッチ種別

ビルド・アイコン生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース時） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ImageMagick | convertコマンドが利用可能であること |
| icoutils | icotoolコマンドが利用可能であること（ICO生成用） |
| libicns | png2icnsコマンドが利用可能であること（ICNS生成用） |
| icon.svg | プロジェクトルートにicon.svgが存在すること |
| zip | zipコマンドが利用可能であること |

### 実行可否判定

スクリプトはmisc/scriptsディレクトリから実行されることを前提とし、../../icon.svgの存在が暗黙的に要求される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | コマンドライン引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ../../icon.svg | SVG | Godotエンジンのマスターアイコンファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| icon16.tga | TGA | Steam用ライブラリアイコン（16px） |
| godot-icons.zip | ZIP | Linux用アイコンセット（全サイズPNG） |
| godot-icon.ico | ICO | Windows用アイコン（16-256px） |
| godot-icon.icns | ICNS | macOS用アイコン（16-1024px選択サイズ） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | godot-icon.ico, godot-icon.icns, godot-icons.zip, icon16.tga |
| 出力先 | スクリプト実行ディレクトリ（misc/scripts） |
| 文字コード | バイナリ |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. PNG画像生成（マルチサイズ）
   └─ 16, 24, 32, 48, 64, 128, 256, 512, 1024pxの9サイズを生成
   └─ 透明背景、アンチエイリアス適用
2. TGAファイル生成
   └─ 16pxアイコンをTGA形式に変換（Steam用）
3. ZIPアーカイブ作成
   └─ すべてのPNGをgodot-icons.zipに圧縮（Linux用）
4. ICOファイル生成
   └─ 16-256pxのPNGからgodot-icon.icoを生成（Windows用）
   └─ 512px以上は除外（ファイルサイズ制約）
5. ICNSファイル生成
   └─ macOS要件に準拠したサイズでgodot-icon.icnsを生成
6. クリーンアップ
   └─ 中間生成物のPNGファイルを削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[icon.svgから全サイズPNG生成]
    B --> C[16px PNGをTGAに変換]
    C --> D[全PNGをZIPに圧縮]
    D --> E[選択サイズでICO生成]
    E --> F[選択サイズでICNS生成]
    F --> G[中間PNGファイル削除]
    G --> H[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

このバッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | コマンド未検出 | ImageMagick/icoutils/libicnsがインストールされていない | 必要なパッケージをインストール |
| - | ファイル未検出 | icon.svgが存在しない | icon.svgの配置を確認 |
| - | 変換エラー | SVGの形式が不正 | icon.svgの内容を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

バッチ失敗時は、以下を確認する：
1. 必要なツール（convert, icotool, png2icns, zip）のインストール状態
2. icon.svgファイルの存在と整合性
3. ディスク空き容量

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 9サイズのPNG + 4形式の出力ファイル |
| 目標処理時間 | 数秒〜1分程度 |
| メモリ使用量上限 | ImageMagick処理に依存（通常数百MB以下） |

## 排他制御

同時実行は推奨されない。中間ファイル（icon*.png）が競合する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 各コマンド実行時 | 各ツールの標準出力 |
| エラーログ | エラー発生時 | 各ツールの標準エラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 手動確認 |
| 出力ファイル存在確認 | 4ファイル | 手動確認 |

## 備考

- ICOファイルには512px以上のサイズを含めない（ファイルサイズが肥大化するため）
- ICNSファイルは macOS Icon Handbook の推奨サイズに従う（https://iconhandbook.co.uk/reference/chart/osx/）
- 中間生成物のPNGは最終的に削除されるが、デバッグ時はこの行をコメントアウトして確認可能
- スクリプトはbashシェルで実行される必要がある
