# バッチ設計書 13-make_tarball.sh

## 概要

本ドキュメントは、Godotエンジンプロジェクトにおけるmake_tarball.shバッチ処理の設計仕様を定義する。このバッチは、Gitリポジトリからリリース用のtarballアーカイブを作成する自動化スクリプトである。

### 本バッチの処理概要

このバッチは、Godotエンジンのソースコードからリリース配布用のtar.gzアーカイブを生成するためのシェルスクリプトである。Gitのgit archiveコマンドを使用し、指定したバージョンまたはコミットのソースコードをパッケージ化する。

**業務上の目的・背景**：オープンソースプロジェクトのリリースにおいて、ソースコード配布は重要な要素である。Gitリポジトリから再現可能な方法でソースアーカイブを作成することで、リリースの一貫性と透明性を確保する。また、.git/HEADファイルを含めることで、ビルド時にGODOT_VERSION_HASHを正確に生成できるようにする。

**バッチの実行タイミング**：新しいバージョン（安定版、RC、ベータ等）のリリース準備時に手動で実行される。通常、リリースマネージャーがリリースプロセスの一環として実行する。

**主要な処理内容**：
1. リポジトリルートでの実行確認（version.pyの存在チェック）
2. コマンドライン引数の解析（バージョン名、Gitリファレンス、ファイル名形式）
3. 対象のGitコミットハッシュを解決
4. git archiveでソースアーカイブを作成
5. カスタム.git/HEADファイルをアーカイブに追加
6. gzipで圧縮して最終的なtar.gzを生成
7. 一時ファイルのクリーンアップ

**前後の処理との関連**：make_icons.shで生成されたアイコンファイルがリポジトリに含まれた状態で実行されることが多い。生成されたtarballは、公式リリースページやミラーサーバーにアップロードされる。

**影響範囲**：リポジトリの親ディレクトリにtar.gzファイルが生成される。既存のファイルがあれば上書きされる。

## バッチ種別

ビルド・アーカイブ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース時） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Gitリポジトリ | Godotリポジトリのルートディレクトリで実行すること |
| version.py | リポジトリルートにversion.pyが存在すること |
| Gitコマンド | gitコマンドが利用可能であること |
| gzip | gzipコマンドが利用可能であること |
| tar | tarコマンドが利用可能であること |

### 実行可否判定

version.pyが存在しない場合は、エラーメッセージを出力して終了コード1で終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -s | フラグ | No | false | スクリプトフレンドリーなファイル名（godot.tar.gz）を使用 |
| -v | 文字列 | No | - | ファイル名に使用するGodotバージョン（例: 4.0-stable） |
| -g | 文字列 | No | HEAD | アーカイブ対象のGit treeish（例: master, v4.0-stable） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Gitリポジトリ | Git | 対象コミットのソースコード |
| version.py | Python | バージョン確認用（存在チェックのみ） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ../{NAME}.tar.gz | tar.gz | リリース用ソースアーカイブ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | godot.tar.gz / godot-{version}.tar.gz / godot-{commit-hash}.tar.gz |
| 出力先 | リポジトリの親ディレクトリ |
| 文字コード | バイナリ（tar.gz） |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. 実行ディレクトリ確認
   └─ version.pyの存在をチェック、不在ならエラー終了
2. 引数解析
   └─ getopts で -s, -v, -g オプションを解析
3. コミットハッシュ解決
   └─ git rev-parse で対象コミットのフルハッシュを取得
4. 出力ファイル名決定
   └─ -sフラグ、-vオプション、コミットハッシュに基づいて決定
5. 一時ディレクトリ作成
   └─ mktempで一時作業ディレクトリを作成
6. git archive実行
   └─ 対象コミットからtarアーカイブを作成（プレフィックス付き）
7. .git/HEAD追加
   └─ コミットハッシュを含む.git/HEADファイルをアーカイブに追加
8. gzip圧縮
   └─ 最終的なtar.gzファイルを親ディレクトリに出力
9. クリーンアップ
   └─ 一時ディレクトリを削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{version.py存在?}
    B -->|No| C[エラー出力・終了]
    B -->|Yes| D[引数解析]
    D --> E[コミットハッシュ解決]
    E --> F[出力ファイル名決定]
    F --> G[一時ディレクトリ作成]
    G --> H[git archiveでtar作成]
    H --> I[.git/HEADをtarに追加]
    I --> J[gzip圧縮で最終出力]
    J --> K[一時ディレクトリ削除]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

このバッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ディレクトリエラー | version.pyが存在しない | リポジトリルートに移動して再実行 |
| - | Gitエラー | 指定したtreeishが存在しない | 正しいブランチ名/タグ名/コミットハッシュを指定 |
| - | ディスクエラー | ディスク容量不足 | ディスク空き容量を確保 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

バッチ失敗時は、以下を確認する：
1. 現在のディレクトリがGodotリポジトリのルートか
2. 指定したGitリファレンスが有効か
3. 親ディレクトリへの書き込み権限があるか
4. 一時ディレクトリ（/tmp等）に十分な空き容量があるか

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1アーカイブ |
| 目標処理時間 | 数十秒〜数分（リポジトリサイズ依存） |
| メモリ使用量上限 | git/tar/gzip処理に依存 |

## 排他制御

同じ出力ファイル名での同時実行は推奨されない。一時ディレクトリは一意な名前で作成されるため、基本的には競合しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | アーカイブ開始時 | "Generating tarball for revision {HEAD} with folder name '{NAME}'." |
| 情報ログ | アーカイブ開始時 | 出力先パス情報 |
| エラーログ | エラー発生時 | "This script should be ran from the root folder of the Godot repository." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 手動確認 |
| 出力ファイル存在確認 | 1ファイル | 手動確認 |

## 備考

- 生成されるtarballには `.git/HEAD` ファイルが含まれ、これによりビルド時に `GODOT_VERSION_HASH` が正確に設定される
- `-s` オプションは主にCI/CDスクリプトで使用され、バージョン非依存の固定ファイル名を生成する
- tarballはリポジトリの親ディレクトリに出力されるため、リポジトリ自体を汚さない設計になっている
- アーカイブ内のファイルはすべて `{NAME}/` プレフィックス付きのパスで格納される
