# バッチ設計書 14-make_rst.py

## 概要

本ドキュメントは、Godotエンジンプロジェクトにおけるmake_rst.pyバッチ処理の設計仕様を定義する。このバッチは、XMLクラスリファレンスファイルからreStructuredText（RST）形式のドキュメントを生成し、オンラインドキュメントサイト用のクラスリファレンスを自動生成する。

### 本バッチの処理概要

このバッチは、GodotエンジンのXML形式クラスリファレンスファイルを解析し、Sphinxベースのオンラインドキュメント用にRST形式のドキュメントファイルを生成するPythonスクリプトである。

**業務上の目的・背景**：Godotエンジンの公式ドキュメントサイト（docs.godotengine.org）では、クラスリファレンスをRST形式で管理している。エンジン内部で使用されるXML形式のクラスドキュメントから自動的にRST形式に変換することで、ドキュメントの一貫性を保ち、手動変換によるエラーを防止する。また、多言語対応のための翻訳文字列抽出もサポートしている。

**バッチの実行タイミング**：ドキュメント更新時、新しいクラスやAPI追加時、リリース前のドキュメント生成時に実行される。godot-docsリポジトリのビルドプロセスの一部として自動実行されることもある。

**主要な処理内容**：
1. XMLクラスリファレンスファイルの解析とバリデーション
2. クラス定義（プロパティ、メソッド、シグナル、定数等）の抽出
3. RST形式への変換（マークアップ、相互参照リンク生成）
4. クラスグループ別インデックスファイルの生成
5. 翻訳文字列の適用（--langオプション使用時）
6. エラーと警告のレポート出力

**前後の処理との関連**：doc_status.pyでドキュメントのカバレッジを確認した後に実行されることが多い。生成されたRSTファイルはSphinxでHTMLにビルドされる。

**影響範囲**：指定された出力ディレクトリにRSTファイルが生成される。既存ファイルは上書きされる。

## バッチ種別

ドキュメント生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ドキュメント更新時） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python 3 | Python 3.x環境がインストールされていること |
| XMLファイル | doc/classes配下にXMLクラスリファレンスが存在すること |
| polib（オプション） | --langオプション使用時はpolibモジュールが必要 |
| version.py | バージョン情報取得のためプロジェクトルートに存在すること |

### 実行可否判定

pathが1つ以上指定されていない場合は、ヘルプを表示して終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| path | 文字列（可変長） | Yes | - | XMLファイルまたはディレクトリのパス |
| --filter | 文字列 | No | "" | フィルタリング用のファイルパスパターン |
| --lang, -l | 文字列 | No | "en" | セクション見出し等の言語 |
| --color | フラグ | No | false | TTY以外でもカラー出力を強制 |
| --output, -o | 文字列 | No | "." | RSTファイル出力ディレクトリ |
| --dry-run | フラグ | No | false | 出力せずエラーチェックのみ実行 |
| --verbose | フラグ | No | false | 詳細な出力を有効化 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| doc/classes/*.xml | XML | クラスリファレンスXMLファイル |
| modules/*/doc_classes/*.xml | XML | モジュール別クラスリファレンス |
| platform/*/doc_classes/*.xml | XML | プラットフォーム別クラスリファレンス |
| doc/translations/{lang}.po | PO | 翻訳文字列ファイル（オプション） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| {output}/class_{classname}.rst | RST | 各クラスのリファレンスドキュメント |
| {output}/index.rst | RST | クラスグループ別インデックス |
| 標準出力 | テキスト | 処理状況、エラー・警告メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | class_{クラス名（小文字）}.rst |
| 出力先 | --outputで指定したディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ argparseでコマンドライン引数を解析
2. 翻訳ファイル読み込み（オプション）
   └─ --langで指定された言語のPOファイルを読み込み
3. XMLファイル収集
   └─ 指定パスからXMLファイルを再帰的に収集
4. XMLパース・バリデーション
   └─ 各XMLファイルを解析しClassDefオブジェクトを生成
   └─ 重複クラス、不正な形式をエラーとして報告
5. クラス情報ソート
   └─ クラス名でアルファベット順にソート
6. クラスグループ分類
   └─ Node/Resource/Object/Variant等のグループに分類
7. RSTファイル生成
   └─ 各クラスのRSTファイルを生成
   └─ マークアップ変換、相互参照リンク生成
8. インデックスファイル生成
   └─ グループ別インデックスを生成
9. パリティチェック結果出力
   └─ GDScript/C#コードサンプルの整合性チェック結果を報告
10. 結果サマリー出力
    └─ エラー・警告件数を出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{言語指定?}
    C -->|Yes| D[翻訳POファイル読み込み]
    C -->|No| E[XMLファイル収集]
    D --> E
    E --> F[XMLパース・バリデーション]
    F --> G[クラス情報ソート]
    G --> H[クラスグループ分類]
    H --> I{dry-run?}
    I -->|Yes| J[エラー・警告のみ出力]
    I -->|No| K[RSTファイル生成]
    K --> L[インデックス生成]
    L --> M[パリティチェック結果出力]
    M --> N[結果サマリー出力]
    J --> N
    N --> O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

このバッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | パスが指定されていない | 必須引数を指定 |
| 1 | XMLパースエラー | XMLファイルの形式が不正 | XMLファイルを修正 |
| 1 | 重複クラスエラー | 同名クラスが複数存在 | 重複を解消 |
| 255 | タグ不一致エラー | XMLタグが期待と異なる | XMLスキーマに従って修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

バッチ失敗時は、エラーメッセージを確認し、以下を確認する：
1. XMLファイルがdoc/class.xsdスキーマに準拠しているか
2. 重複したクラス定義がないか
3. 必要なパラメータが正しく指定されているか

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百〜数千のXMLファイル |
| 目標処理時間 | 数十秒〜数分 |
| メモリ使用量上限 | XMLパース・RSTテンプレート処理に依存 |

## 排他制御

同一出力ディレクトリへの同時実行は推奨されない。ファイル上書きが発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | "Checking for errors in the XML class reference..." |
| 進捗ログ | RST生成時 | "Generating the RST class reference..." |
| インデックスログ | インデックス生成時 | "Generating the index file..." |
| エラーログ | エラー発生時 | "ERROR: {エラー内容}" |
| 警告ログ | 警告発生時 | "WARNING: {警告内容}" |
| 完了ログ | 正常終了時 | "No warnings or errors found..." / "Wrote reStructuredText files..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDシステム |
| エラー件数 | 1件以上 | CI/CDシステム |
| 警告件数 | 任意（情報として出力） | CI/CDシステム |

## 備考

- このスクリプトは1000行以上の大規模なPythonスクリプトで、多数のクラスとヘルパー関数を含む
- クラスグループはNode/Resource/Object/Variant/Global/Editorに分類される
- CLASSES_WITH_CSHARP_DIFFERENCESリストに含まれるクラスは、C#での差異について注記が追加される
- ScriptLanguageParityCheckにより、GDScriptとC#のコードサンプルの整合性がチェックされる
- BASE_STRINGSリストに含まれる文字列は翻訳対象となる
- --dry-runオプションはCI/CDでのバリデーション用途に有用
