# バッチ設計書 15-doc_status.py

## 概要

本ドキュメントは、Godotエンジンプロジェクトにおけるdoc_status.pyバッチ処理の設計仕様を定義する。このバッチは、XMLクラスリファレンスのドキュメント作成状況を分析し、カバレッジレポートを生成するPythonスクリプトである。

### 本バッチの処理概要

このバッチは、GodotエンジンのXMLクラスリファレンスファイルを解析し、各クラスのドキュメント記述率をテーブル形式で表示するユーティリティスクリプトである。未記述の項目を特定し、ドキュメント改善の優先順位付けを支援する。

**業務上の目的・背景**：オープンソースプロジェクトにおいて、APIドキュメントの網羅性は開発者体験に直結する重要な品質指標である。Godotエンジンには数百のクラスが存在し、それぞれのプロパティ、メソッド、シグナル等に説明文が必要となる。このスクリプトにより、ドキュメント作成状況を可視化し、貢献者が優先的に取り組むべき未記述箇所を特定できる。

**バッチの実行タイミング**：ドキュメント貢献前の状況確認時、リリース前のドキュメント品質チェック時に手動で実行される。

**主要な処理内容**：
1. XMLクラスリファレンスファイルの解析
2. 各クラスのドキュメント記述状況（brief_description、description、メソッド、定数、メンバー等）の集計
3. カラー表示による視覚的な進捗表示（緑=完了、赤=未記述等）
4. フィルタリング機能（未完了のみ、完了のみ等）
5. 総合進捗率の算出と表示

**前後の処理との関連**：make_rst.pyでRSTを生成する前に、このスクリプトでドキュメントの完成度を確認することが推奨される。

**影響範囲**：読み取り専用のスクリプトであり、ファイルシステムへの書き込みは行わない。標準出力にレポートを表示する。

## バッチ種別

ドキュメント生成 / レポート生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python 3 | Python 3.x環境がインストールされていること |
| XMLファイル | doc/classes配下にXMLクラスリファレンスが存在すること |
| ターミナル | カラー表示を使用するためANSI対応ターミナルが推奨 |

### 実行可否判定

クラスディレクトリが1つ以上指定されていない場合は、ヘルプを表示して終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| classes_dir | ディレクトリパス | Yes | - | XMLファイルを含むディレクトリ |
| class_names | 文字列（可変長） | No | * | フィルタリング対象クラス名（ワイルドカード対応） |
| -c / --colors | フラグ | No | TTY依存 | カラー出力の切り替え |
| -b / --only-bad | フラグ | No | false | 未完了クラスのみ表示 |
| -g / --only-good | フラグ | No | false | 完了クラスのみ表示 |
| -s / --status | フラグ | No | false | ステータスコメントを表示 |
| -u / --urls | フラグ | No | false | ドキュメントURLを表示 |
| -p / --percent | フラグ | No | false | パーセンテージ表示 |
| -o / --overall | フラグ | No | true | 総合カラムを表示 |
| -i / --collapse | フラグ | No | false | 項目カラムを折りたたみ |
| -a / --all | フラグ | No | true | すべての項目を表示 |
| -e / --empty | フラグ | No | false | 空の項目を非表示 |
| -h / --help | フラグ | No | false | ヘルプを表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| {classes_dir}/*.xml | XML | クラスリファレンスXMLファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト（テーブル形式） | ドキュメント状況レポート |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | - （ファイル出力なし） |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | パイプ（|）区切りテーブル |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ 短縮フラグ（-c, -b等）と長形式フラグ（--colors等）を解析
2. フラグ設定適用
   └─ 各フラグのデフォルト値をトグル
3. ヘルプ表示判定
   └─ -hフラグまたはディレクトリ未指定時にヘルプ表示して終了
4. XMLファイル読み込み
   └─ 指定ディレクトリ内の全XMLファイルを読み込み
5. クラスフィルタリング
   └─ 指定されたクラス名パターンでフィルタリング（fnmatch使用）
6. 各クラスの状況分析
   └─ brief_description, description, methods, constants等の記述状況を集計
7. 総合進捗率算出
   └─ 全クラスの総合進捗を計算
8. テーブル形式で出力
   └─ カラムサイズを調整してフォーマット出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{ヘルプ表示?}
    C -->|Yes| D[ヘルプ出力・終了]
    C -->|No| E[XMLファイル読み込み]
    E --> F[クラス名でフィルタリング]
    F --> G[各クラスの状況分析]
    G --> H[フラグに応じたフィルタリング]
    H --> I[総合進捗率算出]
    I --> J[テーブル形式で出力]
    J --> K[Total行出力]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

このバッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 0 | 正常終了 | クラスが見つからない場合 | "No classes suitable for printing!" を出力 |
| 1 | 引数エラー | 不明なフラグが指定された | 正しいフラグを指定 |
| 255 | XMLエラー | タグ不一致 | XMLファイルを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

バッチ失敗時は、エラーメッセージを確認し、以下を確認する：
1. XMLファイルが存在し、正しい形式か
2. 指定したフラグが正しいか
3. ディレクトリパスが正しいか

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百のXMLファイル |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | XMLパース処理に依存 |

## 排他制御

読み取り専用のため、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 不明フラグ指定時 | "Unknown command line flag: {flag}" |
| エラーログ | ディレクトリ未指定時 | "Invalid usage: Please specify a classes directory" |
| 結果ログ | 全クラスOK時 | "All listed classes are OK!" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 手動確認 |

## 備考

- カラーコードはANSIエスケープシーケンスを使用（赤=未記述、黄=一部記述、緑=完了）
- overall_progress_description_weight（デフォルト10）により、descriptionの重みづけを調整可能
- テーブル出力時、ヘッダーは上下に表示され（-aフラグ有効時）、スクロール時の参照を容易にする
- クラス名のワイルドカードフィルタリングにはfnmatchモジュールを使用
- 各項目の進捗は「記述済み/合計」形式で表示され、-pフラグでパーセンテージも併記される
