# バッチ設計書 16-update-thorvg.sh

## 概要

本ドキュメントは、Godotエンジンプロジェクトにおけるupdate-thorvg.shバッチ処理の設計仕様を定義する。このバッチは、ThorVGライブラリをGitHubから取得し、Godotエンジンのthirdpartyディレクトリに更新するシェルスクリプトである。

### 本バッチの処理概要

このバッチは、ThorVG（軽量SVG/Lottieレンダリングライブラリ）の特定バージョンまたはコミットをダウンロードし、Godotエンジンで必要なファイルのみを抽出して配置する自動更新スクリプトである。

**業務上の目的・背景**：GodotエンジンはSVGアイコンやベクターグラフィックスのレンダリングにThorVGライブラリを使用している。サードパーティライブラリの更新は、セキュリティパッチの適用、バグ修正、新機能の取り込みのために定期的に必要となる。このスクリプトにより、更新作業を自動化し、一貫性のある方法でライブラリを管理できる。

**バッチの実行タイミング**：ThorVGの新バージョンリリース時、セキュリティ修正が必要な場合、または機能追加のために随時手動で実行される。

**主要な処理内容**：
1. 既存のThorVGファイル（AUTHORS, LICENSE, inc/, src/）を削除
2. GitHubからThorVGのtar.gzアーカイブをダウンロード
3. アーカイブを一時ディレクトリに展開
4. 不要なビルドファイル（meson.build）を削除
5. ソースファイルの末尾に改行を追加（コーディング規約対応）
6. 必要なファイルのみをthirdparty/thorvgにコピー
7. Godot用のconfig.hを生成
8. 一時ファイルをクリーンアップ

**前後の処理との関連**：更新後はGodotエンジン全体のビルドを実行し、ThorVGの動作確認を行う必要がある。

**影響範囲**：thirdparty/thorvgディレクトリ全体が更新される。ビルドシステムおよびSVG/Lottieレンダリング機能に影響する。

## バッチ種別

サードパーティ更新

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ライブラリ更新時） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| bash | bashシェルが利用可能であること |
| curl | curlコマンドが利用可能であること |
| tar | tarコマンドが利用可能であること |
| sed | sedコマンドが利用可能であること |
| ネットワーク | GitHubへの接続が可能であること |

### 実行可否判定

スクリプトはthirdparty/thorvgディレクトリから実行されることを前提とする（pushd/popdで管理）。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VERSION | スクリプト内変数 | - | 0.15.16 | ThorVGのバージョン番号 |
| GIT_COMMIT | スクリプト内変数 | - | 未設定 | 特定コミットハッシュ（バージョンの代わりに使用） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub thorvg/thorvg | tar.gz | ThorVGソースアーカイブ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| thirdparty/thorvg/AUTHORS | テキスト | ライブラリ著者情報 |
| thirdparty/thorvg/LICENSE | テキスト | ライセンスファイル |
| thirdparty/thorvg/inc/ | ヘッダー | 公開ヘッダーファイル |
| thirdparty/thorvg/inc/config.h | ヘッダー | Godot用設定ファイル（自動生成） |
| thirdparty/thorvg/src/ | ソース | ソースコードファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各種（AUTHORS, LICENSE, *.h, *.cpp） |
| 出力先 | thirdparty/thorvg/ |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. 作業ディレクトリ移動
   └─ thirdparty/thorvgディレクトリに移動（pushd）
2. 既存ファイル削除
   └─ AUTHORS, LICENSE, inc/, src/, *.zip, *.tar.gz, tmp/を削除
3. 一時ディレクトリ作成
   └─ tmp/ディレクトリを作成
4. アーカイブダウンロード
   └─ GIT_COMMIT設定時はコミットハッシュ、未設定時はVERSIONタグを使用
5. アーカイブ展開
   └─ tar --strip-components=1で展開
6. ビルドファイル削除
   └─ meson.buildファイルを削除
7. 改行修正
   └─ 全.h/.cppファイルの末尾に改行を追加
8. ファイルコピー
   └─ AUTHORS, LICENSE, inc/をコピー
9. config.h生成
   └─ Godot用の設定ヘッダーを生成
10. src/ディレクトリ作成・コピー
    └─ common, renderer, loadersをコピー
    └─ 不要なレンダラー（gl_engine, wg_engine）を削除
11. クリーンアップ
    └─ tmp/ディレクトリを削除
12. 作業ディレクトリ復帰
    └─ popd
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[既存ファイル削除]
    B --> C[一時ディレクトリ作成]
    C --> D{GIT_COMMIT設定?}
    D -->|Yes| E[コミットからダウンロード]
    D -->|No| F[バージョンタグからダウンロード]
    E --> G[アーカイブ展開]
    F --> G
    G --> H[meson.build削除]
    H --> I[ソースファイル改行修正]
    I --> J[AUTHORS/LICENSE/inc/コピー]
    J --> K[config.h生成]
    K --> L[src/ディレクトリ構成]
    L --> M[不要レンダラー削除]
    M --> N[一時ディレクトリ削除]
    N --> O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

このバッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ネットワークエラー | GitHubへの接続失敗 | ネットワーク接続を確認 |
| - | ダウンロードエラー | 指定バージョン/コミットが存在しない | VERSION/GIT_COMMIT値を確認 |
| - | 権限エラー | ファイル削除/作成権限がない | 適切な権限で実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

バッチ失敗時は、以下を確認する：
1. ネットワーク接続状態
2. 指定したバージョン/コミットがGitHubに存在するか
3. thirdparty/thorvgディレクトリへの書き込み権限
4. curlおよびtarコマンドの動作

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ライブラリ更新 |
| 目標処理時間 | 数十秒〜数分（ネットワーク速度依存） |
| メモリ使用量上限 | tar展開に依存 |

## 排他制御

同時実行は推奨されない。一時ディレクトリが競合する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ダウンロード開始時 | "Updating ThorVG to tagged release: {VERSION}" または "Updating ThorVG to commit: {GIT_COMMIT}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 手動確認 |

## 備考

- スクリプトは`set -e`オプションにより、エラー発生時に即座に終了する
- config.hではTHORVG_SW_RASTER_SUPPORT、THORVG_SVG_LOADER_SUPPORT、THORVG_PNG_LOADER_SUPPORTがデフォルトで有効
- THORVG_THREAD_SUPPORTはWEB_ENABLED以外でのみ有効（WebAssemblyではスレッドサポートが制限されるため）
- THORVG_WEBP_LOADER_SUPPORT、THORVG_JPG_LOADER_SUPPORTは個別モジュール有効時に条件付きで追加
- gl_engine、wg_engineはGodotで使用しないため削除される（sw_engineのみ使用）
- ローカルのgitチェックアウトからの更新もコメントとして残されている（開発者向け）
