# バッチ設計書 17-update-sdl.sh

## 概要

本ドキュメントは、Godotエンジンプロジェクトにおけるupdate-sdl.shバッチ処理の設計仕様を定義する。このバッチは、SDL3ライブラリをGitHubから取得し、Godotエンジンのthirdpartyディレクトリに更新するシェルスクリプトである。

### 本バッチの処理概要

このバッチは、SDL3（Simple DirectMedia Layer）の特定バージョンをダウンロードし、Godotエンジンで必要最小限のファイルのみを抽出して配置する自動更新スクリプトである。ジョイスティック、ハプティクス、センサー等のマルチプラットフォーム入力機能に使用される。

**業務上の目的・背景**：GodotエンジンはSDL3を使用してジョイスティック、ハプティクス（触覚フィードバック）、センサー入力などのマルチプラットフォーム対応を実現している。サードパーティライブラリの更新は、新しいコントローラーのサポート、バグ修正、パフォーマンス改善のために必要となる。このスクリプトにより、必要最小限のソースコードのみを抽出し、ビルド時間とリポジトリサイズを最適化できる。

**バッチの実行タイミング**：SDL3の新バージョンリリース時、コントローラーサポートの問題修正時、または機能追加のために随時手動で実行される。

**主要な処理内容**：
1. 既存のSDLファイルを削除
2. GitHubからSDL3のtar.gzアーカイブをダウンロード
3. アーカイブを一時ディレクトリに展開
4. ライセンスファイルとヘッダーファイルをコピー
5. 必要なソースディレクトリ（core, events, haptic, joystick, sensor等）のみを抽出
6. プラットフォーム固有のファイル（darwin, linux, windows）をコピー
7. HIDAPIライブラリを抽出
8. 一時ファイルをクリーンアップ

**前後の処理との関連**：更新後はGodotエンジン全体のビルドを実行し、入力デバイスの動作確認を行う必要がある。patchesフォルダにパッチがある場合は再適用が必要。

**影響範囲**：thirdparty/sdlディレクトリ全体が更新される。ジョイスティック、ハプティクス、センサー入力機能に影響する。

## バッチ種別

サードパーティ更新

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ライブラリ更新時） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| bash | bashシェルが利用可能であること |
| curl | curlコマンドが利用可能であること |
| tar | tarコマンドが利用可能であること |
| ネットワーク | GitHubへの接続が可能であること |

### 実行可否判定

スクリプトは自動的にthirdparty/sdlディレクトリに移動して実行する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| VERSION | スクリプト内変数 | - | 3.2.28 | SDL3のバージョン番号 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub libsdl-org/SDL | tar.gz | SDL3ソースアーカイブ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| thirdparty/sdl/CREDITS.md | Markdown | クレジット情報 |
| thirdparty/sdl/LICENSE.txt | テキスト | ライセンスファイル |
| thirdparty/sdl/include/ | ヘッダー | SDL3公開ヘッダー |
| thirdparty/sdl/*.c, *.h | ソース | コア機能ソースコード |
| thirdparty/sdl/{events,haptic,joystick,sensor,...}/ | ソース | 機能別ソースディレクトリ |
| thirdparty/sdl/hidapi/ | ソース | HIDAPIライブラリ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各種（*.h, *.c, LICENSE.txt等） |
| 出力先 | thirdparty/sdl/ |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. 作業ディレクトリ設定
   └─ realpath で絶対パスを取得し移動
2. 既存ファイル削除
   └─ 各機能ディレクトリとファイルを削除
3. 一時ディレクトリ作成
   └─ tmpディレクトリを作成
4. アーカイブダウンロード
   └─ GitHubからrelease-{VERSION}.tar.gzをダウンロード
5. アーカイブ展開
   └─ tar --strip-components=1で展開
6. ライセンス/クレジットコピー
   └─ CREDITS.md, LICENSE.txtをコピー
7. ヘッダーファイルコピー
   └─ include/をコピーし不要ファイルを削除
8. 共有依存ソースコピー
   └─ *.c, *.h, atomic/, libm/, stdlib/をコピー
9. イベント/IOソースコピー
   └─ 必要なファイルのみ選択してコピー
10. プラットフォーム固有ソースコピー
    └─ core/, haptic/, joystick/, loadso/, sensor/, thread/, timer/
11. HIDAPIコピー
    └─ hidapi/ディレクトリ構造を作成しコピー
12. クリーンアップ
    └─ tmp/ディレクトリを削除
13. 完了メッセージ出力
    └─ git statusとパッチ適用の注意を表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[既存ファイル削除]
    B --> C[一時ディレクトリ作成]
    C --> D[GitHubからダウンロード]
    D --> E[アーカイブ展開]
    E --> F[ライセンス/ヘッダーコピー]
    F --> G[共有ソースコピー]
    G --> H[イベント/IOソースコピー]
    H --> I[プラットフォーム固有ソースコピー]
    I --> J[HIDAPIコピー]
    J --> K[一時ディレクトリ削除]
    K --> L[完了メッセージ出力]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

このバッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ネットワークエラー | GitHubへの接続失敗 | ネットワーク接続を確認 |
| - | ダウンロードエラー | 指定バージョンが存在しない | VERSION値を確認 |
| - | 権限エラー | ファイル削除/作成権限がない | 適切な権限で実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

バッチ失敗時は、以下を確認する：
1. ネットワーク接続状態
2. 指定したバージョンがGitHubに存在するか
3. thirdparty/sdlディレクトリへの書き込み権限
4. curlおよびtarコマンドの動作

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ライブラリ更新 |
| 目標処理時間 | 数十秒〜数分（ネットワーク速度依存） |
| メモリ使用量上限 | tar展開に依存 |

## 排他制御

同時実行は推奨されない。一時ディレクトリが競合する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ダウンロード開始時 | "Updating SDL3 to version: {VERSION}" |
| 完了ログ | 処理完了時 | "SDL3 source code copied successfully..." |
| 注意ログ | 処理完了時 | "Make sure to re-apply patches from the 'patches' folder..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 手動確認 |

## 備考

- スクリプトは`set -e`オプションにより、エラー発生時に即座に終了する
- 必要最小限のファイルのみをコピーすることで、ビルド対象とリポジトリサイズを最適化
- ヘッダーから不要なファイル（SDL_egl, SDL_gpu, SDL_opengl*, SDL_test*, SDL_vulkan）を削除
- thread/genericディレクトリは複数プラットフォームで共有されるセマフォ、条件変数、RWロック実装を含む
- macOSはUnixドライバとgeneric/SDL_syssem.cを使用
- WindowsドライバはsyscondとsysrwlockのWindows実装を使用
- 更新後は`git status`で新規ファイルを確認し、patchesフォルダのパッチを再適用する必要がある
