# バッチ設計書 18-godot_update_embree.py

## 概要

本ドキュメントは、Godotエンジンプロジェクトにおけるgodot_update_embree.pyバッチ処理の設計仕様を定義する。このバッチは、Embreeライブラリ（Intel製レイトレーシングカーネル）をGitHubから取得し、Godotエンジンのthirdpartyディレクトリに更新するPythonスクリプトである。

### 本バッチの処理概要

このバッチは、Embree4の特定バージョン（Gitタグ指定）をクローンし、Godotエンジンで必要なファイルのみを抽出して配置する自動更新スクリプトである。レイキャストモジュールで使用される高速レイトレーシング機能を提供する。

**業務上の目的・背景**：GodotエンジンはEmbreeライブラリを使用してライトマップベイキングやオクルージョンカリングなどの高速レイトレーシング処理を実現している。Embreeはインテルが開発する高性能レイトレーシングカーネルで、定期的なバージョン更新によりパフォーマンス改善やバグ修正が提供される。このスクリプトにより、必要なソースファイルとヘッダーのみを抽出し、Godotプロジェクトに適した形式で配置できる。

**バッチの実行タイミング**：Embreeの新バージョンリリース時、レイトレーシング機能の問題修正時、または機能追加のために随時手動で実行される。

**主要な処理内容**：
1. 既存のembreeディレクトリを削除
2. GitHubからEmbreeリポジトリをクローン
3. 指定したGitタグをチェックアウト
4. コミットハッシュを記録したhash.hを生成
5. 必要なヘッダーファイルとソースファイルを抽出
6. 設定ファイル（config.h, rtcore_config.h）を生成
7. バージョン情報を設定ファイルに書き込み
8. Godot用パッチを自動適用
9. 一時ファイルをクリーンアップ

**前後の処理との関連**：更新後はGodotエンジン全体のビルドを実行し、レイキャスト機能の動作確認を行う必要がある。

**影響範囲**：thirdparty/embreeディレクトリ全体が更新される。レイキャストモジュール、ライトマップベイキング、オクルージョンカリング機能に影響する。

## バッチ種別

サードパーティ更新

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ライブラリ更新時） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python 3.x | Python 3環境がインストールされていること |
| Git | gitコマンドが利用可能であること |
| ネットワーク | GitHubへの接続が可能であること |
| modules/raycast | スクリプトはmodules/raycastディレクトリに配置されていること |

### 実行可否判定

スクリプトはmodules/raycastディレクトリから実行され、自動的にthirdpartyディレクトリに移動する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| git_tag | スクリプト内変数 | - | v4.4.0 | Embreeのバージョンタグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub embree/embree | Git | Embreeソースリポジトリ |
| embree/patches/*.patch | パッチ | Godot用カスタムパッチ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| thirdparty/embree/LICENSE.txt | テキスト | ライセンスファイル |
| thirdparty/embree/include/embree4/ | ヘッダー | 公開ヘッダーファイル |
| thirdparty/embree/common/ | ソース | 共通ユーティリティ |
| thirdparty/embree/kernels/ | ソース | レイトレーシングカーネル |
| thirdparty/embree/kernels/hash.h | ヘッダー | コミットハッシュ記録 |
| thirdparty/embree/kernels/config.h | ヘッダー | ビルド設定 |
| thirdparty/embree/include/embree4/rtcore_config.h | ヘッダー | ランタイム設定 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各種（*.h, *.cpp, LICENSE.txt等） |
| 出力先 | thirdparty/embree/ |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. 作業ディレクトリ移動
   └─ thirdpartyディレクトリに移動
2. 既存ディレクトリ削除
   └─ embreeおよびembree-tmpディレクトリを削除
3. リポジトリクローン
   └─ GitHubからembreeリポジトリをembree-tmpにクローン
4. タグチェックアウト
   └─ 指定したgit_tagをチェックアウト
5. コミットハッシュ取得
   └─ git rev-parse HEADでコミットハッシュを取得
6. .gitディレクトリ削除
   └─ Windowsの読み取り専用ファイル対応付きで削除
7. ファイル収集
   └─ include_dirs, cpp_files, config_files, license_fileを収集
8. ヘッダーファイル収集
   └─ 各include_dirから*.hファイルを取得
9. ファイルコピー
   └─ 必要なファイルをembreeディレクトリにコピー
10. hash.h生成
    └─ コミットハッシュを含むhash.hを作成
11. config.h生成
    └─ config.h.inを.h形式に変換
12. rtcore_config.h更新
    └─ バージョン番号をCMakeLists.txtから抽出して書き込み
13. 一時ディレクトリ削除
    └─ embree-tmpを削除
14. パッチ復元
    └─ git restoreでpatchesディレクトリを復元
15. パッチ適用
    └─ git applyで各パッチを適用
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[既存embreeディレクトリ削除]
    B --> C[GitHubからクローン]
    C --> D[タグチェックアウト]
    D --> E[コミットハッシュ取得]
    E --> F[.gitディレクトリ削除]
    F --> G[必要ファイル収集]
    G --> H[ファイルコピー]
    H --> I[hash.h生成]
    I --> J[config.h生成]
    J --> K[rtcore_config.h更新]
    K --> L[一時ディレクトリ削除]
    L --> M[パッチ復元・適用]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

このバッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ネットワークエラー | GitHubへの接続失敗 | ネットワーク接続を確認 |
| - | タグエラー | 指定タグが存在しない | git_tag値を確認 |
| - | 権限エラー | ファイル削除/作成権限がない | 適切な権限で実行 |
| - | パッチエラー | パッチ適用失敗 | パッチファイルの内容を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

バッチ失敗時は、以下を確認する：
1. ネットワーク接続状態
2. 指定したGitタグがGitHubに存在するか
3. thirdpartyディレクトリへの書き込み権限
4. patchesディレクトリのパッチファイルが最新か

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ライブラリ更新 |
| 目標処理時間 | 数分（ネットワーク速度・リポジトリサイズ依存） |
| メモリ使用量上限 | gitクローン・ファイル操作に依存 |

## 排他制御

同時実行は推奨されない。一時ディレクトリとembreeディレクトリが競合する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | git clone時 | gitコマンドの出力 |
| 標準出力 | git checkout時 | gitコマンドの出力 |
| 標準出力 | git apply時 | パッチ適用の出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 手動確認 |

## 備考

- スクリプトはmodules/raycastディレクトリに配置されているが、実行時にthirdpartyに移動する
- include_dirs、cpp_filesリストは必要最小限のファイルを明示的に指定している
- Windowsでは.gitディレクトリ内の読み取り専用ファイルの削除にon_rm_errorハンドラを使用
- Python 3.12以降ではshutil.rmtreeのonexcパラメータを使用、それ以前はonerrorを使用
- CMakeLists.txtからEMBREE_VERSION_MAJOR/MINOR/PATCHを正規表現で抽出
- rtcore_config.hのRTC_VERSION定義を動的に更新（例：RTC_VERSION 40400）
- BVH（Bounding Volume Hierarchy）関連のカーネルがレイトレーシングの中核機能を提供
- パッチはembree/patchesディレクトリに保存され、更新時に自動適用される
