# バッチ設計書 19-purge_cache.py

## 概要

本ドキュメントは、Godotエンジンプロジェクトにおけるpurge_cache.pyバッチ処理の設計仕様を定義する。このバッチは、指定されたキャッシュディレクトリ内の古いキャッシュファイルを削除するクリーンアップスクリプトである。

### 本バッチの処理概要

このバッチは、指定されたタイムスタンプ（Unixエポック秒）より古いアクセス時刻を持つキャッシュファイルを削除するPythonスクリプトである。ビルドキャッシュやCI/CDパイプラインで生成される一時ファイルの管理に使用される。

**業務上の目的・背景**：Godotエンジンのビルドプロセスでは、コンパイル高速化のためにキャッシュが使用される。しかし、キャッシュファイルは時間とともに蓄積され、ディスク容量を圧迫する。特にCI/CD環境では、古いキャッシュが残ることでストレージコストの増加やビルドの非効率性を招く可能性がある。このスクリプトにより、定期的なキャッシュクリーンアップを自動化し、ストレージ使用量を最適化できる。

**バッチの実行タイミング**：CI/CDパイプラインでの定期的なキャッシュメンテナンス時、またはディスク容量管理のために随時実行される。

**主要な処理内容**：
1. コマンドライン引数からタイムスタンプとキャッシュディレクトリを取得
2. redundant.txtファイルが存在する場合、リストされたファイルを削除
3. キャッシュディレクトリ内のファイルを走査
4. 指定タイムスタンプより古いアクセス時刻を持つファイルを削除
5. 削除失敗ファイルのカウントを終了コードとして返す

**前後の処理との関連**：通常はビルド後のクリーンアップ処理として、またはCIジョブのスケジュールされたメンテナンスタスクとして実行される。

**影響範囲**：指定されたキャッシュディレクトリ内のファイルが削除される。ディレクトリ構造は維持される。

## バッチ種別

ユーティリティ / データクレンジング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（キャッシュメンテナンス時） |
| 実行時刻 | 任意 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 / CI/CDスケジュール |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python 3 | Python 3.x環境がインストールされていること |
| キャッシュディレクトリ | 対象のキャッシュディレクトリが存在すること |
| 書き込み権限 | キャッシュディレクトリへの削除権限があること |

### 実行可否判定

コマンドライン引数でタイムスタンプとディレクトリが指定されていること。argparseにより必須引数が検証される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| timestamp | 整数 | Yes | - | 削除基準のUnixタイムスタンプ（この値より前のファイルを削除） |
| directory | 文字列 | Yes | - | キャッシュディレクトリのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| redundant.txt | テキスト | 削除対象ファイルリスト（オプション） |
| {directory}/*/* | ファイル | キャッシュファイル（2階層下を走査） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 削除失敗ファイルのエラーメッセージ |
| 終了コード | 整数 | 削除失敗ファイル数（0=全成功） |

### 出力ファイル仕様

このバッチはファイル出力を行わない（削除のみ）。

| 項目 | 内容 |
|-----|------|
| ファイル名 | - |
| 出力先 | - |
| 文字コード | - |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ argparseでtimestampとdirectoryを取得
2. redundant.txtチェック
   └─ 存在する場合、リストされたファイルを順次削除
3. キャッシュディレクトリ走査
   └─ glob.globで{directory}/*/*パターンにマッチするファイルを取得
4. アクセス時刻チェック
   └─ os.path.getatimeでファイルのアクセス時刻を取得
5. 条件付き削除
   └─ アクセス時刻がタイムスタンプより古い場合に削除
6. エラーハンドリング
   └─ OSErrorをキャッチし、エラーカウントをインクリメント
7. 終了コード返却
   └─ エラー数を終了コードとして返す
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{redundant.txt存在?}
    C -->|Yes| D[リストファイル削除]
    C -->|No| E[キャッシュディレクトリ走査]
    D --> E
    E --> F{ファイルあり?}
    F -->|No| G[終了コード0で終了]
    F -->|Yes| H[アクセス時刻取得]
    H --> I{タイムスタンプより古い?}
    I -->|Yes| J[ファイル削除]
    I -->|No| K[次のファイル]
    J --> L{削除成功?}
    L -->|Yes| K
    L -->|No| M[エラーカウント++]
    M --> K
    K --> F
    G --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

このバッチはデータベースを使用しない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N（N>0） | 削除エラー | N個のファイル削除に失敗 | エラーメッセージを確認し、権限や使用中ファイルを確認 |
| - | 引数エラー | 必須引数が不足 | 正しい引数を指定 |
| - | ディレクトリエラー | 指定ディレクトリが存在しない | パスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

バッチ失敗時は、以下を確認する：
1. 指定したディレクトリへのアクセス権限
2. ファイルが他のプロセスで使用中でないか
3. ファイルシステムの状態（読み取り専用でないか等）

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数千ファイル |
| 目標処理時間 | ファイル数に比例（数秒〜数分） |
| メモリ使用量上限 | ファイルリスト保持に依存 |

## 排他制御

キャッシュファイルが他のプロセスで使用中の場合、削除に失敗する可能性がある。エラーはスキップされ、カウントされる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 削除失敗時 | 'Failed to handle "{file}"; skipping.' |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDシステム |

## 備考

- このスクリプトはモジュールとしてインポートすることを想定していない（`if __name__ != "__main__":`でImportErrorを発生）
- redundant.txtはハードコードされたパスで、TODOコメントとして非ハードコード化が記載されている
- glob.globパターン`*/*/*`は2階層下のファイルを対象とし、ディレクトリ構造を維持
- os.path.getatimeはファイルの最終アクセス時刻を返す（ファイルシステムによっては更新されない場合あり）
- KeyboardInterruptを適切にハンドリングし、SIGINTシグナルで終了
- 終了コードはsys.exit(main())で直接返却される
