# バッチ設計書 2-install_swappy_android.py

## 概要

本ドキュメントは、Android向けSwappy Frame Pacingライブラリの自動インストールを行うPythonスクリプトの設計書です。

### 本バッチの処理概要

このバッチは、Android向けGodotビルドで使用されるSwappy Frame Pacingライブラリを自動的にダウンロードしインストールするスクリプトです。

**業務上の目的・背景**：Swappyは、Googleが提供するAndroid向けのフレームペーシングライブラリです。Godotエンジンは、Androidプラットフォームでのフレームレート安定化とスムーズなゲーム体験を実現するためにSwappyを利用できます。このバッチは、複数アーキテクチャ向けのSwappyライブラリを一括でインストールすることで、Android開発環境のセットアップを簡素化します。

**バッチの実行タイミング**：Android向けGodotビルドの準備として手動で実行されます。Swappyサポートを有効にしてビルドする前に実行が必要です。

**主要な処理内容**：
1. Swappyライブラリのリリースアーカイブをgodotengine/godot-swappyリポジトリからダウンロード
2. 対象の4アーキテクチャ（arm64-v8a、armeabi-v7a、x86、x86_64）の既存インストールを削除
3. ZIPアーカイブから各アーキテクチャのスタティックライブラリを抽出
4. thirdparty/swappy-frame-pacingディレクトリに配置
5. 一時ファイルの削除と完了メッセージの表示

**前後の処理との関連**：本バッチは単独で実行可能です。実行後は`scons platform=android swappy=yes`でSwappyサポートを有効にしたGodotビルドが可能になります。

**影響範囲**：`thirdparty/swappy-frame-pacing/`ディレクトリ配下の各アーキテクチャ別ディレクトリにライブラリファイルがインストールされます。

## バッチ種別

環境構築 / ライブラリ自動インストール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python 3環境 | Python 3.xがインストールされていること |
| インターネット接続 | GitHub（godotengine/godot-swappy）へのアクセスが可能であること |
| 書き込み権限 | thirdparty/ディレクトリへの書き込み権限 |

### 実行可否判定

特別な判定ロジックなし。常に最新版をダウンロードし、既存ファイルを上書きします。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| https://github.com/godotengine/godot-swappy/releases/download/{tag}/godot-swappy.zip | ZIP | Swappyライブラリアーカイブ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| thirdparty/swappy-frame-pacing/{arch}/libswappy_static.a | 静的ライブラリ | 各アーキテクチャのSwappyライブラリ |
| 標準出力 | テキスト | 進捗・結果メッセージ（カラー出力対応） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | libswappy_static.a |
| 出力先 | thirdparty/swappy-frame-pacing/{arm64-v8a,armeabi-v7a,x86,x86_64}/ |
| 文字コード | N/A（バイナリ） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 一時ファイル確認・削除
   └─ 既存の一時アーカイブがあれば削除
2. Swappyアーカイブダウンロード
   └─ GitHubからgodot-swappy.zipをダウンロード
3. 既存インストール削除
   └─ 4アーキテクチャの既存ディレクトリを削除
4. アーカイブ展開
   └─ 各アーキテクチャのlibswappy_static.aを抽出
5. クリーンアップ
   └─ 一時ファイル削除
6. 完了メッセージ表示
   └─ カラー出力で成功メッセージ
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[一時ファイル確認・削除]
    B --> C[Swappyアーカイブダウンロード]
    C --> D[各アーキテクチャの既存ディレクトリ削除]
    D --> E[ZIPファイルから各アーキテクチャを展開]
    E --> F[一時ファイル削除]
    F --> G[成功メッセージ表示]
    G --> H[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| urllib.error | ネットワークエラー | GitHubへの接続失敗 | ネットワーク接続を確認して再実行 |
| PermissionError | 権限エラー | ディレクトリへの書き込み不可 | 権限を確認して再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. ダウンロード失敗：ネットワーク接続を確認し、再実行
2. 権限エラー：適切な権限でスクリプトを実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 4アーキテクチャ分のライブラリ |
| 目標処理時間 | ネットワーク速度に依存（数秒〜数十秒） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は想定されていません。複数回実行した場合、既存ファイルは削除後に再インストールされます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | ダウンロード開始時 | "Downloading Swappy {tag} ..." |
| 情報ログ | 削除時 | "Removing existing local Swappy installation in {folder} ..." |
| 情報ログ | 展開時 | "Extracting Swappy {tag} to {folder} ..." |
| 情報ログ | 完了時 | "Swappy installed successfully." |
| 成功ログ | 最終メッセージ | カラー出力で成功メッセージとビルドコマンド案内 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 標準エラー出力 |

## 備考

- Swappyのバージョンは`swappy_tag`変数で指定（現在: from-source-2025-01-31）
- 対象アーキテクチャ: arm64-v8a, armeabi-v7a, x86, x86_64
- カラー出力に`misc/utility/color`モジュールを使用
- インストール後のビルドコマンド: `scons platform=android swappy=yes`
