# バッチ設計書 21-gradlew.bat

## 概要

本ドキュメントは、Godot EngineのAndroidビルドにおけるGradle Wrapperスクリプト（gradlew.bat）の設計仕様を定義します。このバッチファイルはWindows環境でGradleタスクを実行するための起動スクリプトです。

### 本バッチの処理概要

gradlew.batは、Windows環境においてGodot EngineのAndroidプラットフォーム向けビルドを実行するためのGradle Wrapperスクリプトです。Gradle Wrapperは、開発者がGradleを事前にインストールせずとも、プロジェクトで指定されたバージョンのGradleを自動的にダウンロード・使用できる仕組みを提供します。

**業務上の目的・背景**：Godot EngineのAndroidエクスポート機能は、ネイティブライブラリのコンパイル後にGradleを使用してAPK/AABファイルを生成します。gradlew.batは、Windows開発者がAndroid向けビルドを一貫した方法で実行できるようにし、開発環境間でのGradleバージョン差異を解消することで、ビルドの再現性と信頼性を担保します。また、GodotエディタからのAndroidエクスポート時に内部的に呼び出されることで、エンドユーザーがGradleの詳細を意識せずにビルドを実行できるようにしています。

**バッチの実行タイミング**：手動実行または、Godotエディタからのプロジェクトエクスポート時に自動実行されます。開発者がコマンドラインから直接Gradleタスクを実行する際にも使用されます。

**主要な処理内容**：
1. 環境変数の設定とJavaランタイムの検出
2. JAVA_HOME環境変数の検証とjava.exeパスの解決
3. デフォルトJVMオプション（-Xmx64m -Xms64m）の設定
4. CLASSPATHにgradle-wrapper.jarを追加
5. GradleWrapperMainクラスを起動してGradleタスクを実行

**前後の処理との関連**：このスクリプトはSConsによるネイティブライブラリのビルド完了後に実行されることが想定されます。scons コマンドでlibgodot.soなどのネイティブライブラリを生成した後、gradlew.batを使用してGradleビルドタスクを実行し、最終的なAPK/AABファイルを生成します。

**影響範囲**：Godot Android SDK（platform/android/java/）配下のすべてのGradleプロジェクト（lib、app、editor、nativeSrcsConfigs）に影響します。生成されるアーティファクト（APK、AAB、AAR）はbin/ディレクトリに出力されます。

## バッチ種別

ビルド実行 / 環境起動

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / Godotエディタからのエクスポート |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Java JDK 17以上 | JAVA_HOME環境変数が設定されているか、PATHにjava.exeが存在すること |
| Windows OS | Windows NT系のOSで動作（Windows_NT環境変数で判定） |
| gradle-wrapper.jar | platform/android/java/gradle/wrapper/配下に存在すること |
| Gradle 8.11.1 | gradle-wrapper.propertiesで指定されたバージョン |

### 実行可否判定

1. JAVA_HOME環境変数がセットされている場合、%JAVA_HOME%/bin/java.exeの存在を確認
2. JAVA_HOME未設定の場合、PATHからjava.exeを検索し、実行可能か確認
3. Javaが見つからない場合はエラーメッセージを出力して終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %* | String | No | なし | Gradleに渡すすべてのコマンドライン引数（タスク名、オプション等） |
| DEBUG | 環境変数 | No | 空 | 設定時にデバッグモード（echo on）で実行 |
| JAVA_HOME | 環境変数 | No | なし | Javaインストールディレクトリ |
| JAVA_OPTS | 環境変数 | No | なし | 追加のJVMオプション |
| GRADLE_OPTS | 環境変数 | No | なし | Gradle固有のJVMオプション |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| gradle-wrapper.properties | Properties | Gradleディストリビューション情報（バージョン、ダウンロードURL） |
| gradle.properties | Properties | プロジェクトレベルのGradle設定 |
| build.gradle | Groovy DSL | ビルド定義ファイル |
| settings.gradle | Groovy DSL | マルチプロジェクト設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | Gradleビルドログ |
| 標準エラー出力 | テキスト | エラーメッセージ |
| bin/ディレクトリ | APK/AAB/AAR | ビルド成果物（タスクによる） |

### 出力ファイル仕様

タスク実行により生成される主な成果物：

| 項目 | 内容 |
|-----|------|
| ファイル名 | android_debug.apk, android_release.apk, godot-lib.template_*.aar など |
| 出力先 | bin/ または app/build/outputs/ |
| 文字コード | バイナリ |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 環境初期化
   └─ Windows NTシェルの場合、setlocal でローカルスコープ開始
2. パス解決
   └─ スクリプトディレクトリ（DIRNAME）とアプリケーションホーム（APP_HOME）を設定
3. デフォルトJVMオプション設定
   └─ DEFAULT_JVM_OPTS="-Xmx64m" "-Xms64m"
4. Java検出
   ├─ JAVA_HOME設定時：%JAVA_HOME%/bin/java.exe を使用
   └─ JAVA_HOME未設定時：PATHからjava.exeを検索
5. Java検証
   └─ java.exeが存在・実行可能でない場合はエラー終了
6. CLASSPATH設定
   └─ gradle-wrapper.jarをCLASSPATHに追加
7. Gradle実行
   └─ GradleWrapperMainを起動し、コマンドライン引数を渡す
8. 終了処理
   └─ ERRORLEVELに応じた終了コードを返却
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{DEBUG環境変数?}
    B -->|設定あり| C[echo on]
    B -->|設定なし| D[echo off]
    C --> E[パス変数初期化]
    D --> E
    E --> F{JAVA_HOME設定?}
    F -->|Yes| G[JAVA_HOMEからjava.exeパス構築]
    F -->|No| H[PATHからjava.exe検索]
    G --> I{java.exe存在?}
    H --> J{java.exe実行可能?}
    I -->|Yes| K[CLASSPATHにgradle-wrapper.jar設定]
    I -->|No| L[エラー: JAVA_HOME無効]
    J -->|Yes| K
    J -->|No| M[エラー: java未検出]
    L --> N[終了コード1で終了]
    M --> N
    K --> O[GradleWrapperMain実行]
    O --> P{ERRORLEVEL = 0?}
    P -->|Yes| Q[正常終了]
    P -->|No| R[エラー終了]
    Q --> S[endlocal]
    R --> N
    S --> T[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | - |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Java未検出 | JAVA_HOMEが未設定でPATHにjavaがない | JAVA_HOME環境変数を正しく設定 |
| 1 | Java無効 | JAVA_HOMEが無効なディレクトリを指す | JAVA_HOMEを正しいJDKパスに修正 |
| 1 | Gradle実行エラー | Gradleタスク実行失敗 | ビルドログを確認し、原因を調査 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. **Java未検出エラー**: JDK 17以上をインストールし、JAVA_HOME環境変数を設定
2. **Gradle実行エラー**:
   - `--stacktrace`オプションで詳細なスタックトレースを取得
   - `--info`または`--debug`オプションで詳細ログを出力
   - `gradle/wrapper/gradle-wrapper.properties`のGradleバージョンを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ビルドスクリプト） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/実行 |
| 目標処理時間 | タスク依存（通常数分〜数十分） |
| メモリ使用量上限 | 64MB初期、gradle.propertiesで4536MBに拡張 |

## 排他制御

- 同一ディレクトリでの同時実行は推奨されない
- Gradleデーモンがファイルロックを取得するため、競合する可能性がある
- `--no-daemon`オプションでデーモンモードを無効化可能

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | Gradle起動時 | ビルド構成情報 |
| 進捗ログ | タスク実行中 | 各タスクの実行状況 |
| 終了ログ | ビルド完了時 | BUILD SUCCESSFUL/FAILED、所要時間 |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース（オプション） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | プロジェクト依存 | コンソール出力 |
| エラー件数 | 1件以上 | コンソール出力、終了コード |

## 備考

### 主要なGradleタスク

本Gradle Wrapperで実行可能な主要タスク：

| タスク名 | 説明 |
|---------|------|
| `generateGodotTemplates` | Godotテンプレート（APK、AAR）を生成 |
| `generateGodotEditor` | Android向けGodotエディタを生成 |
| `generateGodotHorizonOSEditor` | HorizonOS向けエディタを生成 |
| `generateGodotPicoOSEditor` | PicoOS向けエディタを生成 |
| `clean` | ビルド成果物をクリーン |
| `zipGradleBuild` | Gradleビルドテンプレートをzip化 |

### 対応プラットフォーム

- gradlew.bat: Windows専用
- gradlew: Unix/Linux/macOS用（同等機能）

### 関連ファイル

- `platform/android/java/gradlew` - Unix版Gradle Wrapper
- `platform/android/java/gradle/wrapper/gradle-wrapper.jar` - Wrapper JAR
- `platform/android/java/gradle/wrapper/gradle-wrapper.properties` - Wrapperプロパティ
- `platform/android/java/gradle.properties` - Gradleプロジェクト設定
- `platform/android/java/build.gradle` - ルートビルド定義
- `platform/android/java/settings.gradle` - マルチプロジェクト設定
