# バッチ設計書 3-install_d3d12_sdk_windows.py

## 概要

本ドキュメントは、Windows向けDirect3D 12 SDK依存関係の自動インストールを行うPythonスクリプトの設計書です。

### 本バッチの処理概要

このバッチは、Windows環境でGodotエンジンをDirect3D 12サポート付きでビルドするために必要な複数のSDKコンポーネントを一括でインストールするスクリプトです。

**業務上の目的・背景**：Godotエンジンは、WindowsプラットフォームでDirect3D 12レンダリングバックエンドをサポートしています。D3D12ビルドには、Mesa NIR（シェーダーコンパイラ）、WinPixEventRuntime（GPU解析ツール）、DirectX 12 Agility SDK（最新D3D12機能）の3つのコンポーネントが必要です。このバッチは、これらの依存関係を自動的にダウンロード・インストールすることで、開発者のセットアップ作業を大幅に簡素化します。

**バッチの実行タイミング**：Windows向けGodotビルドの準備として手動で実行されます。D3D12サポートを有効にしてビルドする前に実行が必要です。クロスコンパイル環境でも使用可能です。

**主要な処理内容**：
1. Mesa NIR（8つのアーキテクチャ/コンパイラ組み合わせ）のダウンロード・インストール
2. WinPixEventRuntimeのダウンロード・インストール（MinGW対応あり）
3. DirectX 12 Agility SDKのダウンロード・インストール
4. MinGW環境の場合、gendef/dlltoolによるDLL変換処理
5. 各コンポーネントの既存インストール削除と再インストール

**前後の処理との関連**：本バッチは単独で実行可能です。実行後は`scons d3d12=yes`でD3D12サポートを有効にしたGodotビルドが可能になります。MinGW環境でWinPixEventRuntimeを使用する場合は、gendefとdlltoolのインストールが必要です。

**影響範囲**：Windows環境では`%LOCALAPPDATA%\Godot\build_deps\`、クロスコンパイル環境では`bin/build_deps/`にSDKがインストールされます。

## バッチ種別

環境構築 / SDK自動インストール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python 3環境 | Python 3.xがインストールされていること |
| インターネット接続 | GitHub、NuGetへのアクセスが可能であること |
| 書き込み権限 | 出力ディレクトリへの書き込み権限 |
| MinGW（オプション） | MinGWサポートにはgendef、dlltoolが必要 |

### 実行可否判定

特別な判定ロジックなし。常に最新版をダウンロードし、既存ファイルを上書きします。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --mingw_prefix | string | No | MINGW_PREFIX環境変数 | MinGW binフォルダを含むパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| https://github.com/godotengine/godot-nir-static/releases/ | ZIP | Mesa NIRライブラリ |
| https://www.nuget.org/api/v2/package/WinPixEventRuntime/ | nupkg | WinPixEventRuntime |
| https://www.nuget.org/api/v2/package/Microsoft.Direct3D.D3D12/ | nupkg | DirectX 12 Agility SDK |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| {deps_folder}/mesa-{arch}/ | ディレクトリ | Mesa NIRライブラリ |
| {deps_folder}/pix/ | ディレクトリ | WinPixEventRuntime |
| {deps_folder}/agility_sdk/ | ディレクトリ | DirectX 12 Agility SDK |
| 標準出力 | テキスト | 進捗・結果メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | コンポーネント依存 |
| 出力先 | %LOCALAPPDATA%\Godot\build_deps\ または bin/build_deps/ |
| 文字コード | N/A（バイナリ） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ --mingw_prefixオプションの処理
2. 出力ディレクトリ決定
   └─ LOCALAPPDATA有無でパスを分岐
3. [1/3] Mesa NIRインストール
   └─ 8アーキテクチャ分をループ処理
      ├─ ダウンロード
      ├─ 既存削除
      └─ 展開
4. MinGWツール確認
   └─ gendef、dlltoolの存在確認
5. [2/3] WinPixEventRuntimeインストール
   └─ ダウンロード・展開
   └─ MinGW環境の場合DLL変換
6. [3/3] DirectX 12 Agility SDKインストール
   └─ ダウンロード・展開
7. 完了メッセージ表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[出力ディレクトリ決定]
    C --> D[Mesa NIRインストール x8]
    D --> E[MinGWツール確認]
    E --> F[WinPixEventRuntimeインストール]
    F --> G{MinGW環境?}
    G -->|Yes| H[DLL変換処理]
    G -->|No| I[スキップ]
    H --> J[Agility SDKインストール]
    I --> J
    J --> K[完了メッセージ]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| urllib.error | ネットワークエラー | サーバーへの接続失敗 | ネットワーク接続を確認して再実行 |
| PermissionError | 権限エラー | ディレクトリへの書き込み不可 | 権限を確認して再実行 |
| FileNotFoundError | ツール不足 | gendef/dlltool未検出 | MinGWツールをインストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. ダウンロード失敗：ネットワーク接続を確認し、再実行
2. MinGWサポート警告：gendef、dlltoolをインストールするか、--mingw_prefixを指定
3. 権限エラー：適切な権限でスクリプトを実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 3コンポーネント（10回以上のダウンロード） |
| 目標処理時間 | ネットワーク速度に依存（数分程度） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は想定されていません。複数回実行した場合、既存ファイルは削除後に再インストールされます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 見出し | セクション開始 | "[1/3] Mesa NIR" 等 |
| 情報ログ | ダウンロード開始 | "Downloading Mesa NIR {filename} ..." |
| 情報ログ | 削除時 | "Removing existing local ... installation in {folder} ..." |
| 情報ログ | 展開時 | "Extracting ... to {folder} ..." |
| 情報ログ | MinGW対応 | "Adapting WinPixEventRuntime to also support MinGW alongside MSVC." |
| 警告ログ | MinGW不可 | "MinGW support requires \"dlltool\" and \"gendef\" dependencies..." |
| 成功ログ | 完了時 | カラー出力で成功メッセージとビルドコマンド案内 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 標準エラー出力 |

## 備考

- Mesa NIRバージョン: 25.3.1-1
- WinPixEventRuntimeバージョン: 1.0.240308001
- DirectX 12 Agility SDKバージョン: 1.618.5
- Mesa NIR対象アーキテクチャ: arm64-llvm, arm64-msvc, x86_32-gcc, x86_32-llvm, x86_32-msvc, x86_64-gcc, x86_64-llvm, x86_64-msvc
- Agility SDKバージョン更新時は、プロジェクト設定`rendering/rendering_device/d3d12/agility_sdk_version`も更新が必要
- MinGW DLL変換はx64とARM64の両アーキテクチャに対応
- インストール後のビルドコマンド: `scons d3d12=yes`
