# バッチ設計書 4-gitignore_check.sh

## 概要

本ドキュメントは、リポジトリ内で.gitignoreに違反するファイルの検出を行うシェルスクリプトの設計書です。

### 本バッチの処理概要

このバッチは、Gitリポジトリ内に存在するファイルが.gitignoreの設定に違反していないかを検証するCI用のスクリプトです。

**業務上の目的・背景**：大規模なコードベースを持つGodotプロジェクトでは、ビルド成果物や一時ファイルが誤ってリポジトリにコミットされる可能性があります。このバッチは、.gitignoreで無視されるべきファイルがリポジトリに含まれていないことを自動的に検証し、コードベースの品質を維持します。CIパイプラインの一部として実行され、違反が検出された場合はビルドを失敗させます。

**バッチの実行タイミング**：CI/CDパイプラインでプルリクエストのチェック時、またはコミット時に自動実行されます。手動でのリポジトリ検証にも使用可能です。

**主要な処理内容**：
1. globstarシェルオプションの有効化（再帰的glob展開）
2. git check-ignoreコマンドでリポジトリ内の全ファイルをチェック
3. --verboseフラグで詳細情報を取得（!プレフィックスによる除外も含む）
4. awkで!プレフィックスの除外エントリをフィルタリング
5. 結果が空なら成功（exit 0）、違反があれば出力して失敗（exit 1）

**前後の処理との関連**：本バッチは他のCI検証スクリプトと並行して実行されます。pre-commitフックや継続的インテグレーションの一部として機能します。

**影響範囲**：リポジトリ全体のファイルを読み取り専用で検証します。ファイルの変更は行いません。

## バッチ種別

品質検証 / 静的解析

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | コミット/PR時 |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | CI/手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Gitリポジトリ | .gitが存在するディレクトリで実行 |
| Bashシェル | shoptコマンドが使用可能であること |
| Git | git check-ignoreコマンドが利用可能 |

### 実行可否判定

特別な判定ロジックなし。Gitリポジトリのルートディレクトリで実行することを推奨。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| .gitignore | テキスト | 無視パターン定義 |
| リポジトリ内全ファイル | ファイル | チェック対象 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 違反ファイル一覧（違反がある場合） |
| 終了コード | 整数 | 0: 成功、1: 違反あり |

### 出力ファイル仕様

本バッチはファイル出力を行いません。

## 処理フロー

### 処理シーケンス

```
1. シェルオプション設定
   └─ set -uo pipefail、shopt -s globstar
2. 検証開始メッセージ
   └─ ".gitignore validation..."
3. git check-ignore実行
   └─ --verbose --no-index **/*
4. awkフィルタリング
   └─ !プレフィックスのエントリを除外
5. 結果判定
   └─ 空なら exit 0、出力があれば exit 1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[シェルオプション設定]
    B --> C[検証開始メッセージ出力]
    C --> D[git check-ignore実行]
    D --> E[awkでフィルタリング]
    E --> F{結果が空?}
    F -->|Yes| G[成功終了 exit 0]
    F -->|No| H[違反一覧出力]
    H --> I[失敗終了 exit 1]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 検証失敗 | .gitignore違反ファイルが存在 | 違反ファイルを削除またはgitignoreを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライ不要） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 違反が検出された場合：出力された違反ファイルを確認
2. 意図的にコミットするファイルの場合：.gitignoreの!プレフィックスで除外設定
3. 不要なファイルの場合：リポジトリから削除

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | リポジトリ内全ファイル |
| 目標処理時間 | 数秒〜数十秒（リポジトリサイズ依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

読み取り専用のため、並行実行可能です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 開始時 | ".gitignore validation..." |
| 結果ログ | 違反検出時 | git check-ignoreの出力（ファイルパス:行番号:gitignoreルール） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1 | CIシステム |

## 備考

- `core.ignorecase=true`オプションでWindowsユーザー向けに大文字小文字を無視
- `--no-index`オプションでインデックス状態に関係なく全ファイルをチェック
- `--verbose`オプションで.gitignoreのどの行にマッチしたかを表示
- awkフィルタは`$3`（gitignoreルール）が`!`で始まるものを除外
- globstar有効化により`**/*`パターンで再帰的にファイルを取得
