# バッチ設計書 5-copyright_headers.py

## 概要

本ドキュメントは、ソースファイルへのGodot著作権ヘッダーの追加・更新を行うPythonスクリプトの設計書です。

### 本バッチの処理概要

このバッチは、指定されたソースファイルにGodotエンジンの標準著作権ヘッダーを自動的に追加または更新するスクリプトです。

**業務上の目的・背景**：オープンソースプロジェクトであるGodotエンジンでは、全てのソースファイルに統一された著作権表記とMITライセンス表記を含める必要があります。手動でヘッダーを管理すると、フォーマットの不統一や表記漏れが発生しやすくなります。このバッチは、ヘッダーの追加・更新を自動化し、ファイル名を含むヘッダーの位置揃えも自動で行うことで、コードベース全体の法的要件への準拠を確保します。

**バッチの実行タイミング**：新規ファイル作成時、既存ファイルのヘッダー修正が必要な場合に手動で実行されます。pre-commitフックやCIパイプラインでの検証にも使用可能です。

**主要な処理内容**：
1. 引数で指定されたファイルパスを受け取り
2. 各ファイルについてテンプレートヘッダーを生成
3. ファイル名を$filenameプレースホルダーに埋め込み（位置揃え付き）
4. 既存のGodotヘッダー（/*********で始まる）を検出して置換
5. 既存ヘッダーがない場合や異なるコメント形式の場合は先頭に追加
6. UTF-8エンコーディング、LF改行コードでファイルを保存

**前後の処理との関連**：本バッチはファイル単位で独立して実行可能です。通常はファイル一覧を生成するスクリプトと組み合わせて使用されます。

**影響範囲**：指定されたソースファイルの先頭部分（著作権ヘッダー領域）が更新されます。

## バッチ種別

品質検証 / コード整形

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 / pre-commit |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python 3環境 | Python 3.xがインストールされていること |
| ファイルアクセス権 | 対象ファイルへの読み書き権限 |

### 実行可否判定

最低1つ以上のファイルパスが引数として指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| files | string[] | Yes | なし | 処理対象のファイルパス（複数指定可） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 対象ソースファイル | テキスト | C/C++/Java等のソースファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 入力ファイル（上書き） | テキスト | ヘッダーが更新されたソースファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力と同じ |
| 出力先 | 入力と同じ |
| 文字コード | UTF-8 |
| 改行コード | LF（Unix形式） |

## 処理フロー

### 処理シーケンス

```
1. 引数検証
   └─ ファイルパスが指定されているか確認
2. 各ファイルについてループ処理
   └─ ファイル名を抽出（os.path.basename）
3. ヘッダーテンプレート生成
   └─ $filenameをファイル名で置換（位置揃え付き）
4. 既存ファイル読み込み
   └─ UTF-8でオープン
5. 先頭の空行スキップ
   └─ ヘッダー開始位置を検出
6. 既存Godotヘッダー判定
   └─ /*********で始まるか確認
7. ヘッダー置換/追加
   └─ 既存ヘッダーを新ヘッダーに置換
8. ファイル書き込み
   └─ UTF-8、LF改行で保存
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数あり?}
    B -->|No| C[エラー終了]
    B -->|Yes| D[ファイルループ開始]
    D --> E[ファイル名抽出]
    E --> F[ヘッダーテンプレート生成]
    F --> G[ファイル読み込み]
    G --> H[先頭空行スキップ]
    H --> I{Godotヘッダー?}
    I -->|Yes| J[既存ヘッダー置換]
    I -->|No| K[ヘッダー追加]
    J --> L[ファイル書き込み]
    K --> L
    L --> M{次のファイル?}
    M -->|Yes| D
    M -->|No| N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | ファイルパスが指定されていない | ファイルパスを引数として指定 |
| IOError | ファイルエラー | ファイルの読み書きに失敗 | ファイルパスと権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 引数なし：使用方法メッセージを確認し、ファイルパスを指定
2. ファイル読み書きエラー：ファイルの存在と権限を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル単位 |
| コミットタイミング | 各ファイル処理完了時 |
| ロールバック条件 | N/A（ファイル操作） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百ファイル |
| 目標処理時間 | 1ファイルあたり数ミリ秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一ファイルへの同時アクセスは避けること。ファイル単位で排他制御なし。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 引数不足時 | "Invalid usage of copyright_headers.py, it should be called with a path to one or multiple files." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1 | 標準エラー出力 |

## 備考

- 著作権ヘッダーテンプレートは36行のブロックコメント形式
- 著作権年は「2014-present」（現在に至るまで）
- ファイル名の位置揃えは77文字幅の行に対して行われる
- Godotヘッダーは`/*********`で始まる形式を検出
- 既存のGodotヘッダー以外のコメント（例：Doxygen）は保持される
- MITライセンス条文が含まれる
