# バッチ設計書 6-header_guards.py

## 概要

本ドキュメントは、C++ヘッダーファイルのガード形式を#pragma onceに変換するPythonスクリプトの設計書です。

### 本バッチの処理概要

このバッチは、C++ヘッダーファイルのインクルードガードをレガシーな#ifndef/#define/#endif形式から現代的な#pragma once形式に自動変換するスクリプトです。

**業務上の目的・背景**：従来のC++ヘッダーガードは、#ifndef HEADER_H / #define HEADER_H / #endif の3行構造を使用していましたが、#pragma once は1行で同等の機能を提供し、コンパイル時間の短縮とコードの簡潔化に貢献します。Godotプロジェクトでは#pragma once を標準として採用しており、このバッチはレガシーコードの移行や新規コードの検証に使用されます。

**バッチの実行タイミング**：ヘッダーファイル作成時、レガシーコードの移行時、またはCIパイプラインでの検証時に実行されます。

**主要な処理内容**：
1. 引数で指定されたヘッダーファイルのリストを処理
2. 各ファイルのGodotヘッダー（著作権表記）位置を特定
3. ヘッダー直後の#pragma once存在確認
4. レガシーガード（#ifndef/#define/#endif）の検出と変換
5. ガードが存在しない場合は#pragma onceを挿入
6. 修正不可能な場合はinvalidリストに追加

**前後の処理との関連**：copyright_headers.pyと同様に、ファイル一覧生成スクリプトと組み合わせて使用されることが多いです。

**影響範囲**：指定されたC++ヘッダーファイルのインクルードガード部分が更新されます。

## バッチ種別

品質検証 / コード整形

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 / pre-commit |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python 3環境 | Python 3.xがインストールされていること |
| ファイルアクセス権 | 対象ファイルへの読み書き権限 |

### 実行可否判定

最低1つ以上のファイルパスが引数として指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| files | string[] | Yes | なし | 処理対象のヘッダーファイルパス（複数指定可） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| C++ヘッダーファイル | テキスト | .h/.hpp等のヘッダーファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 入力ファイル（上書き） | テキスト | ガードが変換されたヘッダーファイル |
| 標準出力 | テキスト | 修正/要手動対応ファイル一覧 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力と同じ |
| 出力先 | 入力と同じ |
| 文字コード | UTF-8 |
| 改行コード | LF（Unix形式） |

## 処理フロー

### 処理シーケンス

```
1. 引数検証
   └─ ファイルパスが指定されているか確認
2. 各ファイルについてループ処理
   └─ UTF-8で読み込み
3. Godotヘッダー位置特定
   └─ /*********で始まる行を検出
4. ヘッダー終了位置特定
   └─ */で終わるコメント行を検出
5. #pragma once確認
   └─ 既に存在すれば次のファイルへ
6. レガシーガード検出
   └─ #ifndef/#define/#endifパターン確認
7. ガード変換
   └─ #pragma onceに置換、不要行削除
8. ガードなしの場合
   └─ #pragma onceを挿入
9. 結果出力
   └─ FIXED/REQUIRES MANUAL CHANGESを表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数あり?}
    B -->|No| C[エラー終了]
    B -->|Yes| D[ファイルループ開始]
    D --> E[ファイル読み込み]
    E --> F[Godotヘッダー位置特定]
    F --> G{#pragma once存在?}
    G -->|Yes| H[次のファイルへ]
    G -->|No| I{レガシーガード?}
    I -->|Yes| J[#pragma onceに変換]
    I -->|No| K{#pragma once位置不正?}
    K -->|Yes| L[invalidリスト追加]
    K -->|No| M[#pragma once挿入]
    J --> N[ファイル書き込み]
    M --> N
    N --> O[changedリスト追加]
    L --> H
    O --> H
    H --> P{次のファイル?}
    P -->|Yes| D
    P -->|No| Q[結果出力]
    Q --> R{invalid存在?}
    R -->|Yes| S[exit 1]
    R -->|No| T[exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | ファイルパスが指定されていない | ファイルパスを引数として指定 |
| 1 | 変換不可 | 自動変換できないファイルが存在 | 手動で修正が必要 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 引数なし：使用方法メッセージを確認し、ファイルパスを指定
2. REQUIRES MANUAL CHANGES：該当ファイルを手動で確認・修正

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル単位 |
| コミットタイミング | 各ファイル処理完了時 |
| ロールバック条件 | N/A（ファイル操作） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百ファイル |
| 目標処理時間 | 1ファイルあたり数ミリ秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一ファイルへの同時アクセスは避けること。ファイル単位で排他制御なし。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 引数不足時 | "Invalid usage of header_guards.py, it should be called with a path to one or multiple files." |
| 情報ログ | 修正時 | "FIXED: {file}" |
| 警告ログ | 手動対応時 | "REQUIRES MANUAL CHANGES: {file}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1 | 標準エラー出力 |

## 備考

- Godotヘッダーは`/*********`で始まる形式を検出
- レガシーガードは#ifndef、#define、#endifの3行構造
- #pragma onceはGodotヘッダーの2行下に配置
- 変換後の#defineは空行に置換（インデント保持）
- #endifはファイル末尾から削除
- #pragma onceが不正な位置にある場合はinvalidとして報告
- walrus演算子（:=）を使用しているためPython 3.8以上が必要
