# バッチ設計書 8-validate_xml.py

## 概要

本ドキュメントは、XMLドキュメントファイルのスキーマ検証を行うPythonスクリプトの設計書です。

### 本バッチの処理概要

このバッチは、GodotのXMLクラスリファレンスドキュメントが定義されたスキーマ（doc/class.xsd）に準拠しているかを検証するスクリプトです。

**業務上の目的・背景**：Godotエンジンは、各クラスのAPIドキュメントをXML形式で管理しています。これらのXMLファイルはドキュメント生成システムによって処理され、オンラインドキュメントやエディタ内ヘルプに変換されます。XMLスキーマに準拠していないファイルがあると、ドキュメント生成が失敗したり、不正確な情報が表示される原因となります。このバッチは、XMLファイルがスキーマに準拠していることを自動的に検証し、ドキュメント品質を保証します。

**バッチの実行タイミング**：ドキュメント変更時のpre-commitフック、CIパイプラインでの検証時に実行されます。

**主要な処理内容**：
1. 引数で指定されたXMLファイルのリストを受け取り
2. doc/class.xsdスキーマファイルを読み込み
3. 各XMLファイルに対してスキーマ検証を実行
4. 検証エラーがあれば詳細を出力
5. エラー件数に基づいて終了コードを設定

**前後の処理との関連**：ドキュメント生成バッチ（make_rst.py等）の前段として実行され、XMLの整合性を事前に確認します。

**影響範囲**：読み取り専用の検証処理のため、ファイルは変更されません。検証結果のみ出力されます。

## バッチ種別

品質検証 / スキーマ検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動 / pre-commit / CI |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python 3環境 | Python 3.xがインストールされていること |
| xmlschemaモジュール | サードパーティライブラリxmlschemaが必要 |
| リポジトリルート | リポジトリルートから実行する必要あり |
| doc/class.xsd | スキーマファイルが存在すること |

### 実行可否判定

最低1つ以上のXMLファイルパスが引数として指定されていること。リポジトリルートから実行されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| files | string[] | Yes | なし | 検証対象のXMLファイルパス（複数指定可） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| XMLドキュメント | XML | Godotクラスリファレンスファイル |
| doc/class.xsd | XSD | XMLスキーマ定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 検証エラーの詳細 |
| 終了コード | 整数 | エラー件数（0=成功） |

### 出力ファイル仕様

本バッチはファイル出力を行いません（読み取り専用）。

## 処理フロー

### 処理シーケンス

```
1. モジュール実行確認
   └─ __main__での実行を確認
2. 引数解析
   └─ argparseでファイルリスト取得
3. methodsモジュールインポート
   └─ リポジトリルートからprint_errorをインポート
4. スキーマ読み込み
   └─ doc/class.xsdをXMLSchemaオブジェクトに
5. 各XMLファイルについてループ処理
   └─ SCHEMA.validate()で検証
6. エラーハンドリング
   └─ XMLSchemaValidationErrorをキャッチ
7. エラー出力
   └─ print_errorでエラー詳細を表示
8. 終了コード設定
   └─ エラー件数を返却
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{__main__?}
    B -->|No| C[SystemExitエラー]
    B -->|Yes| D[引数解析]
    D --> E{リポジトリルート?}
    E -->|No| F[ImportError]
    E -->|Yes| G[スキーマ読み込み]
    G --> H[XMLファイルループ]
    H --> I[スキーマ検証]
    I --> J{検証成功?}
    J -->|Yes| K{次のファイル?}
    J -->|No| L[エラー出力]
    L --> M[ret++]
    M --> K
    K -->|Yes| H
    K -->|No| N[終了コードretを返却]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N（件数） | 検証エラー | XMLがスキーマに準拠していない | エラー詳細を確認してXMLを修正 |
| SystemExit | モジュール使用 | モジュールとしてインポートされた | スクリプトとして直接実行 |
| ImportError | 実行位置エラー | リポジトリルート以外から実行 | リポジトリルートから実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライ不要） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. XMLSchemaValidationError：エラーメッセージを確認し、該当XMLファイルを修正
2. ImportError：リポジトリルートディレクトリに移動して再実行
3. xmlschemaモジュール未インストール：pre-commitフックで自動インストールまたはpip install xmlschema

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百ファイル |
| 目標処理時間 | 1ファイルあたり数十ミリ秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

読み取り専用のため、並行実行可能です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 検証失敗時 | 'Validation failed for "{file}"!\n\n{err}' |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CIシステム |

## 備考

- xmlschemaライブラリはサードパーティ製（pre-commitフックで自動インストール）
- スキーマファイルは`doc/class.xsd`に固定
- リポジトリルートからの実行が必須（sys.path操作のため）
- KeyboardInterrupt時はSIGINTシグナルを再送（正常終了処理）
- methodsモジュールからprint_error関数をインポート
- 終了コードはエラー件数そのものを返却（0=全成功）
